/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;

public class GetIntentVersionsPublisher
implements SdkPublisher<GetIntentVersionsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetIntentVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIntentVersionsPublisher(LexModelBuildingAsyncClient client, GetIntentVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIntentVersionsPublisher(LexModelBuildingAsyncClient client, GetIntentVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIntentVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIntentVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetIntentVersionsPublisher resume(GetIntentVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetIntentVersionsPublisher(this.client, (GetIntentVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetIntentVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetIntentVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetIntentVersionsResponseFetcher
    implements AsyncPageFetcher<GetIntentVersionsResponse> {
        private GetIntentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIntentVersionsResponse> nextPage(GetIntentVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentVersionsPublisher.this.client.getIntentVersions(GetIntentVersionsPublisher.this.firstRequest);
            }
            return GetIntentVersionsPublisher.this.client.getIntentVersions((GetIntentVersionsRequest)((Object)GetIntentVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

