/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotChannelAssociation;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotChannelAssociationListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBotChannelAssociationsResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetBotChannelAssociationsResponse> {
    private static final SdkField<List<BotChannelAssociation>> BOT_CHANNEL_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetBotChannelAssociationsResponse.getter(GetBotChannelAssociationsResponse::botChannelAssociations)).setter(GetBotChannelAssociationsResponse.setter(Builder::botChannelAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botChannelAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotChannelAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationsResponse.getter(GetBotChannelAssociationsResponse::nextToken)).setter(GetBotChannelAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_CHANNEL_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BotChannelAssociation> botChannelAssociations;
    private final String nextToken;

    private GetBotChannelAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.botChannelAssociations = builder.botChannelAssociations;
        this.nextToken = builder.nextToken;
    }

    public List<BotChannelAssociation> botChannelAssociations() {
        return this.botChannelAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botChannelAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationsResponse)) {
            return false;
        }
        GetBotChannelAssociationsResponse other = (GetBotChannelAssociationsResponse)((Object)obj);
        return Objects.equals(this.botChannelAssociations(), other.botChannelAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetBotChannelAssociationsResponse").add("BotChannelAssociations", this.botChannelAssociations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botChannelAssociations": {
                return Optional.ofNullable(clazz.cast(this.botChannelAssociations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotChannelAssociationsResponse, T> g) {
        return obj -> g.apply((GetBotChannelAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<BotChannelAssociation> botChannelAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationsResponse model) {
            super(model);
            this.botChannelAssociations(model.botChannelAssociations);
            this.nextToken(model.nextToken);
        }

        public final Collection<BotChannelAssociation.Builder> getBotChannelAssociations() {
            return this.botChannelAssociations != null ? (Collection)this.botChannelAssociations.stream().map(BotChannelAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder botChannelAssociations(Collection<BotChannelAssociation> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copy(botChannelAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botChannelAssociations(BotChannelAssociation ... botChannelAssociations) {
            this.botChannelAssociations(Arrays.asList(botChannelAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botChannelAssociations(Consumer<BotChannelAssociation.Builder> ... botChannelAssociations) {
            this.botChannelAssociations(Stream.of(botChannelAssociations).map(c -> (BotChannelAssociation)((BotChannelAssociation.Builder)BotChannelAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBotChannelAssociations(Collection<BotChannelAssociation.BuilderImpl> botChannelAssociations) {
            this.botChannelAssociations = BotChannelAssociationListCopier.copyFromBuilder(botChannelAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotChannelAssociationsResponse build() {
            return new GetBotChannelAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBotChannelAssociationsResponse> {
        public Builder botChannelAssociations(Collection<BotChannelAssociation> var1);

        public Builder botChannelAssociations(BotChannelAssociation ... var1);

        public Builder botChannelAssociations(Consumer<BotChannelAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

