/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelbuilding.model.ChannelConfigurationMapCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.ChannelStatus;
import software.amazon.awssdk.services.lexmodelbuilding.model.ChannelType;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBotChannelAssociationResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetBotChannelAssociationResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::name)).setter(GetBotChannelAssociationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::description)).setter(GetBotChannelAssociationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> BOT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::botAlias)).setter(GetBotChannelAssociationResponse.setter(Builder::botAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAlias").build()}).build();
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::botName)).setter(GetBotChannelAssociationResponse.setter(Builder::botName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::createdDate)).setter(GetBotChannelAssociationResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::typeAsString)).setter(GetBotChannelAssociationResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, String>> BOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::botConfiguration)).setter(GetBotChannelAssociationResponse.setter(Builder::botConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botConfiguration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::statusAsString)).setter(GetBotChannelAssociationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBotChannelAssociationResponse.getter(GetBotChannelAssociationResponse::failureReason)).setter(GetBotChannelAssociationResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, BOT_ALIAS_FIELD, BOT_NAME_FIELD, CREATED_DATE_FIELD, TYPE_FIELD, BOT_CONFIGURATION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD));
    private final String name;
    private final String description;
    private final String botAlias;
    private final String botName;
    private final Instant createdDate;
    private final String type;
    private final Map<String, String> botConfiguration;
    private final String status;
    private final String failureReason;

    private GetBotChannelAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.botAlias = builder.botAlias;
        this.botName = builder.botName;
        this.createdDate = builder.createdDate;
        this.type = builder.type;
        this.botConfiguration = builder.botConfiguration;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String botAlias() {
        return this.botAlias;
    }

    public String botName() {
        return this.botName;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Map<String, String> botConfiguration() {
        return this.botConfiguration;
    }

    public ChannelStatus status() {
        return ChannelStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.botConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationResponse)) {
            return false;
        }
        GetBotChannelAssociationResponse other = (GetBotChannelAssociationResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.botAlias(), other.botAlias()) && Objects.equals(this.botName(), other.botName()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.botConfiguration(), other.botConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"GetBotChannelAssociationResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("BotAlias", (Object)this.botAlias()).add("BotName", (Object)this.botName()).add("CreatedDate", (Object)this.createdDate()).add("Type", (Object)this.typeAsString()).add("BotConfiguration", (Object)(this.botConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "botAlias": {
                return Optional.ofNullable(clazz.cast(this.botAlias()));
            }
            case "botName": {
                return Optional.ofNullable(clazz.cast(this.botName()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "botConfiguration": {
                return Optional.ofNullable(clazz.cast(this.botConfiguration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotChannelAssociationResponse, T> g) {
        return obj -> g.apply((GetBotChannelAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String botAlias;
        private String botName;
        private Instant createdDate;
        private String type;
        private Map<String, String> botConfiguration = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.botAlias(model.botAlias);
            this.botName(model.botName);
            this.createdDate(model.createdDate);
            this.type(model.type);
            this.botConfiguration(model.botConfiguration);
            this.status(model.status);
            this.failureReason(model.failureReason);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotAlias() {
            return this.botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getBotConfiguration() {
            return this.botConfiguration;
        }

        @Override
        public final Builder botConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
            return this;
        }

        public final void setBotConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChannelStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public GetBotChannelAssociationResponse build() {
            return new GetBotChannelAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBotChannelAssociationResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder botAlias(String var1);

        public Builder botName(String var1);

        public Builder createdDate(Instant var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);

        public Builder botConfiguration(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(ChannelStatus var1);

        public Builder failureReason(String var1);
    }
}

