/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBotsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBotsResponse.Builder, GetBotsResponse> {
    private static final SdkField<List<BotMetadata>> BOTS_FIELD = SdkField
            .<List<BotMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GetBotsResponse::bots))
            .setter(setter(Builder::bots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<BotMetadata> bots;

    private final String nextToken;

    private GetBotsResponse(BuilderImpl builder) {
        super(builder);
        this.bots = builder.bots;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>botMetadata</code> objects, with one entry for each bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>botMetadata</code> objects, with one entry for each bot.
     */
    public List<BotMetadata> bots() {
        return bots;
    }

    /**
     * <p>
     * If the response is truncated, it includes a pagination token that you can specify in your next request to fetch
     * the next page of bots.
     * </p>
     * 
     * @return If the response is truncated, it includes a pagination token that you can specify in your next request to
     *         fetch the next page of bots.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bots());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotsResponse)) {
            return false;
        }
        GetBotsResponse other = (GetBotsResponse) obj;
        return Objects.equals(bots(), other.bots()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBotsResponse").add("Bots", bots()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bots":
            return Optional.ofNullable(clazz.cast(bots()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBotsResponse, T> g) {
        return obj -> g.apply((GetBotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBotsResponse> {
        /**
         * <p>
         * An array of <code>botMetadata</code> objects, with one entry for each bot.
         * </p>
         * 
         * @param bots
         *        An array of <code>botMetadata</code> objects, with one entry for each bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(Collection<BotMetadata> bots);

        /**
         * <p>
         * An array of <code>botMetadata</code> objects, with one entry for each bot.
         * </p>
         * 
         * @param bots
         *        An array of <code>botMetadata</code> objects, with one entry for each bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bots(BotMetadata... bots);

        /**
         * <p>
         * An array of <code>botMetadata</code> objects, with one entry for each bot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotMetadata>.Builder} avoiding the need to
         * create one manually via {@link List<BotMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotMetadata>.Builder#build()} is called immediately and its
         * result is passed to {@link #bots(List<BotMetadata>)}.
         * 
         * @param bots
         *        a consumer that will call methods on {@link List<BotMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bots(List<BotMetadata>)
         */
        Builder bots(Consumer<BotMetadata.Builder>... bots);

        /**
         * <p>
         * If the response is truncated, it includes a pagination token that you can specify in your next request to
         * fetch the next page of bots.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, it includes a pagination token that you can specify in your next request
         *        to fetch the next page of bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<BotMetadata> bots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotsResponse model) {
            super(model);
            bots(model.bots);
            nextToken(model.nextToken);
        }

        public final Collection<BotMetadata.Builder> getBots() {
            return bots != null ? bots.stream().map(BotMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bots(Collection<BotMetadata> bots) {
            this.bots = BotMetadataListCopier.copy(bots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(BotMetadata... bots) {
            bots(Arrays.asList(bots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bots(Consumer<BotMetadata.Builder>... bots) {
            bots(Stream.of(bots).map(c -> BotMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBots(Collection<BotMetadata.BuilderImpl> bots) {
            this.bots = BotMetadataListCopier.copyFromBuilder(bots);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBotsResponse build() {
            return new GetBotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
