/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<StartImportRequest.Builder, StartImportRequest> {
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(StartImportRequest::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartImportRequest::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartImportRequest::mergeStrategyAsString)).setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_FIELD,
            RESOURCE_TYPE_FIELD, MERGE_STRATEGY_FIELD));

    private final SdkBytes payload;

    private final String resourceType;

    private final String mergeStrategy;

    private StartImportRequest(BuilderImpl builder) {
        super(builder);
        this.payload = builder.payload;
        this.resourceType = builder.resourceType;
        this.mergeStrategy = builder.mergeStrategy;
    }

    /**
     * <p>
     * A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to
     * import. The resource should match the type specified in the <code>resourceType</code> field.
     * </p>
     * 
     * @return A zip archive in binary format. The archive should contain one file, a JSON file containing the resource
     *         to import. The resource should match the type specified in the <code>resourceType</code> field.
     */
    public SdkBytes payload() {
        return payload;
    }

    /**
     * <p>
     * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A bot exports dependent intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * An intent exports dependent slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A bot exports dependent intents.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An intent exports dependent slot types.
     *         </p>
     *         </li>
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A bot exports dependent intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * An intent exports dependent slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource to export. Each resource also exports any resources that it depends on.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A bot exports dependent intents.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An intent exports dependent slot types.
     *         </p>
     *         </li>
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource
     * with the same name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file
     * and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code>
     * field of the response to the <code>GetImport</code> operation.
     * </p>
     * <p>
     * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
     * $LASTEST version of the existing resource is overwritten with the data from the import file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return Specifies the action that the <code>StartImport</code> operation should take when there is an existing
     *         resource with the same name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
     *         file and an existing resource. The name of the resource causing the conflict is in the
     *         <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
     *         </p>
     *         <p>
     *         OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource.
     *         The $LASTEST version of the existing resource is overwritten with the data from the import file.
     *         </p>
     *         </li>
     * @see MergeStrategy
     */
    public MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource
     * with the same name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file
     * and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code>
     * field of the response to the <code>GetImport</code> operation.
     * </p>
     * <p>
     * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
     * $LASTEST version of the existing resource is overwritten with the data from the import file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return Specifies the action that the <code>StartImport</code> operation should take when there is an existing
     *         resource with the same name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
     *         file and an existing resource. The name of the resource causing the conflict is in the
     *         <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
     *         </p>
     *         <p>
     *         OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource.
     *         The $LASTEST version of the existing resource is overwritten with the data from the import file.
     *         </p>
     *         </li>
     * @see MergeStrategy
     */
    public String mergeStrategyAsString() {
        return mergeStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest) obj;
        return Objects.equals(payload(), other.payload()) && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartImportRequest").add("Payload", payload()).add("ResourceType", resourceTypeAsString())
                .add("MergeStrategy", mergeStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImportRequest, T> g) {
        return obj -> g.apply((StartImportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartImportRequest> {
        /**
         * <p>
         * A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to
         * import. The resource should match the type specified in the <code>resourceType</code> field.
         * </p>
         * 
         * @param payload
         *        A zip archive in binary format. The archive should contain one file, a JSON file containing the
         *        resource to import. The resource should match the type specified in the <code>resourceType</code>
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        /**
         * <p>
         * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A bot exports dependent intents.
         * </p>
         * </li>
         * <li>
         * <p>
         * An intent exports dependent slot types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A bot exports dependent intents.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An intent exports dependent slot types.
         *        </p>
         *        </li>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A bot exports dependent intents.
         * </p>
         * </li>
         * <li>
         * <p>
         * An intent exports dependent slot types.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        Specifies the type of resource to export. Each resource also exports any resources that it depends on.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A bot exports dependent intents.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An intent exports dependent slot types.
         *        </p>
         *        </li>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         * resource with the same name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
         * file and an existing resource. The name of the resource causing the conflict is in the
         * <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         * </p>
         * <p>
         * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
         * $LASTEST version of the existing resource is overwritten with the data from the import file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mergeStrategy
         *        Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         *        resource with the same name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the
         *        import file and an existing resource. The name of the resource causing the conflict is in the
         *        <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         *        </p>
         *        <p>
         *        OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing
         *        resource. The $LASTEST version of the existing resource is overwritten with the data from the import
         *        file.
         *        </p>
         *        </li>
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         * resource with the same name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import
         * file and an existing resource. The name of the resource causing the conflict is in the
         * <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         * </p>
         * <p>
         * OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The
         * $LASTEST version of the existing resource is overwritten with the data from the import file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mergeStrategy
         *        Specifies the action that the <code>StartImport</code> operation should take when there is an existing
         *        resource with the same name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the
         *        import file and an existing resource. The name of the resource causing the conflict is in the
         *        <code>failureReason</code> field of the response to the <code>GetImport</code> operation.
         *        </p>
         *        <p>
         *        OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing
         *        resource. The $LASTEST version of the existing resource is overwritten with the data from the import
         *        file.
         *        </p>
         *        </li>
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private SdkBytes payload;

        private String resourceType;

        private String mergeStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportRequest model) {
            super(model);
            payload(model.payload);
            resourceType(model.resourceType);
            mergeStrategy(model.mergeStrategy);
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = StandardMemberCopier.copy(payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getMergeStrategyAsString() {
            return mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy.toString());
            return this;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportRequest build() {
            return new StartImportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
