/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValue;
import software.amazon.awssdk.services.lexmodelbuilding.model.EnumerationValuesCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotValueSelectionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSlotTypeRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, PutSlotTypeRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSlotTypeRequest.getter(PutSlotTypeRequest::name)).setter(PutSlotTypeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSlotTypeRequest.getter(PutSlotTypeRequest::description)).setter(PutSlotTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<EnumerationValue>> ENUMERATION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutSlotTypeRequest.getter(PutSlotTypeRequest::enumerationValues)).setter(PutSlotTypeRequest.setter(Builder::enumerationValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enumerationValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnumerationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSlotTypeRequest.getter(PutSlotTypeRequest::checksum)).setter(PutSlotTypeRequest.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<String> VALUE_SELECTION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutSlotTypeRequest.getter(PutSlotTypeRequest::valueSelectionStrategyAsString)).setter(PutSlotTypeRequest.setter(Builder::valueSelectionStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionStrategy").build()}).build();
    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PutSlotTypeRequest.getter(PutSlotTypeRequest::createVersion)).setter(PutSlotTypeRequest.setter(Builder::createVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ENUMERATION_VALUES_FIELD, CHECKSUM_FIELD, VALUE_SELECTION_STRATEGY_FIELD, CREATE_VERSION_FIELD));
    private final String name;
    private final String description;
    private final List<EnumerationValue> enumerationValues;
    private final String checksum;
    private final String valueSelectionStrategy;
    private final Boolean createVersion;

    private PutSlotTypeRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.checksum = builder.checksum;
        this.valueSelectionStrategy = builder.valueSelectionStrategy;
        this.createVersion = builder.createVersion;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<EnumerationValue> enumerationValues() {
        return this.enumerationValues;
    }

    public String checksum() {
        return this.checksum;
    }

    public SlotValueSelectionStrategy valueSelectionStrategy() {
        return SlotValueSelectionStrategy.fromValue(this.valueSelectionStrategy);
    }

    public String valueSelectionStrategyAsString() {
        return this.valueSelectionStrategy;
    }

    public Boolean createVersion() {
        return this.createVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enumerationValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueSelectionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeRequest)) {
            return false;
        }
        PutSlotTypeRequest other = (PutSlotTypeRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enumerationValues(), other.enumerationValues()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.valueSelectionStrategyAsString(), other.valueSelectionStrategyAsString()) && Objects.equals(this.createVersion(), other.createVersion());
    }

    public String toString() {
        return ToString.builder((String)"PutSlotTypeRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("EnumerationValues", this.enumerationValues()).add("Checksum", (Object)this.checksum()).add("ValueSelectionStrategy", (Object)this.valueSelectionStrategyAsString()).add("CreateVersion", (Object)this.createVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "enumerationValues": {
                return Optional.ofNullable(clazz.cast(this.enumerationValues()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "valueSelectionStrategy": {
                return Optional.ofNullable(clazz.cast(this.valueSelectionStrategyAsString()));
            }
            case "createVersion": {
                return Optional.ofNullable(clazz.cast(this.createVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSlotTypeRequest, T> g) {
        return obj -> g.apply((PutSlotTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<EnumerationValue> enumerationValues = DefaultSdkAutoConstructList.getInstance();
        private String checksum;
        private String valueSelectionStrategy;
        private Boolean createVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.enumerationValues(model.enumerationValues);
            this.checksum(model.checksum);
            this.valueSelectionStrategy(model.valueSelectionStrategy);
            this.createVersion(model.createVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue.Builder> getEnumerationValues() {
            return this.enumerationValues != null ? (Collection)this.enumerationValues.stream().map(EnumerationValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue ... enumerationValues) {
            this.enumerationValues(Arrays.asList(enumerationValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(Consumer<EnumerationValue.Builder> ... enumerationValues) {
            this.enumerationValues(Stream.of(enumerationValues).map(c -> (EnumerationValue)((EnumerationValue.Builder)EnumerationValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue.BuilderImpl> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copyFromBuilder(enumerationValues);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getValueSelectionStrategyAsString() {
            return this.valueSelectionStrategy;
        }

        @Override
        public final Builder valueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
            return this;
        }

        @Override
        public final Builder valueSelectionStrategy(SlotValueSelectionStrategy valueSelectionStrategy) {
            this.valueSelectionStrategy(valueSelectionStrategy.toString());
            return this;
        }

        public final void setValueSelectionStrategy(String valueSelectionStrategy) {
            this.valueSelectionStrategy = valueSelectionStrategy;
        }

        public final Boolean getCreateVersion() {
            return this.createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSlotTypeRequest build() {
            return new PutSlotTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSlotTypeRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder enumerationValues(Collection<EnumerationValue> var1);

        public Builder enumerationValues(EnumerationValue ... var1);

        public Builder enumerationValues(Consumer<EnumerationValue.Builder> ... var1);

        public Builder checksum(String var1);

        public Builder valueSelectionStrategy(String var1);

        public Builder valueSelectionStrategy(SlotValueSelectionStrategy var1);

        public Builder createVersion(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

