/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBuiltinSlotTypesResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBuiltinSlotTypesResponse.Builder, GetBuiltinSlotTypesResponse> {
    private static final SdkField<List<BuiltinSlotTypeMetadata>> SLOT_TYPES_FIELD = SdkField
            .<List<BuiltinSlotTypeMetadata>> builder(MarshallingType.LIST)
            .getter(getter(GetBuiltinSlotTypesResponse::slotTypes))
            .setter(setter(Builder::slotTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuiltinSlotTypeMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuiltinSlotTypeMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBuiltinSlotTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BuiltinSlotTypeMetadata> slotTypes;

    private final String nextToken;

    private GetBuiltinSlotTypesResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
     */
    public List<BuiltinSlotTypeMetadata> slotTypes() {
        return slotTypes;
    }

    /**
     * <p>
     * If the response is truncated, the response includes a pagination token that you can use in your next request to
     * fetch the next page of slot types.
     * </p>
     * 
     * @return If the response is truncated, the response includes a pagination token that you can use in your next
     *         request to fetch the next page of slot types.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotTypes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinSlotTypesResponse)) {
            return false;
        }
        GetBuiltinSlotTypesResponse other = (GetBuiltinSlotTypesResponse) obj;
        return Objects.equals(slotTypes(), other.slotTypes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBuiltinSlotTypesResponse").add("SlotTypes", slotTypes()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypes":
            return Optional.ofNullable(clazz.cast(slotTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBuiltinSlotTypesResponse, T> g) {
        return obj -> g.apply((GetBuiltinSlotTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBuiltinSlotTypesResponse> {
        /**
         * <p>
         * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(Collection<BuiltinSlotTypeMetadata> slotTypes);

        /**
         * <p>
         * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(BuiltinSlotTypeMetadata... slotTypes);

        /**
         * <p>
         * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BuiltinSlotTypeMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<BuiltinSlotTypeMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BuiltinSlotTypeMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #slotTypes(List<BuiltinSlotTypeMetadata>)}.
         * 
         * @param slotTypes
         *        a consumer that will call methods on {@link List<BuiltinSlotTypeMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypes(List<BuiltinSlotTypeMetadata>)
         */
        Builder slotTypes(Consumer<BuiltinSlotTypeMetadata.Builder>... slotTypes);

        /**
         * <p>
         * If the response is truncated, the response includes a pagination token that you can use in your next request
         * to fetch the next page of slot types.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the response includes a pagination token that you can use in your next
         *        request to fetch the next page of slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<BuiltinSlotTypeMetadata> slotTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinSlotTypesResponse model) {
            super(model);
            slotTypes(model.slotTypes);
            nextToken(model.nextToken);
        }

        public final Collection<BuiltinSlotTypeMetadata.Builder> getSlotTypes() {
            return slotTypes != null ? slotTypes.stream().map(BuiltinSlotTypeMetadata::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder slotTypes(Collection<BuiltinSlotTypeMetadata> slotTypes) {
            this.slotTypes = BuiltinSlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(BuiltinSlotTypeMetadata... slotTypes) {
            slotTypes(Arrays.asList(slotTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(Consumer<BuiltinSlotTypeMetadata.Builder>... slotTypes) {
            slotTypes(Stream.of(slotTypes).map(c -> BuiltinSlotTypeMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypes(Collection<BuiltinSlotTypeMetadata.BuilderImpl> slotTypes) {
            this.slotTypes = BuiltinSlotTypeMetadataListCopier.copyFromBuilder(slotTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBuiltinSlotTypesResponse build() {
            return new GetBuiltinSlotTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
