/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.CodeHook;
import software.amazon.awssdk.services.lexmodelbuilding.model.FollowUpPrompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.FulfillmentActivity;
import software.amazon.awssdk.services.lexmodelbuilding.model.IntentUtteranceListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Slot;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIntentResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, PutIntentResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutIntentResponse.getter(PutIntentResponse::name)).setter(PutIntentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutIntentResponse.getter(PutIntentResponse::description)).setter(PutIntentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Slot>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutIntentResponse.getter(PutIntentResponse::slots)).setter(PutIntentResponse.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Slot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAMPLE_UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutIntentResponse.getter(PutIntentResponse::sampleUtterances)).setter(PutIntentResponse.setter(Builder::sampleUtterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Prompt> CONFIRMATION_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutIntentResponse.getter(PutIntentResponse::confirmationPrompt)).setter(PutIntentResponse.setter(Builder::confirmationPrompt)).constructor(Prompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationPrompt").build()}).build();
    private static final SdkField<Statement> REJECTION_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutIntentResponse.getter(PutIntentResponse::rejectionStatement)).setter(PutIntentResponse.setter(Builder::rejectionStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionStatement").build()}).build();
    private static final SdkField<FollowUpPrompt> FOLLOW_UP_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutIntentResponse.getter(PutIntentResponse::followUpPrompt)).setter(PutIntentResponse.setter(Builder::followUpPrompt)).constructor(FollowUpPrompt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followUpPrompt").build()}).build();
    private static final SdkField<Statement> CONCLUSION_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutIntentResponse.getter(PutIntentResponse::conclusionStatement)).setter(PutIntentResponse.setter(Builder::conclusionStatement)).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conclusionStatement").build()}).build();
    private static final SdkField<CodeHook> DIALOG_CODE_HOOK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutIntentResponse.getter(PutIntentResponse::dialogCodeHook)).setter(PutIntentResponse.setter(Builder::dialogCodeHook)).constructor(CodeHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()}).build();
    private static final SdkField<FulfillmentActivity> FULFILLMENT_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutIntentResponse.getter(PutIntentResponse::fulfillmentActivity)).setter(PutIntentResponse.setter(Builder::fulfillmentActivity)).constructor(FulfillmentActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentActivity").build()}).build();
    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutIntentResponse.getter(PutIntentResponse::parentIntentSignature)).setter(PutIntentResponse.setter(Builder::parentIntentSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PutIntentResponse.getter(PutIntentResponse::lastUpdatedDate)).setter(PutIntentResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PutIntentResponse.getter(PutIntentResponse::createdDate)).setter(PutIntentResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutIntentResponse.getter(PutIntentResponse::version)).setter(PutIntentResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutIntentResponse.getter(PutIntentResponse::checksum)).setter(PutIntentResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final SdkField<Boolean> CREATE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PutIntentResponse.getter(PutIntentResponse::createVersion)).setter(PutIntentResponse.setter(Builder::createVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SLOTS_FIELD, SAMPLE_UTTERANCES_FIELD, CONFIRMATION_PROMPT_FIELD, REJECTION_STATEMENT_FIELD, FOLLOW_UP_PROMPT_FIELD, CONCLUSION_STATEMENT_FIELD, DIALOG_CODE_HOOK_FIELD, FULFILLMENT_ACTIVITY_FIELD, PARENT_INTENT_SIGNATURE_FIELD, LAST_UPDATED_DATE_FIELD, CREATED_DATE_FIELD, VERSION_FIELD, CHECKSUM_FIELD, CREATE_VERSION_FIELD));
    private final String name;
    private final String description;
    private final List<Slot> slots;
    private final List<String> sampleUtterances;
    private final Prompt confirmationPrompt;
    private final Statement rejectionStatement;
    private final FollowUpPrompt followUpPrompt;
    private final Statement conclusionStatement;
    private final CodeHook dialogCodeHook;
    private final FulfillmentActivity fulfillmentActivity;
    private final String parentIntentSignature;
    private final Instant lastUpdatedDate;
    private final Instant createdDate;
    private final String version;
    private final String checksum;
    private final Boolean createVersion;

    private PutIntentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.slots = builder.slots;
        this.sampleUtterances = builder.sampleUtterances;
        this.confirmationPrompt = builder.confirmationPrompt;
        this.rejectionStatement = builder.rejectionStatement;
        this.followUpPrompt = builder.followUpPrompt;
        this.conclusionStatement = builder.conclusionStatement;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentActivity = builder.fulfillmentActivity;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
        this.createVersion = builder.createVersion;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<Slot> slots() {
        return this.slots;
    }

    public List<String> sampleUtterances() {
        return this.sampleUtterances;
    }

    public Prompt confirmationPrompt() {
        return this.confirmationPrompt;
    }

    public Statement rejectionStatement() {
        return this.rejectionStatement;
    }

    public FollowUpPrompt followUpPrompt() {
        return this.followUpPrompt;
    }

    public Statement conclusionStatement() {
        return this.conclusionStatement;
    }

    public CodeHook dialogCodeHook() {
        return this.dialogCodeHook;
    }

    public FulfillmentActivity fulfillmentActivity() {
        return this.fulfillmentActivity;
    }

    public String parentIntentSignature() {
        return this.parentIntentSignature;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String version() {
        return this.version;
    }

    public String checksum() {
        return this.checksum;
    }

    public Boolean createVersion() {
        return this.createVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleUtterances());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.followUpPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.conclusionStatement());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(this.fulfillmentActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.createVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntentResponse)) {
            return false;
        }
        PutIntentResponse other = (PutIntentResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.sampleUtterances(), other.sampleUtterances()) && Objects.equals(this.confirmationPrompt(), other.confirmationPrompt()) && Objects.equals(this.rejectionStatement(), other.rejectionStatement()) && Objects.equals(this.followUpPrompt(), other.followUpPrompt()) && Objects.equals(this.conclusionStatement(), other.conclusionStatement()) && Objects.equals(this.dialogCodeHook(), other.dialogCodeHook()) && Objects.equals(this.fulfillmentActivity(), other.fulfillmentActivity()) && Objects.equals(this.parentIntentSignature(), other.parentIntentSignature()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.createVersion(), other.createVersion());
    }

    public String toString() {
        return ToString.builder((String)"PutIntentResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Slots", this.slots()).add("SampleUtterances", this.sampleUtterances()).add("ConfirmationPrompt", (Object)this.confirmationPrompt()).add("RejectionStatement", (Object)this.rejectionStatement()).add("FollowUpPrompt", (Object)this.followUpPrompt()).add("ConclusionStatement", (Object)this.conclusionStatement()).add("DialogCodeHook", (Object)this.dialogCodeHook()).add("FulfillmentActivity", (Object)this.fulfillmentActivity()).add("ParentIntentSignature", (Object)this.parentIntentSignature()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("CreatedDate", (Object)this.createdDate()).add("Version", (Object)this.version()).add("Checksum", (Object)this.checksum()).add("CreateVersion", (Object)this.createVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "sampleUtterances": {
                return Optional.ofNullable(clazz.cast(this.sampleUtterances()));
            }
            case "confirmationPrompt": {
                return Optional.ofNullable(clazz.cast(this.confirmationPrompt()));
            }
            case "rejectionStatement": {
                return Optional.ofNullable(clazz.cast(this.rejectionStatement()));
            }
            case "followUpPrompt": {
                return Optional.ofNullable(clazz.cast(this.followUpPrompt()));
            }
            case "conclusionStatement": {
                return Optional.ofNullable(clazz.cast(this.conclusionStatement()));
            }
            case "dialogCodeHook": {
                return Optional.ofNullable(clazz.cast(this.dialogCodeHook()));
            }
            case "fulfillmentActivity": {
                return Optional.ofNullable(clazz.cast(this.fulfillmentActivity()));
            }
            case "parentIntentSignature": {
                return Optional.ofNullable(clazz.cast(this.parentIntentSignature()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "createVersion": {
                return Optional.ofNullable(clazz.cast(this.createVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntentResponse, T> g) {
        return obj -> g.apply((PutIntentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Slot> slots = DefaultSdkAutoConstructList.getInstance();
        private List<String> sampleUtterances = DefaultSdkAutoConstructList.getInstance();
        private Prompt confirmationPrompt;
        private Statement rejectionStatement;
        private FollowUpPrompt followUpPrompt;
        private Statement conclusionStatement;
        private CodeHook dialogCodeHook;
        private FulfillmentActivity fulfillmentActivity;
        private String parentIntentSignature;
        private Instant lastUpdatedDate;
        private Instant createdDate;
        private String version;
        private String checksum;
        private Boolean createVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntentResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.slots(model.slots);
            this.sampleUtterances(model.sampleUtterances);
            this.confirmationPrompt(model.confirmationPrompt);
            this.rejectionStatement(model.rejectionStatement);
            this.followUpPrompt(model.followUpPrompt);
            this.conclusionStatement(model.conclusionStatement);
            this.dialogCodeHook(model.dialogCodeHook);
            this.fulfillmentActivity(model.fulfillmentActivity);
            this.parentIntentSignature(model.parentIntentSignature);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.checksum(model.checksum);
            this.createVersion(model.createVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Slot.Builder> getSlots() {
            return this.slots != null ? (Collection)this.slots.stream().map(Slot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotListCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<Slot.Builder> ... slots) {
            this.slots(Stream.of(slots).map(c -> (Slot)((Slot.Builder)Slot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotListCopier.copyFromBuilder(slots);
        }

        public final Collection<String> getSampleUtterances() {
            return this.sampleUtterances;
        }

        @Override
        public final Builder sampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(String ... sampleUtterances) {
            this.sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        public final void setSampleUtterances(Collection<String> sampleUtterances) {
            this.sampleUtterances = IntentUtteranceListCopier.copy(sampleUtterances);
        }

        public final Prompt.Builder getConfirmationPrompt() {
            return this.confirmationPrompt != null ? this.confirmationPrompt.toBuilder() : null;
        }

        @Override
        public final Builder confirmationPrompt(Prompt confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt;
            return this;
        }

        public final void setConfirmationPrompt(Prompt.BuilderImpl confirmationPrompt) {
            this.confirmationPrompt = confirmationPrompt != null ? confirmationPrompt.build() : null;
        }

        public final Statement.Builder getRejectionStatement() {
            return this.rejectionStatement != null ? this.rejectionStatement.toBuilder() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        public final FollowUpPrompt.Builder getFollowUpPrompt() {
            return this.followUpPrompt != null ? this.followUpPrompt.toBuilder() : null;
        }

        @Override
        public final Builder followUpPrompt(FollowUpPrompt followUpPrompt) {
            this.followUpPrompt = followUpPrompt;
            return this;
        }

        public final void setFollowUpPrompt(FollowUpPrompt.BuilderImpl followUpPrompt) {
            this.followUpPrompt = followUpPrompt != null ? followUpPrompt.build() : null;
        }

        public final Statement.Builder getConclusionStatement() {
            return this.conclusionStatement != null ? this.conclusionStatement.toBuilder() : null;
        }

        @Override
        public final Builder conclusionStatement(Statement conclusionStatement) {
            this.conclusionStatement = conclusionStatement;
            return this;
        }

        public final void setConclusionStatement(Statement.BuilderImpl conclusionStatement) {
            this.conclusionStatement = conclusionStatement != null ? conclusionStatement.build() : null;
        }

        public final CodeHook.Builder getDialogCodeHook() {
            return this.dialogCodeHook != null ? this.dialogCodeHook.toBuilder() : null;
        }

        @Override
        public final Builder dialogCodeHook(CodeHook dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(CodeHook.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        public final FulfillmentActivity.Builder getFulfillmentActivity() {
            return this.fulfillmentActivity != null ? this.fulfillmentActivity.toBuilder() : null;
        }

        @Override
        public final Builder fulfillmentActivity(FulfillmentActivity fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity;
            return this;
        }

        public final void setFulfillmentActivity(FulfillmentActivity.BuilderImpl fulfillmentActivity) {
            this.fulfillmentActivity = fulfillmentActivity != null ? fulfillmentActivity.build() : null;
        }

        public final String getParentIntentSignature() {
            return this.parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final Boolean getCreateVersion() {
            return this.createVersion;
        }

        @Override
        public final Builder createVersion(Boolean createVersion) {
            this.createVersion = createVersion;
            return this;
        }

        public final void setCreateVersion(Boolean createVersion) {
            this.createVersion = createVersion;
        }

        @Override
        public PutIntentResponse build() {
            return new PutIntentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIntentResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder slots(Collection<Slot> var1);

        public Builder slots(Slot ... var1);

        public Builder slots(Consumer<Slot.Builder> ... var1);

        public Builder sampleUtterances(Collection<String> var1);

        public Builder sampleUtterances(String ... var1);

        public Builder confirmationPrompt(Prompt var1);

        default public Builder confirmationPrompt(Consumer<Prompt.Builder> confirmationPrompt) {
            return this.confirmationPrompt((Prompt)((Prompt.Builder)Prompt.builder().applyMutation(confirmationPrompt)).build());
        }

        public Builder rejectionStatement(Statement var1);

        default public Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return this.rejectionStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(rejectionStatement)).build());
        }

        public Builder followUpPrompt(FollowUpPrompt var1);

        default public Builder followUpPrompt(Consumer<FollowUpPrompt.Builder> followUpPrompt) {
            return this.followUpPrompt((FollowUpPrompt)((FollowUpPrompt.Builder)FollowUpPrompt.builder().applyMutation(followUpPrompt)).build());
        }

        public Builder conclusionStatement(Statement var1);

        default public Builder conclusionStatement(Consumer<Statement.Builder> conclusionStatement) {
            return this.conclusionStatement((Statement)((Statement.Builder)Statement.builder().applyMutation(conclusionStatement)).build());
        }

        public Builder dialogCodeHook(CodeHook var1);

        default public Builder dialogCodeHook(Consumer<CodeHook.Builder> dialogCodeHook) {
            return this.dialogCodeHook((CodeHook)((CodeHook.Builder)CodeHook.builder().applyMutation(dialogCodeHook)).build());
        }

        public Builder fulfillmentActivity(FulfillmentActivity var1);

        default public Builder fulfillmentActivity(Consumer<FulfillmentActivity.Builder> fulfillmentActivity) {
            return this.fulfillmentActivity((FulfillmentActivity)((FulfillmentActivity.Builder)FulfillmentActivity.builder().applyMutation(fulfillmentActivity)).build());
        }

        public Builder parentIntentSignature(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder createdDate(Instant var1);

        public Builder version(String var1);

        public Builder checksum(String var1);

        public Builder createVersion(Boolean var1);
    }
}

