/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSlotTypesRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetSlotTypesRequest.Builder, GetSlotTypesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSlotTypesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetSlotTypesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSlotTypesRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nameContains").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, NAME_CONTAINS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String nameContains;

    private GetSlotTypesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.nameContains = builder.nameContains;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination
     * token in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of slot types. If the response to this API call is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types,
     *         specify the pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of slot types to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of slot types to return in the response. The default is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Substring to match in slot type names. A slot type will be returned if any part of its name matches the
     * substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     * </p>
     * 
     * @return Substring to match in slot type names. A slot type will be returned if any part of its name matches the
     *         substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     */
    public String nameContains() {
        return nameContains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypesRequest)) {
            return false;
        }
        GetSlotTypesRequest other = (GetSlotTypesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nameContains(), other.nameContains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSlotTypesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("NameContains", nameContains()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSlotTypesRequest, T> g) {
        return obj -> g.apply((GetSlotTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSlotTypesRequest> {
        /**
         * <p>
         * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of slot types. If the response to this API call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of slot types to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of slot types to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Substring to match in slot type names. A slot type will be returned if any part of its name matches the
         * substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * </p>
         * 
         * @param nameContains
         *        Substring to match in slot type names. A slot type will be returned if any part of its name matches
         *        the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String nameContains;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            nameContains(model.nameContains);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSlotTypesRequest build() {
            return new GetSlotTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
