/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse;

public class GetSlotTypesIterable
implements SdkIterable<GetSlotTypesResponse> {
    private final LexModelBuildingClient client;
    private final GetSlotTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSlotTypesIterable(LexModelBuildingClient client, GetSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetSlotTypesResponseFetcher();
    }

    public Iterator<GetSlotTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetSlotTypesResponseFetcher
    implements SyncPageFetcher<GetSlotTypesResponse> {
        private GetSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetSlotTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSlotTypesResponse nextPage(GetSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return GetSlotTypesIterable.this.client.getSlotTypes(GetSlotTypesIterable.this.firstRequest);
            }
            return GetSlotTypesIterable.this.client.getSlotTypes((GetSlotTypesRequest)((Object)GetSlotTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

