/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBuiltinSlotTypesRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetBuiltinSlotTypesRequest> {
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBuiltinSlotTypesRequest.getter(GetBuiltinSlotTypesRequest::localeAsString)).setter(GetBuiltinSlotTypesRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()}).build();
    private static final SdkField<String> SIGNATURE_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBuiltinSlotTypesRequest.getter(GetBuiltinSlotTypesRequest::signatureContains)).setter(GetBuiltinSlotTypesRequest.setter(Builder::signatureContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("signatureContains").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBuiltinSlotTypesRequest.getter(GetBuiltinSlotTypesRequest::nextToken)).setter(GetBuiltinSlotTypesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetBuiltinSlotTypesRequest.getter(GetBuiltinSlotTypesRequest::maxResults)).setter(GetBuiltinSlotTypesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_FIELD, SIGNATURE_CONTAINS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String locale;
    private final String signatureContains;
    private final String nextToken;
    private final Integer maxResults;

    private GetBuiltinSlotTypesRequest(BuilderImpl builder) {
        super(builder);
        this.locale = builder.locale;
        this.signatureContains = builder.signatureContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeAsString() {
        return this.locale;
    }

    public String signatureContains() {
        return this.signatureContains;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinSlotTypesRequest)) {
            return false;
        }
        GetBuiltinSlotTypesRequest other = (GetBuiltinSlotTypesRequest)((Object)obj);
        return Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.signatureContains(), other.signatureContains()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetBuiltinSlotTypesRequest").add("Locale", (Object)this.localeAsString()).add("SignatureContains", (Object)this.signatureContains()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "signatureContains": {
                return Optional.ofNullable(clazz.cast(this.signatureContains()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBuiltinSlotTypesRequest, T> g) {
        return obj -> g.apply((GetBuiltinSlotTypesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String locale;
        private String signatureContains;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinSlotTypesRequest model) {
            super(model);
            this.locale(model.locale);
            this.signatureContains(model.signatureContains);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getLocaleAsString() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getSignatureContains() {
            return this.signatureContains;
        }

        @Override
        public final Builder signatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
            return this;
        }

        public final void setSignatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBuiltinSlotTypesRequest build() {
            return new GetBuiltinSlotTypesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBuiltinSlotTypesRequest> {
        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder signatureContains(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

