/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A prompt for additional activity after an intent is fulfilled. For example, after the <code>OrderPizza</code> intent
 * is fulfilled, you might prompt the user to find out whether the user wants to order drinks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FollowUpPrompt implements SdkPojo, Serializable, ToCopyableBuilder<FollowUpPrompt.Builder, FollowUpPrompt> {
    private static final SdkField<Prompt> PROMPT_FIELD = SdkField.<Prompt> builder(MarshallingType.SDK_POJO)
            .getter(getter(FollowUpPrompt::prompt)).setter(setter(Builder::prompt)).constructor(Prompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()).build();

    private static final SdkField<Statement> REJECTION_STATEMENT_FIELD = SdkField.<Statement> builder(MarshallingType.SDK_POJO)
            .getter(getter(FollowUpPrompt::rejectionStatement)).setter(setter(Builder::rejectionStatement))
            .constructor(Statement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectionStatement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_FIELD,
            REJECTION_STATEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Prompt prompt;

    private final Statement rejectionStatement;

    private FollowUpPrompt(BuilderImpl builder) {
        this.prompt = builder.prompt;
        this.rejectionStatement = builder.rejectionStatement;
    }

    /**
     * <p>
     * Prompts for information from the user.
     * </p>
     * 
     * @return Prompts for information from the user.
     */
    public Prompt prompt() {
        return prompt;
    }

    /**
     * <p>
     * If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with this
     * statement to acknowledge that the intent was canceled.
     * </p>
     * 
     * @return If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds
     *         with this statement to acknowledge that the intent was canceled.
     */
    public Statement rejectionStatement() {
        return rejectionStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        hashCode = 31 * hashCode + Objects.hashCode(rejectionStatement());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FollowUpPrompt)) {
            return false;
        }
        FollowUpPrompt other = (FollowUpPrompt) obj;
        return Objects.equals(prompt(), other.prompt()) && Objects.equals(rejectionStatement(), other.rejectionStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FollowUpPrompt").add("Prompt", prompt()).add("RejectionStatement", rejectionStatement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "prompt":
            return Optional.ofNullable(clazz.cast(prompt()));
        case "rejectionStatement":
            return Optional.ofNullable(clazz.cast(rejectionStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FollowUpPrompt, T> g) {
        return obj -> g.apply((FollowUpPrompt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FollowUpPrompt> {
        /**
         * <p>
         * Prompts for information from the user.
         * </p>
         * 
         * @param prompt
         *        Prompts for information from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(Prompt prompt);

        /**
         * <p>
         * Prompts for information from the user.
         * </p>
         * This is a convenience that creates an instance of the {@link Prompt.Builder} avoiding the need to create one
         * manually via {@link Prompt#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prompt.Builder#build()} is called immediately and its result is
         * passed to {@link #prompt(Prompt)}.
         * 
         * @param prompt
         *        a consumer that will call methods on {@link Prompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prompt(Prompt)
         */
        default Builder prompt(Consumer<Prompt.Builder> prompt) {
            return prompt(Prompt.builder().applyMutation(prompt).build());
        }

        /**
         * <p>
         * If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * 
         * @param rejectionStatement
         *        If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds
         *        with this statement to acknowledge that the intent was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectionStatement(Statement rejectionStatement);

        /**
         * <p>
         * If the user answers "no" to the question defined in the <code>prompt</code> field, Amazon Lex responds with
         * this statement to acknowledge that the intent was canceled.
         * </p>
         * This is a convenience that creates an instance of the {@link Statement.Builder} avoiding the need to create
         * one manually via {@link Statement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statement.Builder#build()} is called immediately and its result
         * is passed to {@link #rejectionStatement(Statement)}.
         * 
         * @param rejectionStatement
         *        a consumer that will call methods on {@link Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectionStatement(Statement)
         */
        default Builder rejectionStatement(Consumer<Statement.Builder> rejectionStatement) {
            return rejectionStatement(Statement.builder().applyMutation(rejectionStatement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Prompt prompt;

        private Statement rejectionStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(FollowUpPrompt model) {
            prompt(model.prompt);
            rejectionStatement(model.rejectionStatement);
        }

        public final Prompt.Builder getPrompt() {
            return prompt != null ? prompt.toBuilder() : null;
        }

        @Override
        public final Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public final void setPrompt(Prompt.BuilderImpl prompt) {
            this.prompt = prompt != null ? prompt.build() : null;
        }

        public final Statement.Builder getRejectionStatement() {
            return rejectionStatement != null ? rejectionStatement.toBuilder() : null;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement.BuilderImpl rejectionStatement) {
            this.rejectionStatement = rejectionStatement != null ? rejectionStatement.build() : null;
        }

        @Override
        public FollowUpPrompt build() {
            return new FollowUpPrompt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
