/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ConflictException;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.InternalServerException;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Exception;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lexmodelsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ThrottlingException;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ValidationException;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable;
import software.amazon.awssdk.services.lexmodelsv2.transform.BuildBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotAliasesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotLocalesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotTypeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLexModelsV2Client
implements LexModelsV2Client {
    private static final Logger log = Logger.loggerFor(DefaultLexModelsV2Client.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLexModelsV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "lex";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildBotLocaleResponse buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BuildBotLocaleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, buildBotLocaleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BuildBotLocale");
            BuildBotLocaleResponse buildBotLocaleResponse = (BuildBotLocaleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BuildBotLocale").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)buildBotLocaleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BuildBotLocaleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return buildBotLocaleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$buildBotLocale$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBotResponse createBot(CreateBotRequest createBotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, createBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBot");
            CreateBotResponse createBotResponse = (CreateBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$createBot$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBotAliasResponse createBotAlias(CreateBotAliasRequest createBotAliasRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, createBotAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBotAlias");
            CreateBotAliasResponse createBotAliasResponse = (CreateBotAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBotAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBotAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBotAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBotAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$createBotAlias$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBotLocaleResponse createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotLocaleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, createBotLocaleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBotLocale");
            CreateBotLocaleResponse createBotLocaleResponse = (CreateBotLocaleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBotLocale").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBotLocaleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBotLocaleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBotLocaleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$createBotLocale$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBotVersionResponse createBotVersion(CreateBotVersionRequest createBotVersionRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBotVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, createBotVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBotVersion");
            CreateBotVersionResponse createBotVersionResponse = (CreateBotVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBotVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBotVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBotVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBotVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$createBotVersion$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIntentResponse createIntent(CreateIntentRequest createIntentRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIntentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, createIntentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIntent");
            CreateIntentResponse createIntentResponse = (CreateIntentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIntent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIntentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIntentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIntentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$createIntent$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSlotResponse createSlot(CreateSlotRequest createSlotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSlotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, createSlotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSlot");
            CreateSlotResponse createSlotResponse = (CreateSlotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSlot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSlotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSlotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSlotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$createSlot$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSlotTypeResponse createSlotType(CreateSlotTypeRequest createSlotTypeRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSlotTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, createSlotTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSlotType");
            CreateSlotTypeResponse createSlotTypeResponse = (CreateSlotTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSlotType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSlotTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSlotTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSlotTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$createSlotType$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBotResponse deleteBot(DeleteBotRequest deleteBotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBot");
            DeleteBotResponse deleteBotResponse = (DeleteBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$deleteBot$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBotAliasResponse deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBotAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteBotAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBotAlias");
            DeleteBotAliasResponse deleteBotAliasResponse = (DeleteBotAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBotAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBotAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBotAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBotAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$deleteBotAlias$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBotLocaleResponse deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBotLocaleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteBotLocaleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBotLocale");
            DeleteBotLocaleResponse deleteBotLocaleResponse = (DeleteBotLocaleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBotLocale").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBotLocaleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBotLocaleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBotLocaleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$deleteBotLocale$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBotVersionResponse deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBotVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteBotVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBotVersion");
            DeleteBotVersionResponse deleteBotVersionResponse = (DeleteBotVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBotVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBotVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBotVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBotVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$deleteBotVersion$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIntentResponse deleteIntent(DeleteIntentRequest deleteIntentRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIntentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteIntentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIntent");
            DeleteIntentResponse deleteIntentResponse = (DeleteIntentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIntent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIntentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIntentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIntentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$deleteIntent$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSlotResponse deleteSlot(DeleteSlotRequest deleteSlotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSlotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteSlotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSlot");
            DeleteSlotResponse deleteSlotResponse = (DeleteSlotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSlot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSlotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSlotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSlotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$deleteSlot$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSlotTypeResponse deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSlotTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, deleteSlotTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSlotType");
            DeleteSlotTypeResponse deleteSlotTypeResponse = (DeleteSlotTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSlotType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSlotTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSlotTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSlotTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$deleteSlotType$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBotResponse describeBot(DescribeBotRequest describeBotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, describeBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBot");
            DescribeBotResponse describeBotResponse = (DescribeBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$describeBot$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBotAliasResponse describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBotAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, describeBotAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBotAlias");
            DescribeBotAliasResponse describeBotAliasResponse = (DescribeBotAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBotAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBotAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBotAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBotAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$describeBotAlias$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBotLocaleResponse describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBotLocaleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, describeBotLocaleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBotLocale");
            DescribeBotLocaleResponse describeBotLocaleResponse = (DescribeBotLocaleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBotLocale").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBotLocaleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBotLocaleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBotLocaleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$describeBotLocale$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBotVersionResponse describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBotVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, describeBotVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBotVersion");
            DescribeBotVersionResponse describeBotVersionResponse = (DescribeBotVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBotVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBotVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBotVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBotVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$describeBotVersion$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIntentResponse describeIntent(DescribeIntentRequest describeIntentRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIntentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, describeIntentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIntent");
            DescribeIntentResponse describeIntentResponse = (DescribeIntentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIntent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIntentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIntentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIntentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$describeIntent$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSlotResponse describeSlot(DescribeSlotRequest describeSlotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSlotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, describeSlotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSlot");
            DescribeSlotResponse describeSlotResponse = (DescribeSlotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSlot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSlotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSlotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSlotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$describeSlot$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSlotTypeResponse describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSlotTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, describeSlotTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSlotType");
            DescribeSlotTypeResponse describeSlotTypeResponse = (DescribeSlotTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSlotType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSlotTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSlotTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSlotTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$describeSlotType$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBotAliasesResponse listBotAliases(ListBotAliasesRequest listBotAliasesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listBotAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBotAliases");
            ListBotAliasesResponse listBotAliasesResponse = (ListBotAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBotAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBotAliasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBotAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBotAliasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listBotAliases$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBotAliasesIterable listBotAliasesPaginator(ListBotAliasesRequest listBotAliasesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBotAliasesIterable(this, this.applyPaginatorUserAgent(listBotAliasesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBotLocalesResponse listBotLocales(ListBotLocalesRequest listBotLocalesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotLocalesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listBotLocalesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBotLocales");
            ListBotLocalesResponse listBotLocalesResponse = (ListBotLocalesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBotLocales").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBotLocalesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBotLocalesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBotLocalesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listBotLocales$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBotLocalesIterable listBotLocalesPaginator(ListBotLocalesRequest listBotLocalesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBotLocalesIterable(this, this.applyPaginatorUserAgent(listBotLocalesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBotVersionsResponse listBotVersions(ListBotVersionsRequest listBotVersionsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listBotVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBotVersions");
            ListBotVersionsResponse listBotVersionsResponse = (ListBotVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBotVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBotVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBotVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBotVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listBotVersions$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBotVersionsIterable listBotVersionsPaginator(ListBotVersionsRequest listBotVersionsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBotVersionsIterable(this, this.applyPaginatorUserAgent(listBotVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listBotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBots");
            ListBotsResponse listBotsResponse = (ListBotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listBots$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBotsIterable listBotsPaginator(ListBotsRequest listBotsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBotsIterable(this, this.applyPaginatorUserAgent(listBotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuiltInIntentsResponse listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuiltInIntentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listBuiltInIntentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBuiltInIntents");
            ListBuiltInIntentsResponse listBuiltInIntentsResponse = (ListBuiltInIntentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuiltInIntents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBuiltInIntentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBuiltInIntentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBuiltInIntentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listBuiltInIntents$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBuiltInIntentsIterable listBuiltInIntentsPaginator(ListBuiltInIntentsRequest listBuiltInIntentsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBuiltInIntentsIterable(this, this.applyPaginatorUserAgent(listBuiltInIntentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBuiltInSlotTypesResponse listBuiltInSlotTypes(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBuiltInSlotTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listBuiltInSlotTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBuiltInSlotTypes");
            ListBuiltInSlotTypesResponse listBuiltInSlotTypesResponse = (ListBuiltInSlotTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuiltInSlotTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBuiltInSlotTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBuiltInSlotTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBuiltInSlotTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listBuiltInSlotTypes$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBuiltInSlotTypesIterable listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBuiltInSlotTypesIterable(this, this.applyPaginatorUserAgent(listBuiltInSlotTypesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIntentsResponse listIntents(ListIntentsRequest listIntentsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIntentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listIntentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIntents");
            ListIntentsResponse listIntentsResponse = (ListIntentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIntents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIntentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIntentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIntentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listIntents$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIntentsIterable listIntentsPaginator(ListIntentsRequest listIntentsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListIntentsIterable(this, this.applyPaginatorUserAgent(listIntentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSlotTypesResponse listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSlotTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listSlotTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSlotTypes");
            ListSlotTypesResponse listSlotTypesResponse = (ListSlotTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSlotTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSlotTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSlotTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSlotTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listSlotTypes$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSlotTypesIterable listSlotTypesPaginator(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListSlotTypesIterable(this, this.applyPaginatorUserAgent(listSlotTypesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSlotsResponse listSlots(ListSlotsRequest listSlotsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSlotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listSlotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSlots");
            ListSlotsResponse listSlotsResponse = (ListSlotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSlots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSlotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSlotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSlotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listSlots$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSlotsIterable listSlotsPaginator(ListSlotsRequest listSlotsRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListSlotsIterable(this, this.applyPaginatorUserAgent(listSlotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$listTagsForResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$tagResource$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$untagResource$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBotResponse updateBot(UpdateBotRequest updateBotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, updateBotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBot");
            UpdateBotResponse updateBotResponse = (UpdateBotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$updateBot$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBotAliasResponse updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBotAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, updateBotAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBotAlias");
            UpdateBotAliasResponse updateBotAliasResponse = (UpdateBotAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBotAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBotAliasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBotAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBotAliasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$updateBotAlias$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBotLocaleResponse updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBotLocaleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, updateBotLocaleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBotLocale");
            UpdateBotLocaleResponse updateBotLocaleResponse = (UpdateBotLocaleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBotLocale").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBotLocaleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBotLocaleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBotLocaleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$updateBotLocale$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIntentResponse updateIntent(UpdateIntentRequest updateIntentRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIntentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, updateIntentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIntent");
            UpdateIntentResponse updateIntentResponse = (UpdateIntentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIntent").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIntentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIntentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIntentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$updateIntent$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSlotResponse updateSlot(UpdateSlotRequest updateSlotRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSlotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, updateSlotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSlot");
            UpdateSlotResponse updateSlotResponse = (UpdateSlotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSlot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSlotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSlotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSlotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$updateSlot$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSlotTypeResponse updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSlotTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLexModelsV2Client.resolveMetricPublishers(this.clientConfiguration, updateSlotTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSlotType");
            UpdateSlotTypeResponse updateSlotTypeResponse = (UpdateSlotTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSlotType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSlotTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSlotTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSlotTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLexModelsV2Client.lambda$updateSlotType$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LexModelsV2Exception::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailedException").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends LexModelsV2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.15.78").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LexModelsV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateSlotType$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSlot$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIntent$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBotLocale$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBotAlias$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBot$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSlots$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSlotTypes$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIntents$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBuiltInSlotTypes$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBuiltInIntents$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBots$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBotVersions$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBotLocales$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBotAliases$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSlotType$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSlot$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIntent$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBotVersion$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBotLocale$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBotAlias$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBot$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSlotType$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSlot$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIntent$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBotVersion$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBotLocale$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBotAlias$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBot$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSlotType$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSlot$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIntent$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBotVersion$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBotLocale$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBotAlias$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBot$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$buildBotLocale$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

