/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a bot returned by the <a>ListBots</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotSummary implements SdkPojo, Serializable, ToCopyableBuilder<BotSummary.Builder, BotSummary> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(BotSummary::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(BotSummary::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BotSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botStatus").getter(getter(BotSummary::botStatusAsString)).setter(setter(Builder::botStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()).build();

    private static final SdkField<String> LATEST_BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestBotVersion").getter(getter(BotSummary::latestBotVersion))
            .setter(setter(Builder::latestBotVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestBotVersion").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BotSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD,
            DESCRIPTION_FIELD, BOT_STATUS_FIELD, LATEST_BOT_VERSION_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botId;

    private final String botName;

    private final String description;

    private final String botStatus;

    private final String latestBotVersion;

    private final Instant lastUpdatedDateTime;

    private BotSummary(BuilderImpl builder) {
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.description = builder.description;
        this.botStatus = builder.botStatus;
        this.latestBotVersion = builder.latestBotVersion;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier assigned to the bot. Use this ID to get detailed information about the bot with the
     * <a>DescribeBot</a> operation.
     * </p>
     * 
     * @return The unique identifier assigned to the bot. Use this ID to get detailed information about the bot with the
     *         <a>DescribeBot</a> operation.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The name of the bot.
     * </p>
     * 
     * @return The name of the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The description of the bot.
     * </p>
     * 
     * @return The description of the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
     * @see BotStatus
     */
    public final BotStatus botStatus() {
        return BotStatus.fromValue(botStatus);
    }

    /**
     * <p>
     * The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
     * @see BotStatus
     */
    public final String botStatusAsString() {
        return botStatus;
    }

    /**
     * <p>
     * The latest numerical version in use for the bot.
     * </p>
     * 
     * @return The latest numerical version in use for the bot.
     */
    public final String latestBotVersion() {
        return latestBotVersion;
    }

    /**
     * <p>
     * The date and time that the bot was last updated.
     * </p>
     * 
     * @return The date and time that the bot was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestBotVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotSummary)) {
            return false;
        }
        BotSummary other = (BotSummary) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botName(), other.botName())
                && Objects.equals(description(), other.description())
                && Objects.equals(botStatusAsString(), other.botStatusAsString())
                && Objects.equals(latestBotVersion(), other.latestBotVersion())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotSummary").add("BotId", botId()).add("BotName", botName()).add("Description", description())
                .add("BotStatus", botStatusAsString()).add("LatestBotVersion", latestBotVersion())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botStatus":
            return Optional.ofNullable(clazz.cast(botStatusAsString()));
        case "latestBotVersion":
            return Optional.ofNullable(clazz.cast(latestBotVersion()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotSummary, T> g) {
        return obj -> g.apply((BotSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotSummary> {
        /**
         * <p>
         * The unique identifier assigned to the bot. Use this ID to get detailed information about the bot with the
         * <a>DescribeBot</a> operation.
         * </p>
         * 
         * @param botId
         *        The unique identifier assigned to the bot. Use this ID to get detailed information about the bot with
         *        the <a>DescribeBot</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The name of the bot.
         * </p>
         * 
         * @param botName
         *        The name of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The description of the bot.
         * </p>
         * 
         * @param description
         *        The description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(String botStatus);

        /**
         * <p>
         * The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. When the status is <code>Available</code> the bot is ready for use.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(BotStatus botStatus);

        /**
         * <p>
         * The latest numerical version in use for the bot.
         * </p>
         * 
         * @param latestBotVersion
         *        The latest numerical version in use for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestBotVersion(String latestBotVersion);

        /**
         * <p>
         * The date and time that the bot was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the bot was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String botId;

        private String botName;

        private String description;

        private String botStatus;

        private String latestBotVersion;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BotSummary model) {
            botId(model.botId);
            botName(model.botName);
            description(model.description);
            botStatus(model.botStatus);
            latestBotVersion(model.latestBotVersion);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotStatus() {
            return botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        public final String getLatestBotVersion() {
            return latestBotVersion;
        }

        @Override
        public final Builder latestBotVersion(String latestBotVersion) {
            this.latestBotVersion = latestBotVersion;
            return this;
        }

        public final void setLatestBotVersion(String latestBotVersion) {
            this.latestBotVersion = latestBotVersion;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public BotSummary build() {
            return new BotSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
