/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.Button;
import software.amazon.awssdk.services.lexmodelsv2.model.ButtonsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageResponseCard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageResponseCard> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(ImageResponseCard.getter(ImageResponseCard::title)).setter(ImageResponseCard.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtitle").getter(ImageResponseCard.getter(ImageResponseCard::subtitle)).setter(ImageResponseCard.setter(Builder::subtitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtitle").build()}).build();
    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageUrl").getter(ImageResponseCard.getter(ImageResponseCard::imageUrl)).setter(ImageResponseCard.setter(Builder::imageUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageUrl").build()}).build();
    private static final SdkField<List<Button>> BUTTONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buttons").getter(ImageResponseCard.getter(ImageResponseCard::buttons)).setter(ImageResponseCard.setter(Builder::buttons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buttons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Button::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, SUBTITLE_FIELD, IMAGE_URL_FIELD, BUTTONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String subtitle;
    private final String imageUrl;
    private final List<Button> buttons;

    private ImageResponseCard(BuilderImpl builder) {
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.imageUrl = builder.imageUrl;
        this.buttons = builder.buttons;
    }

    public final String title() {
        return this.title;
    }

    public final String subtitle() {
        return this.subtitle;
    }

    public final String imageUrl() {
        return this.imageUrl;
    }

    public final boolean hasButtons() {
        return this.buttons != null && !(this.buttons instanceof SdkAutoConstructList);
    }

    public final List<Button> buttons() {
        return this.buttons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasButtons() ? this.buttons() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageResponseCard)) {
            return false;
        }
        ImageResponseCard other = (ImageResponseCard)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.imageUrl(), other.imageUrl()) && this.hasButtons() == other.hasButtons() && Objects.equals(this.buttons(), other.buttons());
    }

    public final String toString() {
        return ToString.builder((String)"ImageResponseCard").add("Title", (Object)this.title()).add("Subtitle", (Object)this.subtitle()).add("ImageUrl", (Object)this.imageUrl()).add("Buttons", this.hasButtons() ? this.buttons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "imageUrl": {
                return Optional.ofNullable(clazz.cast(this.imageUrl()));
            }
            case "buttons": {
                return Optional.ofNullable(clazz.cast(this.buttons()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageResponseCard, T> g) {
        return obj -> g.apply((ImageResponseCard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String subtitle;
        private String imageUrl;
        private List<Button> buttons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageResponseCard model) {
            this.title(model.title);
            this.subtitle(model.subtitle);
            this.imageUrl(model.imageUrl);
            this.buttons(model.buttons);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getSubtitle() {
            return this.subtitle;
        }

        @Override
        public final Builder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle = subtitle;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final Collection<Button.Builder> getButtons() {
            if (this.buttons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.buttons != null ? (Collection)this.buttons.stream().map(Button::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder buttons(Collection<Button> buttons) {
            this.buttons = ButtonsListCopier.copy(buttons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Button ... buttons) {
            this.buttons(Arrays.asList(buttons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buttons(Consumer<Button.Builder> ... buttons) {
            this.buttons(Stream.of(buttons).map(c -> (Button)((Button.Builder)Button.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setButtons(Collection<Button.BuilderImpl> buttons) {
            this.buttons = ButtonsListCopier.copyFromBuilder(buttons);
        }

        public ImageResponseCard build() {
            return new ImageResponseCard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageResponseCard> {
        public Builder title(String var1);

        public Builder subtitle(String var1);

        public Builder imageUrl(String var1);

        public Builder buttons(Collection<Button> var1);

        public Builder buttons(Button ... var1);

        public Builder buttons(Consumer<Button.Builder> ... var1);
    }
}

