/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ConflictException;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.InternalServerException;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Exception;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lexmodelsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ThrottlingException;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ValidationException;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable;

/**
 * Service client for accessing Lex Models V2. This can be created using the static {@link #builder()} method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LexModelsV2Client extends SdkClient {
    String SERVICE_NAME = "lex";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "models-v2-lex";

    /**
     * Create a {@link LexModelsV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LexModelsV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LexModelsV2Client}.
     */
    static LexModelsV2ClientBuilder builder() {
        return new DefaultLexModelsV2ClientBuilder();
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     *
     * @param buildBotLocaleRequest
     * @return Result of the BuildBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default BuildBotLocaleResponse buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BuildBotLocaleRequest.Builder} avoiding the need to
     * create one manually via {@link BuildBotLocaleRequest#builder()}
     * </p>
     *
     * @param buildBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link BuildBotLocaleRequest.Builder} to create a request.
     * @return Result of the BuildBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default BuildBotLocaleResponse buildBotLocale(Consumer<BuildBotLocaleRequest.Builder> buildBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return buildBotLocale(BuildBotLocaleRequest.builder().applyMutation(buildBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     *
     * @param createBotRequest
     * @return Result of the CreateBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBotResponse createBot(CreateBotRequest createBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotRequest#builder()}
     * </p>
     *
     * @param createBotRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotRequest.Builder} to create a request.
     * @return Result of the CreateBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBotResponse createBot(Consumer<CreateBotRequest.Builder> createBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBot(CreateBotRequest.builder().applyMutation(createBotRequest).build());
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     *
     * @param createBotAliasRequest
     * @return Result of the CreateBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotAliasResponse createBotAlias(CreateBotAliasRequest createBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBotAliasRequest#builder()}
     * </p>
     *
     * @param createBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotAliasRequest.Builder} to create a request.
     * @return Result of the CreateBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotAliasResponse createBotAlias(Consumer<CreateBotAliasRequest.Builder> createBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBotAlias(CreateBotAliasRequest.builder().applyMutation(createBotAliasRequest).build());
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     *
     * @param createBotLocaleRequest
     * @return Result of the CreateBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotLocaleResponse createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotLocaleRequest#builder()}
     * </p>
     *
     * @param createBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotLocaleRequest.Builder} to create a request.
     * @return Result of the CreateBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBotLocaleResponse createBotLocale(Consumer<CreateBotLocaleRequest.Builder> createBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBotLocale(CreateBotLocaleRequest.builder().applyMutation(createBotLocaleRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     *
     * @param createBotVersionRequest
     * @return Result of the CreateBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBotVersionResponse createBotVersion(CreateBotVersionRequest createBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBotVersionRequest#builder()}
     * </p>
     *
     * @param createBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateBotVersionRequest.Builder} to create a request.
     * @return Result of the CreateBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBotVersionResponse createBotVersion(Consumer<CreateBotVersionRequest.Builder> createBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createBotVersion(CreateBotVersionRequest.builder().applyMutation(createBotVersionRequest).build());
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     *
     * @param createIntentRequest
     * @return Result of the CreateIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateIntentResponse createIntent(CreateIntentRequest createIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIntentRequest#builder()}
     * </p>
     *
     * @param createIntentRequest
     *        A {@link Consumer} that will call methods on {@link CreateIntentRequest.Builder} to create a request.
     * @return Result of the CreateIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateIntentResponse createIntent(Consumer<CreateIntentRequest.Builder> createIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createIntent(CreateIntentRequest.builder().applyMutation(createIntentRequest).build());
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     *
     * @param createSlotRequest
     * @return Result of the CreateSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSlotResponse createSlot(CreateSlotRequest createSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotRequest#builder()}
     * </p>
     *
     * @param createSlotRequest
     *        A {@link Consumer} that will call methods on {@link CreateSlotRequest.Builder} to create a request.
     * @return Result of the CreateSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSlotResponse createSlot(Consumer<CreateSlotRequest.Builder> createSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createSlot(CreateSlotRequest.builder().applyMutation(createSlotRequest).build());
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     *
     * @param createSlotTypeRequest
     * @return Result of the CreateSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSlotTypeResponse createSlotType(CreateSlotTypeRequest createSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSlotTypeRequest#builder()}
     * </p>
     *
     * @param createSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link CreateSlotTypeRequest.Builder} to create a request.
     * @return Result of the CreateSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSlotTypeResponse createSlotType(Consumer<CreateSlotTypeRequest.Builder> createSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return createSlotType(CreateSlotTypeRequest.builder().applyMutation(createSlotTypeRequest).build());
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     *
     * @param deleteBotRequest
     * @return Result of the DeleteBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBotResponse deleteBot(DeleteBotRequest deleteBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotRequest#builder()}
     * </p>
     *
     * @param deleteBotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotRequest.Builder} to create a request.
     * @return Result of the DeleteBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBotResponse deleteBot(Consumer<DeleteBotRequest.Builder> deleteBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBot(DeleteBotRequest.builder().applyMutation(deleteBotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return Result of the DeleteBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotAliasResponse deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBotAliasRequest#builder()}
     * </p>
     *
     * @param deleteBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotAliasRequest.Builder} to create a request.
     * @return Result of the DeleteBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotAliasResponse deleteBotAlias(Consumer<DeleteBotAliasRequest.Builder> deleteBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBotAlias(DeleteBotAliasRequest.builder().applyMutation(deleteBotAliasRequest).build());
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     *
     * @param deleteBotLocaleRequest
     * @return Result of the DeleteBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotLocaleResponse deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotLocaleRequest#builder()}
     * </p>
     *
     * @param deleteBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotLocaleRequest.Builder} to create a request.
     * @return Result of the DeleteBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBotLocaleResponse deleteBotLocale(Consumer<DeleteBotLocaleRequest.Builder> deleteBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBotLocale(DeleteBotLocaleRequest.builder().applyMutation(deleteBotLocaleRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all version of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return Result of the DeleteBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBotVersionResponse deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all version of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBotVersionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBotVersionRequest#builder()}
     * </p>
     *
     * @param deleteBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBotVersionRequest.Builder} to create a request.
     * @return Result of the DeleteBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBotVersionResponse deleteBotVersion(Consumer<DeleteBotVersionRequest.Builder> deleteBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteBotVersion(DeleteBotVersionRequest.builder().applyMutation(deleteBotVersionRequest).build());
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     *
     * @param deleteIntentRequest
     * @return Result of the DeleteIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteIntentResponse deleteIntent(DeleteIntentRequest deleteIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIntentRequest#builder()}
     * </p>
     *
     * @param deleteIntentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntentRequest.Builder} to create a request.
     * @return Result of the DeleteIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteIntentResponse deleteIntent(Consumer<DeleteIntentRequest.Builder> deleteIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteIntent(DeleteIntentRequest.builder().applyMutation(deleteIntentRequest).build());
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     *
     * @param deleteSlotRequest
     * @return Result of the DeleteSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSlotResponse deleteSlot(DeleteSlotRequest deleteSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotRequest#builder()}
     * </p>
     *
     * @param deleteSlotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSlotRequest.Builder} to create a request.
     * @return Result of the DeleteSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSlotResponse deleteSlot(Consumer<DeleteSlotRequest.Builder> deleteSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteSlot(DeleteSlotRequest.builder().applyMutation(deleteSlotRequest).build());
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return Result of the DeleteSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSlotTypeResponse deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSlotTypeRequest#builder()}
     * </p>
     *
     * @param deleteSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSlotTypeRequest.Builder} to create a request.
     * @return Result of the DeleteSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSlotTypeResponse deleteSlotType(Consumer<DeleteSlotTypeRequest.Builder> deleteSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            PreconditionFailedException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return deleteSlotType(DeleteSlotTypeRequest.builder().applyMutation(deleteSlotTypeRequest).build());
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     *
     * @param describeBotRequest
     * @return Result of the DescribeBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBotResponse describeBot(DescribeBotRequest describeBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBotRequest#builder()}
     * </p>
     *
     * @param describeBotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotRequest.Builder} to create a request.
     * @return Result of the DescribeBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBotResponse describeBot(Consumer<DescribeBotRequest.Builder> describeBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBot(DescribeBotRequest.builder().applyMutation(describeBotRequest).build());
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     *
     * @param describeBotAliasRequest
     * @return Result of the DescribeBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotAliasResponse describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotAliasRequest#builder()}
     * </p>
     *
     * @param describeBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotAliasRequest.Builder} to create a request.
     * @return Result of the DescribeBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotAliasResponse describeBotAlias(Consumer<DescribeBotAliasRequest.Builder> describeBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBotAlias(DescribeBotAliasRequest.builder().applyMutation(describeBotAliasRequest).build());
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     *
     * @param describeBotLocaleRequest
     * @return Result of the DescribeBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotLocaleResponse describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBotLocaleRequest#builder()}
     * </p>
     *
     * @param describeBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotLocaleRequest.Builder} to create a request.
     * @return Result of the DescribeBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotLocaleResponse describeBotLocale(Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBotLocale(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build());
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     *
     * @param describeBotVersionRequest
     * @return Result of the DescribeBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotVersionResponse describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBotVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBotVersionRequest#builder()}
     * </p>
     *
     * @param describeBotVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBotVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBotVersionResponse describeBotVersion(Consumer<DescribeBotVersionRequest.Builder> describeBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeBotVersion(DescribeBotVersionRequest.builder().applyMutation(describeBotVersionRequest).build());
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     *
     * @param describeIntentRequest
     * @return Result of the DescribeIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIntentResponse describeIntent(DescribeIntentRequest describeIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIntentRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIntentRequest#builder()}
     * </p>
     *
     * @param describeIntentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIntentRequest.Builder} to create a request.
     * @return Result of the DescribeIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeIntentResponse describeIntent(Consumer<DescribeIntentRequest.Builder> describeIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeIntent(DescribeIntentRequest.builder().applyMutation(describeIntentRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     *
     * @param describeSlotRequest
     * @return Result of the DescribeSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSlotResponse describeSlot(DescribeSlotRequest describeSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSlotRequest#builder()}
     * </p>
     *
     * @param describeSlotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSlotRequest.Builder} to create a request.
     * @return Result of the DescribeSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSlotResponse describeSlot(Consumer<DescribeSlotRequest.Builder> describeSlotRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeSlot(DescribeSlotRequest.builder().applyMutation(describeSlotRequest).build());
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     *
     * @param describeSlotTypeRequest
     * @return Result of the DescribeSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlotTypeResponse describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSlotTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSlotTypeRequest#builder()}
     * </p>
     *
     * @param describeSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSlotTypeRequest.Builder} to create a request.
     * @return Result of the DescribeSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSlotTypeResponse describeSlotType(Consumer<DescribeSlotTypeRequest.Builder> describeSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return describeSlotType(DescribeSlotTypeRequest.builder().applyMutation(describeSlotTypeRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     *
     * @param listBotAliasesRequest
     * @return Result of the ListBotAliases operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesResponse listBotAliases(ListBotAliasesRequest listBotAliasesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotAliasesRequest.Builder} to create a request.
     * @return Result of the ListBotAliases operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesResponse listBotAliases(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotAliases(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client
     *             .listBotAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesIterable listBotAliasesPaginator(ListBotAliasesRequest listBotAliasesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client
     *             .listBotAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotAliasesRequest#builder()}
     * </p>
     *
     * @param listBotAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotAliasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotAliasesIterable listBotAliasesPaginator(Consumer<ListBotAliasesRequest.Builder> listBotAliasesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotAliasesPaginator(ListBotAliasesRequest.builder().applyMutation(listBotAliasesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     *
     * @param listBotLocalesRequest
     * @return Result of the ListBotLocales operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesResponse listBotLocales(ListBotLocalesRequest listBotLocalesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotLocalesRequest.Builder} to create a request.
     * @return Result of the ListBotLocales operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesResponse listBotLocales(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotLocales(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client
     *             .listBotLocalesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesIterable listBotLocalesPaginator(ListBotLocalesRequest listBotLocalesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client
     *             .listBotLocalesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotLocalesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotLocalesRequest#builder()}
     * </p>
     *
     * @param listBotLocalesRequest
     *        A {@link Consumer} that will call methods on {@link ListBotLocalesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotLocalesIterable listBotLocalesPaginator(Consumer<ListBotLocalesRequest.Builder> listBotLocalesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotLocalesPaginator(ListBotLocalesRequest.builder().applyMutation(listBotLocalesRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     *
     * @param listBotVersionsRequest
     * @return Result of the ListBotVersions operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsResponse listBotVersions(ListBotVersionsRequest listBotVersionsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotVersionsRequest.Builder} to create a request.
     * @return Result of the ListBotVersions operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsResponse listBotVersions(Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotVersions(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client
     *             .listBotVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsIterable listBotVersionsPaginator(ListBotVersionsRequest listBotVersionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client
     *             .listBotVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBotVersionsRequest#builder()}
     * </p>
     *
     * @param listBotVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBotVersionsIterable listBotVersionsPaginator(Consumer<ListBotVersionsRequest.Builder> listBotVersionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBotVersionsPaginator(ListBotVersionsRequest.builder().applyMutation(listBotVersionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     *
     * @param listBotsRequest
     * @return Result of the ListBots operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ThrottlingException, ServiceQuotaExceededException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return Result of the ListBots operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(Consumer<ListBotsRequest.Builder> listBotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBots(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(ListBotsRequest listBotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on {@link ListBotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(Consumer<ListBotsRequest.Builder> listBotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBotsPaginator(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return Result of the ListBuiltInIntents operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsResponse listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBuiltInIntents operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsResponse listBuiltInIntents(Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listBuiltInIntents(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client
     *             .listBuiltInIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsIterable listBuiltInIntentsPaginator(ListBuiltInIntentsRequest listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client
     *             .listBuiltInIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInIntentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInIntentsRequest#builder()}
     * </p>
     *
     * @param listBuiltInIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInIntentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInIntentsIterable listBuiltInIntentsPaginator(
            Consumer<ListBuiltInIntentsRequest.Builder> listBuiltInIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBuiltInIntentsPaginator(ListBuiltInIntentsRequest.builder().applyMutation(listBuiltInIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return Result of the ListBuiltInSlotTypes operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesResponse listBuiltInSlotTypes(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return Result of the ListBuiltInSlotTypes operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesResponse listBuiltInSlotTypes(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBuiltInSlotTypes(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client
     *             .listBuiltInSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesIterable listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client
     *             .listBuiltInSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuiltInSlotTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBuiltInSlotTypesRequest#builder()}
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListBuiltInSlotTypesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBuiltInSlotTypesIterable listBuiltInSlotTypesPaginator(
            Consumer<ListBuiltInSlotTypesRequest.Builder> listBuiltInSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest.builder().applyMutation(listBuiltInSlotTypesRequest)
                .build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     *
     * @param listIntentsRequest
     * @return Result of the ListIntents operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsResponse listIntents(ListIntentsRequest listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntentsRequest.Builder} to create a request.
     * @return Result of the ListIntents operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsResponse listIntents(Consumer<ListIntentsRequest.Builder> listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listIntents(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     *
     * @param listIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsIterable listIntentsPaginator(ListIntentsRequest listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIntentsRequest#builder()}
     * </p>
     *
     * @param listIntentsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIntentsIterable listIntentsPaginator(Consumer<ListIntentsRequest.Builder> listIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listIntentsPaginator(ListIntentsRequest.builder().applyMutation(listIntentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     *
     * @param listSlotTypesRequest
     * @return Result of the ListSlotTypes operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesResponse listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotTypesRequest.Builder} to create a request.
     * @return Result of the ListSlotTypes operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesResponse listSlotTypes(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listSlotTypes(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client
     *             .listSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesIterable listSlotTypesPaginator(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client
     *             .listSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotTypesRequest#builder()}
     * </p>
     *
     * @param listSlotTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotTypesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSlotTypesIterable listSlotTypesPaginator(Consumer<ListSlotTypesRequest.Builder> listSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return listSlotTypesPaginator(ListSlotTypesRequest.builder().applyMutation(listSlotTypesRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     *
     * @param listSlotsRequest
     * @return Result of the ListSlots operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsResponse listSlots(ListSlotsRequest listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotsRequest.Builder} to create a request.
     * @return Result of the ListSlots operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsResponse listSlots(Consumer<ListSlotsRequest.Builder> listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listSlots(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     *
     * @param listSlotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsIterable listSlotsPaginator(ListSlotsRequest listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSlotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSlotsRequest#builder()}
     * </p>
     *
     * @param listSlotsRequest
     *        A {@link Consumer} that will call methods on {@link ListSlotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSlotsIterable listSlotsPaginator(Consumer<ListSlotsRequest.Builder> listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listSlotsPaginator(ListSlotsRequest.builder().applyMutation(listSlotsRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     *
     * @param updateBotRequest
     * @return Result of the UpdateBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBotResponse updateBot(UpdateBotRequest updateBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotRequest#builder()}
     * </p>
     *
     * @param updateBotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotRequest.Builder} to create a request.
     * @return Result of the UpdateBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBotResponse updateBot(Consumer<UpdateBotRequest.Builder> updateBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateBot(UpdateBotRequest.builder().applyMutation(updateBotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     *
     * @param updateBotAliasRequest
     * @return Result of the UpdateBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotAliasResponse updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBotAliasRequest#builder()}
     * </p>
     *
     * @param updateBotAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotAliasRequest.Builder} to create a request.
     * @return Result of the UpdateBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotAliasResponse updateBotAlias(Consumer<UpdateBotAliasRequest.Builder> updateBotAliasRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateBotAlias(UpdateBotAliasRequest.builder().applyMutation(updateBotAliasRequest).build());
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     *
     * @param updateBotLocaleRequest
     * @return Result of the UpdateBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotLocaleResponse updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBotLocaleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBotLocaleRequest#builder()}
     * </p>
     *
     * @param updateBotLocaleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBotLocaleRequest.Builder} to create a request.
     * @return Result of the UpdateBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateBotLocaleResponse updateBotLocale(Consumer<UpdateBotLocaleRequest.Builder> updateBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateBotLocale(UpdateBotLocaleRequest.builder().applyMutation(updateBotLocaleRequest).build());
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     *
     * @param updateIntentRequest
     * @return Result of the UpdateIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateIntentResponse updateIntent(UpdateIntentRequest updateIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIntentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIntentRequest#builder()}
     * </p>
     *
     * @param updateIntentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIntentRequest.Builder} to create a request.
     * @return Result of the UpdateIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateIntentResponse updateIntent(Consumer<UpdateIntentRequest.Builder> updateIntentRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateIntent(UpdateIntentRequest.builder().applyMutation(updateIntentRequest).build());
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     *
     * @param updateSlotRequest
     * @return Result of the UpdateSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSlotResponse updateSlot(UpdateSlotRequest updateSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotRequest#builder()}
     * </p>
     *
     * @param updateSlotRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSlotRequest.Builder} to create a request.
     * @return Result of the UpdateSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSlotResponse updateSlot(Consumer<UpdateSlotRequest.Builder> updateSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateSlot(UpdateSlotRequest.builder().applyMutation(updateSlotRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     *
     * @param updateSlotTypeRequest
     * @return Result of the UpdateSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSlotTypeResponse updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSlotTypeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSlotTypeRequest#builder()}
     * </p>
     *
     * @param updateSlotTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSlotTypeRequest.Builder} to create a request.
     * @return Result of the UpdateSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSlotTypeResponse updateSlotType(Consumer<UpdateSlotTypeRequest.Builder> updateSlotTypeRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, PreconditionFailedException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return updateSlotType(UpdateSlotTypeRequest.builder().applyMutation(updateSlotTypeRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
