/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSlotTypeRequest extends LexModelsV2Request implements
        ToCopyableBuilder<UpdateSlotTypeRequest.Builder, UpdateSlotTypeRequest> {
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(UpdateSlotTypeRequest::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("slotTypeId").build()).build();

    private static final SdkField<String> SLOT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeName").getter(getter(UpdateSlotTypeRequest::slotTypeName)).setter(setter(Builder::slotTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSlotTypeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<SlotTypeValue>> SLOT_TYPE_VALUES_FIELD = SdkField
            .<List<SlotTypeValue>> builder(MarshallingType.LIST)
            .memberName("slotTypeValues")
            .getter(getter(UpdateSlotTypeRequest::slotTypeValues))
            .setter(setter(Builder::slotTypeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SlotValueSelectionSetting> VALUE_SELECTION_SETTING_FIELD = SdkField
            .<SlotValueSelectionSetting> builder(MarshallingType.SDK_POJO).memberName("valueSelectionSetting")
            .getter(getter(UpdateSlotTypeRequest::valueSelectionSetting)).setter(setter(Builder::valueSelectionSetting))
            .constructor(SlotValueSelectionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSelectionSetting").build())
            .build();

    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentSlotTypeSignature").getter(getter(UpdateSlotTypeRequest::parentSlotTypeSignature))
            .setter(setter(Builder::parentSlotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateSlotTypeRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(UpdateSlotTypeRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(UpdateSlotTypeRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_ID_FIELD,
            SLOT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, SLOT_TYPE_VALUES_FIELD, VALUE_SELECTION_SETTING_FIELD,
            PARENT_SLOT_TYPE_SIGNATURE_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD));

    private final String slotTypeId;

    private final String slotTypeName;

    private final String description;

    private final List<SlotTypeValue> slotTypeValues;

    private final SlotValueSelectionSetting valueSelectionSetting;

    private final String parentSlotTypeSignature;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private UpdateSlotTypeRequest(BuilderImpl builder) {
        super(builder);
        this.slotTypeId = builder.slotTypeId;
        this.slotTypeName = builder.slotTypeName;
        this.description = builder.description;
        this.slotTypeValues = builder.slotTypeValues;
        this.valueSelectionSetting = builder.valueSelectionSetting;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
    }

    /**
     * <p>
     * The unique identifier of the slot type to update.
     * </p>
     * 
     * @return The unique identifier of the slot type to update.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * The new name of the slot type.
     * </p>
     * 
     * @return The new name of the slot type.
     */
    public final String slotTypeName() {
        return slotTypeName;
    }

    /**
     * <p>
     * The new description of the slot type.
     * </p>
     * 
     * @return The new description of the slot type.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the SlotTypeValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSlotTypeValues() {
        return slotTypeValues != null && !(slotTypeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A new list of values and their optional synonyms that define the values that the slot type can take.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSlotTypeValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A new list of values and their optional synonyms that define the values that the slot type can take.
     */
    public final List<SlotTypeValue> slotTypeValues() {
        return slotTypeValues;
    }

    /**
     * <p>
     * The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.
     * </p>
     * 
     * @return The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.
     */
    public final SlotValueSelectionSetting valueSelectionSetting() {
        return valueSelectionSetting;
    }

    /**
     * <p>
     * The new built-in slot type that should be used as the parent of this slot type.
     * </p>
     * 
     * @return The new built-in slot type that should be used as the parent of this slot type.
     */
    public final String parentSlotTypeSignature() {
        return parentSlotTypeSignature;
    }

    /**
     * <p>
     * The identifier of the bot that contains the slot type.
     * </p>
     * 
     * @return The identifier of the bot that contains the slot type.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the slot type. Must be <code>DRAFT</code>.
     * </p>
     * 
     * @return The version of the bot that contains the slot type. Must be <code>DRAFT</code>.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale that contains the slot type. The string must match one of the supported
     * locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html">https
     * ://docs.aws.amazon.com/lex/latest/dg/supported-locales.html</a>.
     * </p>
     * 
     * @return The identifier of the language and locale that contains the slot type. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html"
     *         >https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html</a>.
     */
    public final String localeId() {
        return localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotTypeValues() ? slotTypeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(valueSelectionSetting());
        hashCode = 31 * hashCode + Objects.hashCode(parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSlotTypeRequest)) {
            return false;
        }
        UpdateSlotTypeRequest other = (UpdateSlotTypeRequest) obj;
        return Objects.equals(slotTypeId(), other.slotTypeId()) && Objects.equals(slotTypeName(), other.slotTypeName())
                && Objects.equals(description(), other.description()) && hasSlotTypeValues() == other.hasSlotTypeValues()
                && Objects.equals(slotTypeValues(), other.slotTypeValues())
                && Objects.equals(valueSelectionSetting(), other.valueSelectionSetting())
                && Objects.equals(parentSlotTypeSignature(), other.parentSlotTypeSignature())
                && Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSlotTypeRequest").add("SlotTypeId", slotTypeId()).add("SlotTypeName", slotTypeName())
                .add("Description", description()).add("SlotTypeValues", hasSlotTypeValues() ? slotTypeValues() : null)
                .add("ValueSelectionSetting", valueSelectionSetting()).add("ParentSlotTypeSignature", parentSlotTypeSignature())
                .add("BotId", botId()).add("BotVersion", botVersion()).add("LocaleId", localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "slotTypeName":
            return Optional.ofNullable(clazz.cast(slotTypeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slotTypeValues":
            return Optional.ofNullable(clazz.cast(slotTypeValues()));
        case "valueSelectionSetting":
            return Optional.ofNullable(clazz.cast(valueSelectionSetting()));
        case "parentSlotTypeSignature":
            return Optional.ofNullable(clazz.cast(parentSlotTypeSignature()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSlotTypeRequest, T> g) {
        return obj -> g.apply((UpdateSlotTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSlotTypeRequest> {
        /**
         * <p>
         * The unique identifier of the slot type to update.
         * </p>
         * 
         * @param slotTypeId
         *        The unique identifier of the slot type to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * The new name of the slot type.
         * </p>
         * 
         * @param slotTypeName
         *        The new name of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeName(String slotTypeName);

        /**
         * <p>
         * The new description of the slot type.
         * </p>
         * 
         * @param description
         *        The new description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A new list of values and their optional synonyms that define the values that the slot type can take.
         * </p>
         * 
         * @param slotTypeValues
         *        A new list of values and their optional synonyms that define the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues);

        /**
         * <p>
         * A new list of values and their optional synonyms that define the values that the slot type can take.
         * </p>
         * 
         * @param slotTypeValues
         *        A new list of values and their optional synonyms that define the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeValues(SlotTypeValue... slotTypeValues);

        /**
         * <p>
         * A new list of values and their optional synonyms that define the values that the slot type can take.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotTypeValue>.Builder} avoiding the need
         * to create one manually via {@link List<SlotTypeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotTypeValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #slotTypeValues(List<SlotTypeValue>)}.
         * 
         * @param slotTypeValues
         *        a consumer that will call methods on {@link List<SlotTypeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypeValues(List<SlotTypeValue>)
         */
        Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues);

        /**
         * <p>
         * The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.
         * </p>
         * 
         * @param valueSelectionSetting
         *        The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting);

        /**
         * <p>
         * The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.
         * </p>
         * This is a convenience that creates an instance of the {@link SlotValueSelectionSetting.Builder} avoiding the
         * need to create one manually via {@link SlotValueSelectionSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotValueSelectionSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #valueSelectionSetting(SlotValueSelectionSetting)}.
         * 
         * @param valueSelectionSetting
         *        a consumer that will call methods on {@link SlotValueSelectionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueSelectionSetting(SlotValueSelectionSetting)
         */
        default Builder valueSelectionSetting(Consumer<SlotValueSelectionSetting.Builder> valueSelectionSetting) {
            return valueSelectionSetting(SlotValueSelectionSetting.builder().applyMutation(valueSelectionSetting).build());
        }

        /**
         * <p>
         * The new built-in slot type that should be used as the parent of this slot type.
         * </p>
         * 
         * @param parentSlotTypeSignature
         *        The new built-in slot type that should be used as the parent of this slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSlotTypeSignature(String parentSlotTypeSignature);

        /**
         * <p>
         * The identifier of the bot that contains the slot type.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the slot type. Must be <code>DRAFT</code>.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the slot type. Must be <code>DRAFT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale that contains the slot type. The string must match one of the
         * supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html"
         * >https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale that contains the slot type. The string must match one of
         *        the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html"
         *        >https://docs.aws.amazon.com/lex/latest/dg/supported-locales.html</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String slotTypeId;

        private String slotTypeName;

        private String description;

        private List<SlotTypeValue> slotTypeValues = DefaultSdkAutoConstructList.getInstance();

        private SlotValueSelectionSetting valueSelectionSetting;

        private String parentSlotTypeSignature;

        private String botId;

        private String botVersion;

        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSlotTypeRequest model) {
            super(model);
            slotTypeId(model.slotTypeId);
            slotTypeName(model.slotTypeName);
            description(model.description);
            slotTypeValues(model.slotTypeValues);
            valueSelectionSetting(model.valueSelectionSetting);
            parentSlotTypeSignature(model.parentSlotTypeSignature);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        public final String getSlotTypeName() {
            return slotTypeName;
        }

        @Override
        public final Builder slotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
            return this;
        }

        public final void setSlotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<SlotTypeValue.Builder> getSlotTypeValues() {
            if (slotTypeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return slotTypeValues != null ? slotTypeValues.stream().map(SlotTypeValue::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder slotTypeValues(Collection<SlotTypeValue> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copy(slotTypeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(SlotTypeValue... slotTypeValues) {
            slotTypeValues(Arrays.asList(slotTypeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeValues(Consumer<SlotTypeValue.Builder>... slotTypeValues) {
            slotTypeValues(Stream.of(slotTypeValues).map(c -> SlotTypeValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypeValues(Collection<SlotTypeValue.BuilderImpl> slotTypeValues) {
            this.slotTypeValues = SlotTypeValuesCopier.copyFromBuilder(slotTypeValues);
        }

        public final SlotValueSelectionSetting.Builder getValueSelectionSetting() {
            return valueSelectionSetting != null ? valueSelectionSetting.toBuilder() : null;
        }

        @Override
        public final Builder valueSelectionSetting(SlotValueSelectionSetting valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting;
            return this;
        }

        public final void setValueSelectionSetting(SlotValueSelectionSetting.BuilderImpl valueSelectionSetting) {
            this.valueSelectionSetting = valueSelectionSetting != null ? valueSelectionSetting.build() : null;
        }

        public final String getParentSlotTypeSignature() {
            return parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSlotTypeRequest build() {
            return new UpdateSlotTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
