/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSlotTypesResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListSlotTypesResponse.Builder, ListSlotTypesResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListSlotTypesResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListSlotTypesResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListSlotTypesResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<List<SlotTypeSummary>> SLOT_TYPE_SUMMARIES_FIELD = SdkField
            .<List<SlotTypeSummary>> builder(MarshallingType.LIST)
            .memberName("slotTypeSummaries")
            .getter(getter(ListSlotTypesResponse::slotTypeSummaries))
            .setter(setter(Builder::slotTypeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSlotTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, SLOT_TYPE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final List<SlotTypeSummary> slotTypeSummaries;

    private final String nextToken;

    private ListSlotTypesResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.slotTypeSummaries = builder.slotTypeSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the bot that contains the slot types.
     * </p>
     * 
     * @return The identifier of the bot that contains the slot types.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the slot types.
     * </p>
     * 
     * @return The version of the bot that contains the slot types.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The language and local of the slot types in the list.
     * </p>
     * 
     * @return The language and local of the slot types in the list.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * Returns true if the SlotTypeSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSlotTypeSummaries() {
        return slotTypeSummaries != null && !(slotTypeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the slot types that meet the filter criteria specified in the request. The length of the
     * list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types
     * available, the <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSlotTypeSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information for the slot types that meet the filter criteria specified in the request. The length
     *         of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot
     *         types available, the <code>nextToken</code> field contains a token to get the next page of results.
     */
    public final List<SlotTypeSummary> slotTypeSummaries() {
        return slotTypeSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the
     *         contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get
     *         the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotTypeSummaries() ? slotTypeSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlotTypesResponse)) {
            return false;
        }
        ListSlotTypesResponse other = (ListSlotTypesResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && hasSlotTypeSummaries() == other.hasSlotTypeSummaries()
                && Objects.equals(slotTypeSummaries(), other.slotTypeSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSlotTypesResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("SlotTypeSummaries", hasSlotTypeSummaries() ? slotTypeSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "slotTypeSummaries":
            return Optional.ofNullable(clazz.cast(slotTypeSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSlotTypesResponse, T> g) {
        return obj -> g.apply((ListSlotTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListSlotTypesResponse> {
        /**
         * <p>
         * The identifier of the bot that contains the slot types.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the slot types.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The language and local of the slot types in the list.
         * </p>
         * 
         * @param localeId
         *        The language and local of the slot types in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Summary information for the slot types that meet the filter criteria specified in the request. The length of
         * the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param slotTypeSummaries
         *        Summary information for the slot types that meet the filter criteria specified in the request. The
         *        length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
         *        more slot types available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeSummaries(Collection<SlotTypeSummary> slotTypeSummaries);

        /**
         * <p>
         * Summary information for the slot types that meet the filter criteria specified in the request. The length of
         * the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param slotTypeSummaries
         *        Summary information for the slot types that meet the filter criteria specified in the request. The
         *        length of the list is specified in the <code>maxResults</code> parameter of the request. If there are
         *        more slot types available, the <code>nextToken</code> field contains a token to get the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeSummaries(SlotTypeSummary... slotTypeSummaries);

        /**
         * <p>
         * Summary information for the slot types that meet the filter criteria specified in the request. The length of
         * the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types
         * available, the <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotTypeSummary>.Builder} avoiding the need
         * to create one manually via {@link List<SlotTypeSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotTypeSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #slotTypeSummaries(List<SlotTypeSummary>)}.
         * 
         * @param slotTypeSummaries
         *        a consumer that will call methods on {@link List<SlotTypeSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypeSummaries(List<SlotTypeSummary>)
         */
        Builder slotTypeSummaries(Consumer<SlotTypeSummary.Builder>... slotTypeSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents
         * as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next
         * page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the
         *        contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to
         *        get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private List<SlotTypeSummary> slotTypeSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlotTypesResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            slotTypeSummaries(model.slotTypeSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final List<SlotTypeSummary.Builder> getSlotTypeSummaries() {
            List<SlotTypeSummary.Builder> result = SlotTypeSummaryListCopier.copyToBuilder(this.slotTypeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder slotTypeSummaries(Collection<SlotTypeSummary> slotTypeSummaries) {
            this.slotTypeSummaries = SlotTypeSummaryListCopier.copy(slotTypeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeSummaries(SlotTypeSummary... slotTypeSummaries) {
            slotTypeSummaries(Arrays.asList(slotTypeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypeSummaries(Consumer<SlotTypeSummary.Builder>... slotTypeSummaries) {
            slotTypeSummaries(Stream.of(slotTypeSummaries).map(c -> SlotTypeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypeSummaries(Collection<SlotTypeSummary.BuilderImpl> slotTypeSummaries) {
            this.slotTypeSummaries = SlotTypeSummaryListCopier.copyFromBuilder(slotTypeSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSlotTypesResponse build() {
            return new ListSlotTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
