/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExportsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListExportsResponse.Builder, ListExportsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListExportsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListExportsResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<List<ExportSummary>> EXPORT_SUMMARIES_FIELD = SdkField
            .<List<ExportSummary>> builder(MarshallingType.LIST)
            .memberName("exportSummaries")
            .getter(getter(ListExportsResponse::exportSummaries))
            .setter(setter(Builder::exportSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListExportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, EXPORT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String botVersion;

    private final List<ExportSummary> exportSummaries;

    private final String nextToken;

    private ListExportsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.exportSummaries = builder.exportSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier assigned to the bot by Amazon Lex.
     * </p>
     * 
     * @return The unique identifier assigned to the bot by Amazon Lex.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that was exported.
     * </p>
     * 
     * @return The version of the bot that was exported.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * Returns true if the ExportSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExportSummaries() {
        return exportSummaries != null && !(exportSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the exports that meet the filter criteria specified in the request. The length of the
     * list is specified in the <code>maxResults</code> parameter. If there are more exports available, the
     * <code>nextToken</code> field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information for the exports that meet the filter criteria specified in the request. The length of
     *         the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the
     *         <code>nextToken</code> field contains a token to get the next page of results.
     */
    public final List<ExportSummary> exportSummaries() {
        return exportSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListExports</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListExports</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents
     *         as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasExportSummaries() ? exportSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && hasExportSummaries() == other.hasExportSummaries()
                && Objects.equals(exportSummaries(), other.exportSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExportsResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("ExportSummaries", hasExportSummaries() ? exportSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "exportSummaries":
            return Optional.ofNullable(clazz.cast(exportSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExportsResponse, T> g) {
        return obj -> g.apply((ListExportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListExportsResponse> {
        /**
         * <p>
         * The unique identifier assigned to the bot by Amazon Lex.
         * </p>
         * 
         * @param botId
         *        The unique identifier assigned to the bot by Amazon Lex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that was exported.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * Summary information for the exports that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter. If there are more exports available, the
         * <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param exportSummaries
         *        Summary information for the exports that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter. If there are more exports
         *        available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSummaries(Collection<ExportSummary> exportSummaries);

        /**
         * <p>
         * Summary information for the exports that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter. If there are more exports available, the
         * <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * 
         * @param exportSummaries
         *        Summary information for the exports that meet the filter criteria specified in the request. The length
         *        of the list is specified in the <code>maxResults</code> parameter. If there are more exports
         *        available, the <code>nextToken</code> field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSummaries(ExportSummary... exportSummaries);

        /**
         * <p>
         * Summary information for the exports that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter. If there are more exports available, the
         * <code>nextToken</code> field contains a token to get the next page of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExportSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ExportSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #exportSummaries(List<ExportSummary>)}.
         * 
         * @param exportSummaries
         *        a consumer that will call methods on {@link List<ExportSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportSummaries(List<ExportSummary>)
         */
        Builder exportSummaries(Consumer<ExportSummary.Builder>... exportSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the <code>ListExports</code>
         * operation. If the <code>nextToken</code> field is present, you send the contents as the
         * <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the
         *        contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to
         *        get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private List<ExportSummary> exportSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            exportSummaries(model.exportSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final List<ExportSummary.Builder> getExportSummaries() {
            List<ExportSummary.Builder> result = ExportSummaryListCopier.copyToBuilder(this.exportSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder exportSummaries(Collection<ExportSummary> exportSummaries) {
            this.exportSummaries = ExportSummaryListCopier.copy(exportSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSummaries(ExportSummary... exportSummaries) {
            exportSummaries(Arrays.asList(exportSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSummaries(Consumer<ExportSummary.Builder>... exportSummaries) {
            exportSummaries(Stream.of(exportSummaries).map(c -> ExportSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExportSummaries(Collection<ExportSummary.BuilderImpl> exportSummaries) {
            this.exportSummaries = ExportSummaryListCopier.copyFromBuilder(exportSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
