/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the bot parameters required for importing a bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotImportSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<BotImportSpecification.Builder, BotImportSpecification> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(BotImportSpecification::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(BotImportSpecification::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.<DataPrivacy> builder(MarshallingType.SDK_POJO)
            .memberName("dataPrivacy").getter(getter(BotImportSpecification::dataPrivacy)).setter(setter(Builder::dataPrivacy))
            .constructor(DataPrivacy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(BotImportSpecification::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<Map<String, String>> BOT_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("botTags")
            .getter(getter(BotImportSpecification::botTags))
            .setter(setter(Builder::botTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TEST_BOT_ALIAS_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("testBotAliasTags")
            .getter(getter(BotImportSpecification::testBotAliasTags))
            .setter(setter(Builder::testBotAliasTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testBotAliasTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, BOT_TAGS_FIELD, TEST_BOT_ALIAS_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botName;

    private final String roleArn;

    private final DataPrivacy dataPrivacy;

    private final Integer idleSessionTTLInSeconds;

    private final Map<String, String> botTags;

    private final Map<String, String> testBotAliasTags;

    private BotImportSpecification(BuilderImpl builder) {
        this.botName = builder.botName;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.botTags = builder.botTags;
        this.testBotAliasTags = builder.testBotAliasTags;
    }

    /**
     * <p>
     * The name that Amazon Lex should use for the bot.
     * </p>
     * 
     * @return The name that Amazon Lex should use for the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the DataPrivacy property for this object.
     * 
     * @return The value of the DataPrivacy property for this object.
     */
    public final DataPrivacy dataPrivacy() {
        return dataPrivacy;
    }

    /**
     * <p>
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and Amazon Lex deletes any data provided before the timeout.
     * </p>
     * <p>
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     * </p>
     * 
     * @return The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     *         </p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *         </p>
     *         <p>
     *         You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * Returns true if the BotTags property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBotTags() {
        return botTags != null && !(botTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the
     * <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBotTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the
     *         <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code>
     *         operation.
     */
    public final Map<String, String> botTags() {
        return botTags;
    }

    /**
     * Returns true if the TestBotAliasTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTestBotAliasTags() {
        return testBotAliasTags != null && !(testBotAliasTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't use the
     * <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the
     * <code>TagResource</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTestBotAliasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't
     *         use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the
     *         <code>TagResource</code> operation.
     */
    public final Map<String, String> testBotAliasTags() {
        return testBotAliasTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotTags() ? botTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTestBotAliasTags() ? testBotAliasTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotImportSpecification)) {
            return false;
        }
        BotImportSpecification other = (BotImportSpecification) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPrivacy(), other.dataPrivacy())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && hasBotTags() == other.hasBotTags() && Objects.equals(botTags(), other.botTags())
                && hasTestBotAliasTags() == other.hasTestBotAliasTags()
                && Objects.equals(testBotAliasTags(), other.testBotAliasTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotImportSpecification").add("BotName", botName()).add("RoleArn", roleArn())
                .add("DataPrivacy", dataPrivacy()).add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("BotTags", hasBotTags() ? botTags() : null)
                .add("TestBotAliasTags", hasTestBotAliasTags() ? testBotAliasTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataPrivacy":
            return Optional.ofNullable(clazz.cast(dataPrivacy()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "botTags":
            return Optional.ofNullable(clazz.cast(botTags()));
        case "testBotAliasTags":
            return Optional.ofNullable(clazz.cast(testBotAliasTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotImportSpecification, T> g) {
        return obj -> g.apply((BotImportSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotImportSpecification> {
        /**
         * <p>
         * The name that Amazon Lex should use for the bot.
         * </p>
         * 
         * @param botName
         *        The name that Amazon Lex should use for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the DataPrivacy property for this object.
         *
         * @param dataPrivacy
         *        The new value for the DataPrivacy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacy(DataPrivacy dataPrivacy);

        /**
         * Sets the value of the DataPrivacy property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataPrivacy.Builder} avoiding the need to create
         * one manually via {@link DataPrivacy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataPrivacy.Builder#build()} is called immediately and its result
         * is passed to {@link #dataPrivacy(DataPrivacy)}.
         * 
         * @param dataPrivacy
         *        a consumer that will call methods on {@link DataPrivacy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacy(DataPrivacy)
         */
        default Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return dataPrivacy(DataPrivacy.builder().applyMutation(dataPrivacy).build());
        }

        /**
         * <p>
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and Amazon Lex deletes any data provided before the timeout.
         * </p>
         * <p>
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The time, in seconds, that Amazon Lex should keep information about a user's conversation with the
         *        bot. </p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *        </p>
         *        <p>
         *        You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the
         * <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
         * </p>
         * 
         * @param botTags
         *        A list of tags to add to the bot. You can only add tags when you import a bot. You can't use the
         *        <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botTags(Map<String, String> botTags);

        /**
         * <p>
         * A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You can't use
         * the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the
         * <code>TagResource</code> operation.
         * </p>
         * 
         * @param testBotAliasTags
         *        A list of tags to add to the test alias for a bot. You can only add tags when you import a bot. You
         *        can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use
         *        the <code>TagResource</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testBotAliasTags(Map<String, String> testBotAliasTags);
    }

    static final class BuilderImpl implements Builder {
        private String botName;

        private String roleArn;

        private DataPrivacy dataPrivacy;

        private Integer idleSessionTTLInSeconds;

        private Map<String, String> botTags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> testBotAliasTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BotImportSpecification model) {
            botName(model.botName);
            roleArn(model.roleArn);
            dataPrivacy(model.dataPrivacy);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            botTags(model.botTags);
            testBotAliasTags(model.testBotAliasTags);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return dataPrivacy != null ? dataPrivacy.toBuilder() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        public final Map<String, String> getBotTags() {
            if (botTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return botTags;
        }

        @Override
        public final Builder botTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
            return this;
        }

        public final void setBotTags(Map<String, String> botTags) {
            this.botTags = TagMapCopier.copy(botTags);
        }

        public final Map<String, String> getTestBotAliasTags() {
            if (testBotAliasTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return testBotAliasTags;
        }

        @Override
        public final Builder testBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
            return this;
        }

        public final void setTestBotAliasTags(Map<String, String> testBotAliasTags) {
            this.testBotAliasTags = TagMapCopier.copy(testBotAliasTags);
        }

        @Override
        public BotImportSpecification build() {
            return new BotImportSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
