/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIntentResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeIntentResponse.Builder, DescribeIntentResponse> {
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(DescribeIntentResponse::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()).build();

    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(DescribeIntentResponse::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeIntentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIntentSignature").getter(getter(DescribeIntentResponse::parentIntentSignature))
            .setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<SampleUtterance>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(DescribeIntentResponse::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleUtterance> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleUtterance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DialogCodeHookSettings> DIALOG_CODE_HOOK_FIELD = SdkField
            .<DialogCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("dialogCodeHook")
            .getter(getter(DescribeIntentResponse::dialogCodeHook)).setter(setter(Builder::dialogCodeHook))
            .constructor(DialogCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()).build();

    private static final SdkField<FulfillmentCodeHookSettings> FULFILLMENT_CODE_HOOK_FIELD = SdkField
            .<FulfillmentCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("fulfillmentCodeHook")
            .getter(getter(DescribeIntentResponse::fulfillmentCodeHook)).setter(setter(Builder::fulfillmentCodeHook))
            .constructor(FulfillmentCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentCodeHook").build())
            .build();

    private static final SdkField<List<SlotPriority>> SLOT_PRIORITIES_FIELD = SdkField
            .<List<SlotPriority>> builder(MarshallingType.LIST)
            .memberName("slotPriorities")
            .getter(getter(DescribeIntentResponse::slotPriorities))
            .setter(setter(Builder::slotPriorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotPriorities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotPriority> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotPriority::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IntentConfirmationSetting> INTENT_CONFIRMATION_SETTING_FIELD = SdkField
            .<IntentConfirmationSetting> builder(MarshallingType.SDK_POJO).memberName("intentConfirmationSetting")
            .getter(getter(DescribeIntentResponse::intentConfirmationSetting)).setter(setter(Builder::intentConfirmationSetting))
            .constructor(IntentConfirmationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentConfirmationSetting").build())
            .build();

    private static final SdkField<IntentClosingSetting> INTENT_CLOSING_SETTING_FIELD = SdkField
            .<IntentClosingSetting> builder(MarshallingType.SDK_POJO).memberName("intentClosingSetting")
            .getter(getter(DescribeIntentResponse::intentClosingSetting)).setter(setter(Builder::intentClosingSetting))
            .constructor(IntentClosingSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClosingSetting").build())
            .build();

    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField
            .<List<InputContext>> builder(MarshallingType.LIST)
            .memberName("inputContexts")
            .getter(getter(DescribeIntentResponse::inputContexts))
            .setter(setter(Builder::inputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField
            .<List<OutputContext>> builder(MarshallingType.LIST)
            .memberName("outputContexts")
            .getter(getter(DescribeIntentResponse::outputContexts))
            .setter(setter(Builder::outputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<KendraConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraConfiguration")
            .getter(getter(DescribeIntentResponse::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(KendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeIntentResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeIntentResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DescribeIntentResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeIntentResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeIntentResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_ID_FIELD,
            INTENT_NAME_FIELD, DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, SAMPLE_UTTERANCES_FIELD, DIALOG_CODE_HOOK_FIELD,
            FULFILLMENT_CODE_HOOK_FIELD, SLOT_PRIORITIES_FIELD, INTENT_CONFIRMATION_SETTING_FIELD, INTENT_CLOSING_SETTING_FIELD,
            INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD, KENDRA_CONFIGURATION_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD,
            LOCALE_ID_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private final String intentId;

    private final String intentName;

    private final String description;

    private final String parentIntentSignature;

    private final List<SampleUtterance> sampleUtterances;

    private final DialogCodeHookSettings dialogCodeHook;

    private final FulfillmentCodeHookSettings fulfillmentCodeHook;

    private final List<SlotPriority> slotPriorities;

    private final IntentConfirmationSetting intentConfirmationSetting;

    private final IntentClosingSetting intentClosingSetting;

    private final List<InputContext> inputContexts;

    private final List<OutputContext> outputContexts;

    private final KendraConfiguration kendraConfiguration;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private DescribeIntentResponse(BuilderImpl builder) {
        super(builder);
        this.intentId = builder.intentId;
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.sampleUtterances = builder.sampleUtterances;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
        this.slotPriorities = builder.slotPriorities;
        this.intentConfirmationSetting = builder.intentConfirmationSetting;
        this.intentClosingSetting = builder.intentClosingSetting;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier assigned to the intent when it was created.
     * </p>
     * 
     * @return The unique identifier assigned to the intent when it was created.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * The name specified for the intent.
     * </p>
     * 
     * @return The name specified for the intent.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The description of the intent.
     * </p>
     * 
     * @return The description of the intent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the built-in intent that this intent is derived from, if any.
     * </p>
     * 
     * @return The identifier of the built-in intent that this intent is derived from, if any.
     */
    public final String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * Returns true if the SampleUtterances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * User utterances that trigger this intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSampleUtterances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return User utterances that trigger this intent.
     */
    public final List<SampleUtterance> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * The Lambda function called during each turn of a conversation with the intent.
     * </p>
     * 
     * @return The Lambda function called during each turn of a conversation with the intent.
     */
    public final DialogCodeHookSettings dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * The Lambda function called when the intent is complete and ready for fulfillment.
     * </p>
     * 
     * @return The Lambda function called when the intent is complete and ready for fulfillment.
     */
    public final FulfillmentCodeHookSettings fulfillmentCodeHook() {
        return fulfillmentCodeHook;
    }

    /**
     * Returns true if the SlotPriorities property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSlotPriorities() {
        return slotPriorities != null && !(slotPriorities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list that determines the priority that slots should be elicited from the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSlotPriorities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list that determines the priority that slots should be elicited from the user.
     */
    public final List<SlotPriority> slotPriorities() {
        return slotPriorities;
    }

    /**
     * <p>
     * Prompts that Amazon Lex sends to the user to confirm completion of an intent.
     * </p>
     * 
     * @return Prompts that Amazon Lex sends to the user to confirm completion of an intent.
     */
    public final IntentConfirmationSetting intentConfirmationSetting() {
        return intentConfirmationSetting;
    }

    /**
     * <p>
     * The response that Amazon Lex sends to when the intent is closed.
     * </p>
     * 
     * @return The response that Amazon Lex sends to when the intent is closed.
     */
    public final IntentClosingSetting intentClosingSetting() {
        return intentClosingSetting;
    }

    /**
     * Returns true if the InputContexts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInputContexts() {
        return inputContexts != null && !(inputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of contexts that must be active for the intent to be considered for sending to the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputContexts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of contexts that must be active for the intent to be considered for sending to the user.
     */
    public final List<InputContext> inputContexts() {
        return inputContexts;
    }

    /**
     * Returns true if the OutputContexts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputContexts() {
        return outputContexts != null && !(outputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of contexts that are activated when the intent is fulfilled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputContexts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of contexts that are activated when the intent is fulfilled.
     */
    public final List<OutputContext> outputContexts() {
        return outputContexts;
    }

    /**
     * <p>
     * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.
     * </p>
     * 
     * @return Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.
     */
    public final KendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    /**
     * <p>
     * The identifier of the bot associated with the intent.
     * </p>
     * 
     * @return The identifier of the bot associated with the intent.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot associated with the intent.
     * </p>
     * 
     * @return The version of the bot associated with the intent.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The language and locale specified for the intent.
     * </p>
     * 
     * @return The language and locale specified for the intent.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * A timestamp of the date and time that the intent was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the intent was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the intent was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the intent was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotPriorities() ? slotPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(intentConfirmationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(intentClosingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputContexts() ? inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputContexts() ? outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIntentResponse)) {
            return false;
        }
        DescribeIntentResponse other = (DescribeIntentResponse) obj;
        return Objects.equals(intentId(), other.intentId()) && Objects.equals(intentName(), other.intentName())
                && Objects.equals(description(), other.description())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(dialogCodeHook(), other.dialogCodeHook())
                && Objects.equals(fulfillmentCodeHook(), other.fulfillmentCodeHook())
                && hasSlotPriorities() == other.hasSlotPriorities() && Objects.equals(slotPriorities(), other.slotPriorities())
                && Objects.equals(intentConfirmationSetting(), other.intentConfirmationSetting())
                && Objects.equals(intentClosingSetting(), other.intentClosingSetting())
                && hasInputContexts() == other.hasInputContexts() && Objects.equals(inputContexts(), other.inputContexts())
                && hasOutputContexts() == other.hasOutputContexts() && Objects.equals(outputContexts(), other.outputContexts())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIntentResponse").add("IntentId", intentId()).add("IntentName", intentName())
                .add("Description", description()).add("ParentIntentSignature", parentIntentSignature())
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("DialogCodeHook", dialogCodeHook()).add("FulfillmentCodeHook", fulfillmentCodeHook())
                .add("SlotPriorities", hasSlotPriorities() ? slotPriorities() : null)
                .add("IntentConfirmationSetting", intentConfirmationSetting())
                .add("IntentClosingSetting", intentClosingSetting())
                .add("InputContexts", hasInputContexts() ? inputContexts() : null)
                .add("OutputContexts", hasOutputContexts() ? outputContexts() : null)
                .add("KendraConfiguration", kendraConfiguration()).add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "dialogCodeHook":
            return Optional.ofNullable(clazz.cast(dialogCodeHook()));
        case "fulfillmentCodeHook":
            return Optional.ofNullable(clazz.cast(fulfillmentCodeHook()));
        case "slotPriorities":
            return Optional.ofNullable(clazz.cast(slotPriorities()));
        case "intentConfirmationSetting":
            return Optional.ofNullable(clazz.cast(intentConfirmationSetting()));
        case "intentClosingSetting":
            return Optional.ofNullable(clazz.cast(intentClosingSetting()));
        case "inputContexts":
            return Optional.ofNullable(clazz.cast(inputContexts()));
        case "outputContexts":
            return Optional.ofNullable(clazz.cast(outputContexts()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIntentResponse, T> g) {
        return obj -> g.apply((DescribeIntentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIntentResponse> {
        /**
         * <p>
         * The unique identifier assigned to the intent when it was created.
         * </p>
         * 
         * @param intentId
         *        The unique identifier assigned to the intent when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * The name specified for the intent.
         * </p>
         * 
         * @param intentName
         *        The name specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The description of the intent.
         * </p>
         * 
         * @param description
         *        The description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the built-in intent that this intent is derived from, if any.
         * </p>
         * 
         * @param parentIntentSignature
         *        The identifier of the built-in intent that this intent is derived from, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * User utterances that trigger this intent.
         * </p>
         * 
         * @param sampleUtterances
         *        User utterances that trigger this intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances);

        /**
         * <p>
         * User utterances that trigger this intent.
         * </p>
         * 
         * @param sampleUtterances
         *        User utterances that trigger this intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(SampleUtterance... sampleUtterances);

        /**
         * <p>
         * User utterances that trigger this intent.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SampleUtterance>.Builder} avoiding the need
         * to create one manually via {@link List<SampleUtterance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SampleUtterance>.Builder#build()} is called immediately and
         * its result is passed to {@link #sampleUtterances(List<SampleUtterance>)}.
         * 
         * @param sampleUtterances
         *        a consumer that will call methods on {@link List<SampleUtterance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleUtterances(List<SampleUtterance>)
         */
        Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances);

        /**
         * <p>
         * The Lambda function called during each turn of a conversation with the intent.
         * </p>
         * 
         * @param dialogCodeHook
         *        The Lambda function called during each turn of a conversation with the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook);

        /**
         * <p>
         * The Lambda function called during each turn of a conversation with the intent.
         * </p>
         * This is a convenience that creates an instance of the {@link DialogCodeHookSettings.Builder} avoiding the
         * need to create one manually via {@link DialogCodeHookSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DialogCodeHookSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dialogCodeHook(DialogCodeHookSettings)}.
         * 
         * @param dialogCodeHook
         *        a consumer that will call methods on {@link DialogCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogCodeHook(DialogCodeHookSettings)
         */
        default Builder dialogCodeHook(Consumer<DialogCodeHookSettings.Builder> dialogCodeHook) {
            return dialogCodeHook(DialogCodeHookSettings.builder().applyMutation(dialogCodeHook).build());
        }

        /**
         * <p>
         * The Lambda function called when the intent is complete and ready for fulfillment.
         * </p>
         * 
         * @param fulfillmentCodeHook
         *        The Lambda function called when the intent is complete and ready for fulfillment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook);

        /**
         * <p>
         * The Lambda function called when the intent is complete and ready for fulfillment.
         * </p>
         * This is a convenience that creates an instance of the {@link FulfillmentCodeHookSettings.Builder} avoiding
         * the need to create one manually via {@link FulfillmentCodeHookSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FulfillmentCodeHookSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #fulfillmentCodeHook(FulfillmentCodeHookSettings)}.
         * 
         * @param fulfillmentCodeHook
         *        a consumer that will call methods on {@link FulfillmentCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentCodeHook(FulfillmentCodeHookSettings)
         */
        default Builder fulfillmentCodeHook(Consumer<FulfillmentCodeHookSettings.Builder> fulfillmentCodeHook) {
            return fulfillmentCodeHook(FulfillmentCodeHookSettings.builder().applyMutation(fulfillmentCodeHook).build());
        }

        /**
         * <p>
         * The list that determines the priority that slots should be elicited from the user.
         * </p>
         * 
         * @param slotPriorities
         *        The list that determines the priority that slots should be elicited from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotPriorities(Collection<SlotPriority> slotPriorities);

        /**
         * <p>
         * The list that determines the priority that slots should be elicited from the user.
         * </p>
         * 
         * @param slotPriorities
         *        The list that determines the priority that slots should be elicited from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotPriorities(SlotPriority... slotPriorities);

        /**
         * <p>
         * The list that determines the priority that slots should be elicited from the user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SlotPriority>.Builder} avoiding the need to
         * create one manually via {@link List<SlotPriority>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SlotPriority>.Builder#build()} is called immediately and its
         * result is passed to {@link #slotPriorities(List<SlotPriority>)}.
         * 
         * @param slotPriorities
         *        a consumer that will call methods on {@link List<SlotPriority>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotPriorities(List<SlotPriority>)
         */
        Builder slotPriorities(Consumer<SlotPriority.Builder>... slotPriorities);

        /**
         * <p>
         * Prompts that Amazon Lex sends to the user to confirm completion of an intent.
         * </p>
         * 
         * @param intentConfirmationSetting
         *        Prompts that Amazon Lex sends to the user to confirm completion of an intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting);

        /**
         * <p>
         * Prompts that Amazon Lex sends to the user to confirm completion of an intent.
         * </p>
         * This is a convenience that creates an instance of the {@link IntentConfirmationSetting.Builder} avoiding the
         * need to create one manually via {@link IntentConfirmationSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link IntentConfirmationSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #intentConfirmationSetting(IntentConfirmationSetting)}.
         * 
         * @param intentConfirmationSetting
         *        a consumer that will call methods on {@link IntentConfirmationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentConfirmationSetting(IntentConfirmationSetting)
         */
        default Builder intentConfirmationSetting(Consumer<IntentConfirmationSetting.Builder> intentConfirmationSetting) {
            return intentConfirmationSetting(IntentConfirmationSetting.builder().applyMutation(intentConfirmationSetting).build());
        }

        /**
         * <p>
         * The response that Amazon Lex sends to when the intent is closed.
         * </p>
         * 
         * @param intentClosingSetting
         *        The response that Amazon Lex sends to when the intent is closed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentClosingSetting(IntentClosingSetting intentClosingSetting);

        /**
         * <p>
         * The response that Amazon Lex sends to when the intent is closed.
         * </p>
         * This is a convenience that creates an instance of the {@link IntentClosingSetting.Builder} avoiding the need
         * to create one manually via {@link IntentClosingSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link IntentClosingSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #intentClosingSetting(IntentClosingSetting)}.
         * 
         * @param intentClosingSetting
         *        a consumer that will call methods on {@link IntentClosingSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentClosingSetting(IntentClosingSetting)
         */
        default Builder intentClosingSetting(Consumer<IntentClosingSetting.Builder> intentClosingSetting) {
            return intentClosingSetting(IntentClosingSetting.builder().applyMutation(intentClosingSetting).build());
        }

        /**
         * <p>
         * A list of contexts that must be active for the intent to be considered for sending to the user.
         * </p>
         * 
         * @param inputContexts
         *        A list of contexts that must be active for the intent to be considered for sending to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(Collection<InputContext> inputContexts);

        /**
         * <p>
         * A list of contexts that must be active for the intent to be considered for sending to the user.
         * </p>
         * 
         * @param inputContexts
         *        A list of contexts that must be active for the intent to be considered for sending to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(InputContext... inputContexts);

        /**
         * <p>
         * A list of contexts that must be active for the intent to be considered for sending to the user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InputContext>.Builder} avoiding the need to
         * create one manually via {@link List<InputContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputContext>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputContexts(List<InputContext>)}.
         * 
         * @param inputContexts
         *        a consumer that will call methods on {@link List<InputContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputContexts(List<InputContext>)
         */
        Builder inputContexts(Consumer<InputContext.Builder>... inputContexts);

        /**
         * <p>
         * A list of contexts that are activated when the intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        A list of contexts that are activated when the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(Collection<OutputContext> outputContexts);

        /**
         * <p>
         * A list of contexts that are activated when the intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        A list of contexts that are activated when the intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(OutputContext... outputContexts);

        /**
         * <p>
         * A list of contexts that are activated when the intent is fulfilled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OutputContext>.Builder} avoiding the need
         * to create one manually via {@link List<OutputContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputContext>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputContexts(List<OutputContext>)}.
         * 
         * @param outputContexts
         *        a consumer that will call methods on {@link List<OutputContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputContexts(List<OutputContext>)
         */
        Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts);

        /**
         * <p>
         * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * 
         * @param kendraConfiguration
         *        Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(KendraConfiguration kendraConfiguration);

        /**
         * <p>
         * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.
         * </p>
         * This is a convenience that creates an instance of the {@link KendraConfiguration.Builder} avoiding the need
         * to create one manually via {@link KendraConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link KendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(KendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link KendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(KendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(KendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the bot associated with the intent.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot associated with the intent.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The language and locale specified for the intent.
         * </p>
         * 
         * @param localeId
         *        The language and locale specified for the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A timestamp of the date and time that the intent was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the intent was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the intent was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the intent was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String intentId;

        private String intentName;

        private String description;

        private String parentIntentSignature;

        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private DialogCodeHookSettings dialogCodeHook;

        private FulfillmentCodeHookSettings fulfillmentCodeHook;

        private List<SlotPriority> slotPriorities = DefaultSdkAutoConstructList.getInstance();

        private IntentConfirmationSetting intentConfirmationSetting;

        private IntentClosingSetting intentClosingSetting;

        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();

        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private KendraConfiguration kendraConfiguration;

        private String botId;

        private String botVersion;

        private String localeId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIntentResponse model) {
            super(model);
            intentId(model.intentId);
            intentName(model.intentName);
            description(model.description);
            parentIntentSignature(model.parentIntentSignature);
            sampleUtterances(model.sampleUtterances);
            dialogCodeHook(model.dialogCodeHook);
            fulfillmentCodeHook(model.fulfillmentCodeHook);
            slotPriorities(model.slotPriorities);
            intentConfirmationSetting(model.intentConfirmationSetting);
            intentClosingSetting(model.intentClosingSetting);
            inputContexts(model.inputContexts);
            outputContexts(model.outputContexts);
            kendraConfiguration(model.kendraConfiguration);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getIntentId() {
            return intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        public final String getIntentName() {
            return intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances) {
            sampleUtterances(Stream.of(sampleUtterances).map(c -> SampleUtterance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        public final DialogCodeHookSettings.Builder getDialogCodeHook() {
            return dialogCodeHook != null ? dialogCodeHook.toBuilder() : null;
        }

        @Override
        public final Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final void setDialogCodeHook(DialogCodeHookSettings.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        public final FulfillmentCodeHookSettings.Builder getFulfillmentCodeHook() {
            return fulfillmentCodeHook != null ? fulfillmentCodeHook.toBuilder() : null;
        }

        @Override
        public final Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook;
            return this;
        }

        public final void setFulfillmentCodeHook(FulfillmentCodeHookSettings.BuilderImpl fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook != null ? fulfillmentCodeHook.build() : null;
        }

        public final List<SlotPriority.Builder> getSlotPriorities() {
            List<SlotPriority.Builder> result = SlotPrioritiesListCopier.copyToBuilder(this.slotPriorities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder slotPriorities(Collection<SlotPriority> slotPriorities) {
            this.slotPriorities = SlotPrioritiesListCopier.copy(slotPriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotPriorities(SlotPriority... slotPriorities) {
            slotPriorities(Arrays.asList(slotPriorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotPriorities(Consumer<SlotPriority.Builder>... slotPriorities) {
            slotPriorities(Stream.of(slotPriorities).map(c -> SlotPriority.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSlotPriorities(Collection<SlotPriority.BuilderImpl> slotPriorities) {
            this.slotPriorities = SlotPrioritiesListCopier.copyFromBuilder(slotPriorities);
        }

        public final IntentConfirmationSetting.Builder getIntentConfirmationSetting() {
            return intentConfirmationSetting != null ? intentConfirmationSetting.toBuilder() : null;
        }

        @Override
        public final Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting;
            return this;
        }

        public final void setIntentConfirmationSetting(IntentConfirmationSetting.BuilderImpl intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting != null ? intentConfirmationSetting.build() : null;
        }

        public final IntentClosingSetting.Builder getIntentClosingSetting() {
            return intentClosingSetting != null ? intentClosingSetting.toBuilder() : null;
        }

        @Override
        public final Builder intentClosingSetting(IntentClosingSetting intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting;
            return this;
        }

        public final void setIntentClosingSetting(IntentClosingSetting.BuilderImpl intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting != null ? intentClosingSetting.build() : null;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext... inputContexts) {
            inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder>... inputContexts) {
            inputContexts(Stream.of(inputContexts).map(c -> InputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext... outputContexts) {
            outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts) {
            outputContexts(Stream.of(outputContexts).map(c -> OutputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public DescribeIntentResponse build() {
            return new DescribeIntentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
