/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an import in an import list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSummary implements SdkPojo, Serializable, ToCopyableBuilder<ImportSummary.Builder, ImportSummary> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(ImportSummary::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final SdkField<String> IMPORTED_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedResourceId").getter(getter(ImportSummary::importedResourceId))
            .setter(setter(Builder::importedResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceId").build())
            .build();

    private static final SdkField<String> IMPORTED_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importedResourceName").getter(getter(ImportSummary::importedResourceName))
            .setter(setter(Builder::importedResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedResourceName").build())
            .build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importStatus").getter(getter(ImportSummary::importStatusAsString)).setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()).build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeStrategy").getter(getter(ImportSummary::mergeStrategyAsString))
            .setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeStrategy").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(ImportSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(ImportSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD,
            IMPORTED_RESOURCE_ID_FIELD, IMPORTED_RESOURCE_NAME_FIELD, IMPORT_STATUS_FIELD, MERGE_STRATEGY_FIELD,
            CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String importId;

    private final String importedResourceId;

    private final String importedResourceName;

    private final String importStatus;

    private final String mergeStrategy;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private ImportSummary(BuilderImpl builder) {
        this.importId = builder.importId;
        this.importedResourceId = builder.importedResourceId;
        this.importedResourceName = builder.importedResourceName;
        this.importStatus = builder.importStatus;
        this.mergeStrategy = builder.mergeStrategy;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier that Amazon Lex assigned to the import.
     * </p>
     * 
     * @return The unique identifier that Amazon Lex assigned to the import.
     */
    public final String importId() {
        return importId;
    }

    /**
     * <p>
     * The unique identifier that Amazon Lex assigned to the imported resource.
     * </p>
     * 
     * @return The unique identifier that Amazon Lex assigned to the imported resource.
     */
    public final String importedResourceId() {
        return importedResourceId;
    }

    /**
     * <p>
     * The name that you gave the imported resource.
     * </p>
     * 
     * @return The name that you gave the imported resource.
     */
    public final String importedResourceName() {
        return importedResourceName;
    }

    /**
     * <p>
     * The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
     * @see ImportStatus
     */
    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
     * @see ImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    /**
     * <p>
     * The strategy used to merge existing bot or bot locale definitions with the imported definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to merge existing bot or bot locale definitions with the imported definition.
     * @see MergeStrategy
     */
    public final MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The strategy used to merge existing bot or bot locale definitions with the imported definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The strategy used to merge existing bot or bot locale definitions with the imported definition.
     * @see MergeStrategy
     */
    public final String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The date and time that the import was created.
     * </p>
     * 
     * @return The date and time that the import was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time that the import was last updated.
     * </p>
     * 
     * @return The date and time that the import was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(importedResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(importedResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSummary)) {
            return false;
        }
        ImportSummary other = (ImportSummary) obj;
        return Objects.equals(importId(), other.importId()) && Objects.equals(importedResourceId(), other.importedResourceId())
                && Objects.equals(importedResourceName(), other.importedResourceName())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSummary").add("ImportId", importId()).add("ImportedResourceId", importedResourceId())
                .add("ImportedResourceName", importedResourceName()).add("ImportStatus", importStatusAsString())
                .add("MergeStrategy", mergeStrategyAsString()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "importedResourceId":
            return Optional.ofNullable(clazz.cast(importedResourceId()));
        case "importedResourceName":
            return Optional.ofNullable(clazz.cast(importedResourceName()));
        case "importStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "mergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSummary, T> g) {
        return obj -> g.apply((ImportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportSummary> {
        /**
         * <p>
         * The unique identifier that Amazon Lex assigned to the import.
         * </p>
         * 
         * @param importId
         *        The unique identifier that Amazon Lex assigned to the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * The unique identifier that Amazon Lex assigned to the imported resource.
         * </p>
         * 
         * @param importedResourceId
         *        The unique identifier that Amazon Lex assigned to the imported resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedResourceId(String importedResourceId);

        /**
         * <p>
         * The name that you gave the imported resource.
         * </p>
         * 
         * @param importedResourceName
         *        The name that you gave the imported resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedResourceName(String importedResourceName);

        /**
         * <p>
         * The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
         * </p>
         * 
         * @param importStatus
         *        The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
         * </p>
         * 
         * @param importStatus
         *        The status of the resource. When the status is <code>Completed</code> the resource is ready to build.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * The strategy used to merge existing bot or bot locale definitions with the imported definition.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy used to merge existing bot or bot locale definitions with the imported definition.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The strategy used to merge existing bot or bot locale definitions with the imported definition.
         * </p>
         * 
         * @param mergeStrategy
         *        The strategy used to merge existing bot or bot locale definitions with the imported definition.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The date and time that the import was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the import was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time that the import was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the import was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String importId;

        private String importedResourceId;

        private String importedResourceName;

        private String importStatus;

        private String mergeStrategy;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSummary model) {
            importId(model.importId);
            importedResourceId(model.importedResourceId);
            importedResourceName(model.importedResourceName);
            importStatus(model.importStatus);
            mergeStrategy(model.mergeStrategy);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getImportId() {
            return importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        public final String getImportedResourceId() {
            return importedResourceId;
        }

        @Override
        public final Builder importedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
            return this;
        }

        public final void setImportedResourceId(String importedResourceId) {
            this.importedResourceId = importedResourceId;
        }

        public final String getImportedResourceName() {
            return importedResourceName;
        }

        @Override
        public final Builder importedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
            return this;
        }

        public final void setImportedResourceName(String importedResourceName) {
            this.importedResourceName = importedResourceName;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        public final String getMergeStrategy() {
            return mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy == null ? null : mergeStrategy.toString());
            return this;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public ImportSummary build() {
            return new ImportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
