/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an intent returned by the <code>ListIntents</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentSummary implements SdkPojo, Serializable, ToCopyableBuilder<IntentSummary.Builder, IntentSummary> {
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(IntentSummary::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()).build();

    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(IntentSummary::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IntentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIntentSignature").getter(getter(IntentSummary::parentIntentSignature))
            .setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField
            .<List<InputContext>> builder(MarshallingType.LIST)
            .memberName("inputContexts")
            .getter(getter(IntentSummary::inputContexts))
            .setter(setter(Builder::inputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField
            .<List<OutputContext>> builder(MarshallingType.LIST)
            .memberName("outputContexts")
            .getter(getter(IntentSummary::outputContexts))
            .setter(setter(Builder::outputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(IntentSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_ID_FIELD,
            INTENT_NAME_FIELD, DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String intentId;

    private final String intentName;

    private final String description;

    private final String parentIntentSignature;

    private final List<InputContext> inputContexts;

    private final List<OutputContext> outputContexts;

    private final Instant lastUpdatedDateTime;

    private IntentSummary(BuilderImpl builder) {
        this.intentId = builder.intentId;
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier assigned to the intent. Use this ID to get detailed information about the intent with the
     * <code>DescribeIntent</code> operation.
     * </p>
     * 
     * @return The unique identifier assigned to the intent. Use this ID to get detailed information about the intent
     *         with the <code>DescribeIntent</code> operation.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * The name of the intent.
     * </p>
     * 
     * @return The name of the intent.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * The description of the intent.
     * </p>
     * 
     * @return The description of the intent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If this intent is derived from a built-in intent, the name of the parent intent.
     * </p>
     * 
     * @return If this intent is derived from a built-in intent, the name of the parent intent.
     */
    public final String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * Returns true if the InputContexts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInputContexts() {
        return inputContexts != null && !(inputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The input contexts that must be active for this intent to be considered for recognition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputContexts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The input contexts that must be active for this intent to be considered for recognition.
     */
    public final List<InputContext> inputContexts() {
        return inputContexts;
    }

    /**
     * Returns true if the OutputContexts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputContexts() {
        return outputContexts != null && !(outputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output contexts that are activated when this intent is fulfilled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputContexts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The output contexts that are activated when this intent is fulfilled.
     */
    public final List<OutputContext> outputContexts() {
        return outputContexts;
    }

    /**
     * <p>
     * The timestamp of the date and time that the intent was last updated.
     * </p>
     * 
     * @return The timestamp of the date and time that the intent was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputContexts() ? inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputContexts() ? outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentSummary)) {
            return false;
        }
        IntentSummary other = (IntentSummary) obj;
        return Objects.equals(intentId(), other.intentId()) && Objects.equals(intentName(), other.intentName())
                && Objects.equals(description(), other.description())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && hasInputContexts() == other.hasInputContexts() && Objects.equals(inputContexts(), other.inputContexts())
                && hasOutputContexts() == other.hasOutputContexts() && Objects.equals(outputContexts(), other.outputContexts())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentSummary").add("IntentId", intentId()).add("IntentName", intentName())
                .add("Description", description()).add("ParentIntentSignature", parentIntentSignature())
                .add("InputContexts", hasInputContexts() ? inputContexts() : null)
                .add("OutputContexts", hasOutputContexts() ? outputContexts() : null)
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "inputContexts":
            return Optional.ofNullable(clazz.cast(inputContexts()));
        case "outputContexts":
            return Optional.ofNullable(clazz.cast(outputContexts()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentSummary, T> g) {
        return obj -> g.apply((IntentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentSummary> {
        /**
         * <p>
         * The unique identifier assigned to the intent. Use this ID to get detailed information about the intent with
         * the <code>DescribeIntent</code> operation.
         * </p>
         * 
         * @param intentId
         *        The unique identifier assigned to the intent. Use this ID to get detailed information about the intent
         *        with the <code>DescribeIntent</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * The name of the intent.
         * </p>
         * 
         * @param intentName
         *        The name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * The description of the intent.
         * </p>
         * 
         * @param description
         *        The description of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If this intent is derived from a built-in intent, the name of the parent intent.
         * </p>
         * 
         * @param parentIntentSignature
         *        If this intent is derived from a built-in intent, the name of the parent intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * The input contexts that must be active for this intent to be considered for recognition.
         * </p>
         * 
         * @param inputContexts
         *        The input contexts that must be active for this intent to be considered for recognition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(Collection<InputContext> inputContexts);

        /**
         * <p>
         * The input contexts that must be active for this intent to be considered for recognition.
         * </p>
         * 
         * @param inputContexts
         *        The input contexts that must be active for this intent to be considered for recognition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(InputContext... inputContexts);

        /**
         * <p>
         * The input contexts that must be active for this intent to be considered for recognition.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InputContext>.Builder} avoiding the need to
         * create one manually via {@link List<InputContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputContext>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputContexts(List<InputContext>)}.
         * 
         * @param inputContexts
         *        a consumer that will call methods on {@link List<InputContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputContexts(List<InputContext>)
         */
        Builder inputContexts(Consumer<InputContext.Builder>... inputContexts);

        /**
         * <p>
         * The output contexts that are activated when this intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        The output contexts that are activated when this intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(Collection<OutputContext> outputContexts);

        /**
         * <p>
         * The output contexts that are activated when this intent is fulfilled.
         * </p>
         * 
         * @param outputContexts
         *        The output contexts that are activated when this intent is fulfilled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(OutputContext... outputContexts);

        /**
         * <p>
         * The output contexts that are activated when this intent is fulfilled.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OutputContext>.Builder} avoiding the need
         * to create one manually via {@link List<OutputContext>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputContext>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputContexts(List<OutputContext>)}.
         * 
         * @param outputContexts
         *        a consumer that will call methods on {@link List<OutputContext>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputContexts(List<OutputContext>)
         */
        Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts);

        /**
         * <p>
         * The timestamp of the date and time that the intent was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The timestamp of the date and time that the intent was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String intentId;

        private String intentName;

        private String description;

        private String parentIntentSignature;

        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();

        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentSummary model) {
            intentId(model.intentId);
            intentName(model.intentName);
            description(model.description);
            parentIntentSignature(model.parentIntentSignature);
            inputContexts(model.inputContexts);
            outputContexts(model.outputContexts);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getIntentId() {
            return intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        public final String getIntentName() {
            return intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext... inputContexts) {
            inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder>... inputContexts) {
            inputContexts(Stream.of(inputContexts).map(c -> InputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext... outputContexts) {
            outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts) {
            outputContexts(Stream.of(outputContexts).map(c -> OutputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public IntentSummary build() {
            return new IntentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
