/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotsResponse.Builder, ListBotsResponse> {
    private static final SdkField<List<BotSummary>> BOT_SUMMARIES_FIELD = SdkField
            .<List<BotSummary>> builder(MarshallingType.LIST)
            .memberName("botSummaries")
            .getter(getter(ListBotsResponse::botSummaries))
            .setter(setter(Builder::botSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BotSummary> botSummaries;

    private final String nextToken;

    private ListBotsResponse(BuilderImpl builder) {
        super(builder);
        this.botSummaries = builder.botSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BotSummaries property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBotSummaries() {
        return botSummaries != null && !(botSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the bots that meet the filter criteria specified in the request. The length of the list
     * is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the
     * <code>nextToken</code> field contains a token to the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBotSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information for the bots that meet the filter criteria specified in the request. The length of
     *         the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots
     *         available, the <code>nextToken</code> field contains a token to the next page of results.
     */
    public final List<BotSummary> botSummaries() {
        return botSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the <code>ListBots</code>
     * operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code>
     * parameter of a <code>ListBots</code> operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as
     *         the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBotSummaries() ? botSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotsResponse)) {
            return false;
        }
        ListBotsResponse other = (ListBotsResponse) obj;
        return hasBotSummaries() == other.hasBotSummaries() && Objects.equals(botSummaries(), other.botSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotsResponse").add("BotSummaries", hasBotSummaries() ? botSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botSummaries":
            return Optional.ofNullable(clazz.cast(botSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotsResponse, T> g) {
        return obj -> g.apply((ListBotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBotsResponse> {
        /**
         * <p>
         * Summary information for the bots that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available,
         * the <code>nextToken</code> field contains a token to the next page of results.
         * </p>
         * 
         * @param botSummaries
         *        Summary information for the bots that meet the filter criteria specified in the request. The length of
         *        the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots
         *        available, the <code>nextToken</code> field contains a token to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botSummaries(Collection<BotSummary> botSummaries);

        /**
         * <p>
         * Summary information for the bots that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available,
         * the <code>nextToken</code> field contains a token to the next page of results.
         * </p>
         * 
         * @param botSummaries
         *        Summary information for the bots that meet the filter criteria specified in the request. The length of
         *        the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots
         *        available, the <code>nextToken</code> field contains a token to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botSummaries(BotSummary... botSummaries);

        /**
         * <p>
         * Summary information for the bots that meet the filter criteria specified in the request. The length of the
         * list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available,
         * the <code>nextToken</code> field contains a token to the next page of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotSummary>.Builder} avoiding the need to
         * create one manually via {@link List<BotSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #botSummaries(List<BotSummary>)}.
         * 
         * @param botSummaries
         *        a consumer that will call methods on {@link List<BotSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botSummaries(List<BotSummary>)
         */
        Builder botSummaries(Consumer<BotSummary.Builder>... botSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the <code>ListBots</code>
         * operation. If the <code>nextToken</code> field is present, you send the contents as the
         * <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents
         *        as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next
         *        page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private List<BotSummary> botSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotsResponse model) {
            super(model);
            botSummaries(model.botSummaries);
            nextToken(model.nextToken);
        }

        public final List<BotSummary.Builder> getBotSummaries() {
            List<BotSummary.Builder> result = BotSummaryListCopier.copyToBuilder(this.botSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder botSummaries(Collection<BotSummary> botSummaries) {
            this.botSummaries = BotSummaryListCopier.copy(botSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botSummaries(BotSummary... botSummaries) {
            botSummaries(Arrays.asList(botSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botSummaries(Consumer<BotSummary.Builder>... botSummaries) {
            botSummaries(Stream.of(botSummaries).map(c -> BotSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBotSummaries(Collection<BotSummary.BuilderImpl> botSummaries) {
            this.botSummaries = BotSummaryListCopier.copyFromBuilder(botSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBotsResponse build() {
            return new ListBotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
