/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIntentsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListIntentsRequest.Builder, ListIntentsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListIntentsRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListIntentsRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListIntentsRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<IntentSortBy> SORT_BY_FIELD = SdkField.<IntentSortBy> builder(MarshallingType.SDK_POJO)
            .memberName("sortBy").getter(getter(ListIntentsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(IntentSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<List<IntentFilter>> FILTERS_FIELD = SdkField
            .<List<IntentFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListIntentsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntentFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntentFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListIntentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIntentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, SORT_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final IntentSortBy sortBy;

    private final List<IntentFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListIntentsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the bot that contains the intent.
     * </p>
     * 
     * @return The unique identifier of the bot that contains the intent.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the intent.
     * </p>
     * 
     * @return The version of the bot that contains the intent.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the intents to list. The string must match one of the supported
     * locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale of the intents to list. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by
     * the intent name or last updated date in either ascending or descending order.
     * </p>
     * 
     * @return Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to
     *         sort by the intent name or last updated date in either ascending or descending order.
     */
    public final IntentSortBy sortBy() {
        return sortBy;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the specification of a filter used to limit the intents in the response to only those that match the
     * filter specification. You can only specify one filter and only one string to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides the specification of a filter used to limit the intents in the response to only those that match
     *         the filter specification. You can only specify one filter and only one string to filter on.
     */
    public final List<IntentFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of intents to return in each page of results. If there are fewer results than the max page
     * size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of intents to return in each page of results. If there are fewer results than the max
     *         page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the <code>ListIntents</code> operation contains more results than specified in the
     * <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     * <code>nextToken</code> parameter to return the next page of results.
     * </p>
     * 
     * @return If the response from the <code>ListIntents</code> operation contains more results than specified in the
     *         <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     *         <code>nextToken</code> parameter to return the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentsRequest)) {
            return false;
        }
        ListIntentsRequest other = (ListIntentsRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(sortBy(), other.sortBy())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIntentsRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("SortBy", sortBy()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntentsRequest, T> g) {
        return obj -> g.apply((ListIntentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListIntentsRequest> {
        /**
         * <p>
         * The unique identifier of the bot that contains the intent.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that contains the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the intent.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the intents to list. The string must match one of the supported
         * locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the intents to list. The string must match one of the
         *        supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to
         * sort by the intent name or last updated date in either ascending or descending order.
         * </p>
         * 
         * @param sortBy
         *        Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose
         *        to sort by the intent name or last updated date in either ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(IntentSortBy sortBy);

        /**
         * <p>
         * Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to
         * sort by the intent name or last updated date in either ascending or descending order.
         * </p>
         * This is a convenience that creates an instance of the {@link IntentSortBy.Builder} avoiding the need to
         * create one manually via {@link IntentSortBy#builder()}.
         *
         * When the {@link Consumer} completes, {@link IntentSortBy.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(IntentSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link IntentSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(IntentSortBy)
         */
        default Builder sortBy(Consumer<IntentSortBy.Builder> sortBy) {
            return sortBy(IntentSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * Provides the specification of a filter used to limit the intents in the response to only those that match the
         * filter specification. You can only specify one filter and only one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the intents in the response to only those that
         *        match the filter specification. You can only specify one filter and only one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<IntentFilter> filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the intents in the response to only those that match the
         * filter specification. You can only specify one filter and only one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the intents in the response to only those that
         *        match the filter specification. You can only specify one filter and only one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(IntentFilter... filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the intents in the response to only those that match the
         * filter specification. You can only specify one filter and only one string to filter on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntentFilter>.Builder} avoiding the need to
         * create one manually via {@link List<IntentFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntentFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<IntentFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<IntentFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<IntentFilter>)
         */
        Builder filters(Consumer<IntentFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of intents to return in each page of results. If there are fewer results than the max page
         * size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of intents to return in each page of results. If there are fewer results than the
         *        max page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the <code>ListIntents</code> operation contains more results than specified in the
         * <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
         * <code>nextToken</code> parameter to return the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the response from the <code>ListIntents</code> operation contains more results than specified in
         *        the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
         *        <code>nextToken</code> parameter to return the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private IntentSortBy sortBy;

        private List<IntentFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentsRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            sortBy(model.sortBy);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final IntentSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        @Override
        public final Builder sortBy(IntentSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final void setSortBy(IntentSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        public final List<IntentFilter.Builder> getFilters() {
            List<IntentFilter.Builder> result = IntentFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<IntentFilter> filters) {
            this.filters = IntentFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IntentFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IntentFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> IntentFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<IntentFilter.BuilderImpl> filters) {
            this.filters = IntentFiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntentsRequest build() {
            return new ListIntentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
