/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the bot locale parameters required for importing a bot locale.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotLocaleImportSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<BotLocaleImportSpecification.Builder, BotLocaleImportSpecification> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(BotLocaleImportSpecification::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BotLocaleImportSpecification::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(BotLocaleImportSpecification::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("nluIntentConfidenceThreshold")
            .getter(getter(BotLocaleImportSpecification::nluIntentConfidenceThreshold))
            .setter(setter(Builder::nluIntentConfidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold")
                    .build()).build();

    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField
            .<VoiceSettings> builder(MarshallingType.SDK_POJO).memberName("voiceSettings")
            .getter(getter(BotLocaleImportSpecification::voiceSettings)).setter(setter(Builder::voiceSettings))
            .constructor(VoiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD, VOICE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final Double nluIntentConfidenceThreshold;

    private final VoiceSettings voiceSettings;

    private BotLocaleImportSpecification(BuilderImpl builder) {
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
    }

    /**
     * <p>
     * The identifier of the bot to import the locale to.
     * </p>
     * 
     * @return The identifier of the bot to import the locale to.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot to import the locale to. This can only be the <code>DRAFT</code> version of the bot.
     * </p>
     * 
     * @return The version of the bot to import the locale to. This can only be the <code>DRAFT</code> version of the
     *         bot.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale that the bot will be used in. The string must match one of the
     * supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more
     * information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
     * languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale that the bot will be used in. The string must match one of the
     *         supported locales. All of the intents, slot types, and slots used in the bot must have the same locale.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
     * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
     * <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
     * configured for the bot.
     * </p>
     * <p>
     * For example, suppose a bot is configured with the confidence threshold of 0.80 and the
     * <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence
     * scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>PostText</code> operation
     * would be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AMAZON.FallbackIntent</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IntentA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IntentB</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IntentC</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
     *         <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
     *         <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they
     *         are configured for the bot. </p>
     *         <p>
     *         For example, suppose a bot is configured with the confidence threshold of 0.80 and the
     *         <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following
     *         confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
     *         <code>PostText</code> operation would be:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AMAZON.FallbackIntent</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IntentA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IntentB</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IntentC</code>
     *         </p>
     *         </li>
     */
    public final Double nluIntentConfidenceThreshold() {
        return nluIntentConfidenceThreshold;
    }

    /**
     * Returns the value of the VoiceSettings property for this object.
     * 
     * @return The value of the VoiceSettings property for this object.
     */
    public final VoiceSettings voiceSettings() {
        return voiceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(voiceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotLocaleImportSpecification)) {
            return false;
        }
        BotLocaleImportSpecification other = (BotLocaleImportSpecification) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold())
                && Objects.equals(voiceSettings(), other.voiceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotLocaleImportSpecification").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("NluIntentConfidenceThreshold", nluIntentConfidenceThreshold())
                .add("VoiceSettings", voiceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "nluIntentConfidenceThreshold":
            return Optional.ofNullable(clazz.cast(nluIntentConfidenceThreshold()));
        case "voiceSettings":
            return Optional.ofNullable(clazz.cast(voiceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotLocaleImportSpecification, T> g) {
        return obj -> g.apply((BotLocaleImportSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotLocaleImportSpecification> {
        /**
         * <p>
         * The identifier of the bot to import the locale to.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot to import the locale to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot to import the locale to. This can only be the <code>DRAFT</code> version of the bot.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot to import the locale to. This can only be the <code>DRAFT</code> version of the
         *        bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale that the bot will be used in. The string must match one of the
         * supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For
         * more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
         * languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale that the bot will be used in. The string must match one of
         *        the supported locales. All of the intents, slot types, and slots used in the bot must have the same
         *        locale. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
         * <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
         * <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
         * configured for the bot.
         * </p>
         * <p>
         * For example, suppose a bot is configured with the confidence threshold of 0.80 and the
         * <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following
         * confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
         * <code>PostText</code> operation would be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AMAZON.FallbackIntent</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IntentA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IntentB</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IntentC</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param nluIntentConfidenceThreshold
         *        Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>,
         *        <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents.
         *        <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if
         *        they are configured for the bot. </p>
         *        <p>
         *        For example, suppose a bot is configured with the confidence threshold of 0.80 and the
         *        <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following
         *        confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
         *        <code>PostText</code> operation would be:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AMAZON.FallbackIntent</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IntentA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IntentB</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IntentC</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold);

        /**
         * Sets the value of the VoiceSettings property for this object.
         *
         * @param voiceSettings
         *        The new value for the VoiceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceSettings(VoiceSettings voiceSettings);

        /**
         * Sets the value of the VoiceSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link VoiceSettings.Builder} avoiding the need to
         * create one manually via {@link VoiceSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link VoiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceSettings(VoiceSettings)}.
         * 
         * @param voiceSettings
         *        a consumer that will call methods on {@link VoiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceSettings(VoiceSettings)
         */
        default Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return voiceSettings(VoiceSettings.builder().applyMutation(voiceSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private Double nluIntentConfidenceThreshold;

        private VoiceSettings voiceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(BotLocaleImportSpecification model) {
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            voiceSettings(model.voiceSettings);
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return voiceSettings != null ? voiceSettings.toBuilder() : null;
        }

        @Override
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        @Override
        public BotLocaleImportSpecification build() {
            return new BotLocaleImportSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
