/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSlotResponse extends LexModelsV2Response implements
        ToCopyableBuilder<UpdateSlotResponse.Builder, UpdateSlotResponse> {
    private static final SdkField<String> SLOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("slotId")
            .getter(getter(UpdateSlotResponse::slotId)).setter(setter(Builder::slotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotId").build()).build();

    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotName").getter(getter(UpdateSlotResponse::slotName)).setter(setter(Builder::slotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSlotResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(UpdateSlotResponse::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()).build();

    private static final SdkField<SlotValueElicitationSetting> VALUE_ELICITATION_SETTING_FIELD = SdkField
            .<SlotValueElicitationSetting> builder(MarshallingType.SDK_POJO).memberName("valueElicitationSetting")
            .getter(getter(UpdateSlotResponse::valueElicitationSetting)).setter(setter(Builder::valueElicitationSetting))
            .constructor(SlotValueElicitationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueElicitationSetting").build())
            .build();

    private static final SdkField<ObfuscationSetting> OBFUSCATION_SETTING_FIELD = SdkField
            .<ObfuscationSetting> builder(MarshallingType.SDK_POJO).memberName("obfuscationSetting")
            .getter(getter(UpdateSlotResponse::obfuscationSetting)).setter(setter(Builder::obfuscationSetting))
            .constructor(ObfuscationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obfuscationSetting").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateSlotResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(UpdateSlotResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(UpdateSlotResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> INTENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentId").getter(getter(UpdateSlotResponse::intentId)).setter(setter(Builder::intentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(UpdateSlotResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(UpdateSlotResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<MultipleValuesSetting> MULTIPLE_VALUES_SETTING_FIELD = SdkField
            .<MultipleValuesSetting> builder(MarshallingType.SDK_POJO).memberName("multipleValuesSetting")
            .getter(getter(UpdateSlotResponse::multipleValuesSetting)).setter(setter(Builder::multipleValuesSetting))
            .constructor(MultipleValuesSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multipleValuesSetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_ID_FIELD,
            SLOT_NAME_FIELD, DESCRIPTION_FIELD, SLOT_TYPE_ID_FIELD, VALUE_ELICITATION_SETTING_FIELD, OBFUSCATION_SETTING_FIELD,
            BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, INTENT_ID_FIELD, CREATION_DATE_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD, MULTIPLE_VALUES_SETTING_FIELD));

    private final String slotId;

    private final String slotName;

    private final String description;

    private final String slotTypeId;

    private final SlotValueElicitationSetting valueElicitationSetting;

    private final ObfuscationSetting obfuscationSetting;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String intentId;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final MultipleValuesSetting multipleValuesSetting;

    private UpdateSlotResponse(BuilderImpl builder) {
        super(builder);
        this.slotId = builder.slotId;
        this.slotName = builder.slotName;
        this.description = builder.description;
        this.slotTypeId = builder.slotTypeId;
        this.valueElicitationSetting = builder.valueElicitationSetting;
        this.obfuscationSetting = builder.obfuscationSetting;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.intentId = builder.intentId;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.multipleValuesSetting = builder.multipleValuesSetting;
    }

    /**
     * <p>
     * The unique identifier of the slot that was updated.
     * </p>
     * 
     * @return The unique identifier of the slot that was updated.
     */
    public final String slotId() {
        return slotId;
    }

    /**
     * <p>
     * The updated name of the slot.
     * </p>
     * 
     * @return The updated name of the slot.
     */
    public final String slotName() {
        return slotName;
    }

    /**
     * <p>
     * The updated description of the bot.
     * </p>
     * 
     * @return The updated description of the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated identifier of the slot type that provides values for the slot.
     * </p>
     * 
     * @return The updated identifier of the slot type that provides values for the slot.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.
     * </p>
     * 
     * @return The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the
     *         slot.
     */
    public final SlotValueElicitationSetting valueElicitationSetting() {
        return valueElicitationSetting;
    }

    /**
     * <p>
     * The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.
     * </p>
     * 
     * @return The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.
     */
    public final ObfuscationSetting obfuscationSetting() {
        return obfuscationSetting;
    }

    /**
     * <p>
     * The identifier of the bot that contains the slot.
     * </p>
     * 
     * @return The identifier of the bot that contains the slot.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.
     * </p>
     * 
     * @return The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The locale that contains the slot.
     * </p>
     * 
     * @return The locale that contains the slot.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The intent that contains the slot.
     * </p>
     * 
     * @return The intent that contains the slot.
     */
    public final String intentId() {
        return intentId;
    }

    /**
     * <p>
     * The timestamp of the date and time that the slot was created.
     * </p>
     * 
     * @return The timestamp of the date and time that the slot was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The timestamp of the date and time that the slot was last updated.
     * </p>
     * 
     * @return The timestamp of the date and time that the slot was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * Indicates whether the slot accepts multiple values in one response.
     * </p>
     * 
     * @return Indicates whether the slot accepts multiple values in one response.
     */
    public final MultipleValuesSetting multipleValuesSetting() {
        return multipleValuesSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slotId());
        hashCode = 31 * hashCode + Objects.hashCode(slotName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(valueElicitationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(obfuscationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(intentId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(multipleValuesSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSlotResponse)) {
            return false;
        }
        UpdateSlotResponse other = (UpdateSlotResponse) obj;
        return Objects.equals(slotId(), other.slotId()) && Objects.equals(slotName(), other.slotName())
                && Objects.equals(description(), other.description()) && Objects.equals(slotTypeId(), other.slotTypeId())
                && Objects.equals(valueElicitationSetting(), other.valueElicitationSetting())
                && Objects.equals(obfuscationSetting(), other.obfuscationSetting()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(intentId(), other.intentId()) && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(multipleValuesSetting(), other.multipleValuesSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSlotResponse").add("SlotId", slotId()).add("SlotName", slotName())
                .add("Description", description()).add("SlotTypeId", slotTypeId())
                .add("ValueElicitationSetting", valueElicitationSetting()).add("ObfuscationSetting", obfuscationSetting())
                .add("BotId", botId()).add("BotVersion", botVersion()).add("LocaleId", localeId()).add("IntentId", intentId())
                .add("CreationDateTime", creationDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("MultipleValuesSetting", multipleValuesSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotId":
            return Optional.ofNullable(clazz.cast(slotId()));
        case "slotName":
            return Optional.ofNullable(clazz.cast(slotName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "valueElicitationSetting":
            return Optional.ofNullable(clazz.cast(valueElicitationSetting()));
        case "obfuscationSetting":
            return Optional.ofNullable(clazz.cast(obfuscationSetting()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "intentId":
            return Optional.ofNullable(clazz.cast(intentId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "multipleValuesSetting":
            return Optional.ofNullable(clazz.cast(multipleValuesSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSlotResponse, T> g) {
        return obj -> g.apply((UpdateSlotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSlotResponse> {
        /**
         * <p>
         * The unique identifier of the slot that was updated.
         * </p>
         * 
         * @param slotId
         *        The unique identifier of the slot that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotId(String slotId);

        /**
         * <p>
         * The updated name of the slot.
         * </p>
         * 
         * @param slotName
         *        The updated name of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotName(String slotName);

        /**
         * <p>
         * The updated description of the bot.
         * </p>
         * 
         * @param description
         *        The updated description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated identifier of the slot type that provides values for the slot.
         * </p>
         * 
         * @param slotTypeId
         *        The updated identifier of the slot type that provides values for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the
         * slot.
         * </p>
         * 
         * @param valueElicitationSetting
         *        The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for
         *        the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueElicitationSetting(SlotValueElicitationSetting valueElicitationSetting);

        /**
         * <p>
         * The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the
         * slot.
         * </p>
         * This is a convenience that creates an instance of the {@link SlotValueElicitationSetting.Builder} avoiding
         * the need to create one manually via {@link SlotValueElicitationSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotValueElicitationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #valueElicitationSetting(SlotValueElicitationSetting)}.
         * 
         * @param valueElicitationSetting
         *        a consumer that will call methods on {@link SlotValueElicitationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueElicitationSetting(SlotValueElicitationSetting)
         */
        default Builder valueElicitationSetting(Consumer<SlotValueElicitationSetting.Builder> valueElicitationSetting) {
            return valueElicitationSetting(SlotValueElicitationSetting.builder().applyMutation(valueElicitationSetting).build());
        }

        /**
         * <p>
         * The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.
         * </p>
         * 
         * @param obfuscationSetting
         *        The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch
         *        logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder obfuscationSetting(ObfuscationSetting obfuscationSetting);

        /**
         * <p>
         * The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.
         * </p>
         * This is a convenience that creates an instance of the {@link ObfuscationSetting.Builder} avoiding the need to
         * create one manually via {@link ObfuscationSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObfuscationSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #obfuscationSetting(ObfuscationSetting)}.
         * 
         * @param obfuscationSetting
         *        a consumer that will call methods on {@link ObfuscationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #obfuscationSetting(ObfuscationSetting)
         */
        default Builder obfuscationSetting(Consumer<ObfuscationSetting.Builder> obfuscationSetting) {
            return obfuscationSetting(ObfuscationSetting.builder().applyMutation(obfuscationSetting).build());
        }

        /**
         * <p>
         * The identifier of the bot that contains the slot.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The locale that contains the slot.
         * </p>
         * 
         * @param localeId
         *        The locale that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The intent that contains the slot.
         * </p>
         * 
         * @param intentId
         *        The intent that contains the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentId(String intentId);

        /**
         * <p>
         * The timestamp of the date and time that the slot was created.
         * </p>
         * 
         * @param creationDateTime
         *        The timestamp of the date and time that the slot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The timestamp of the date and time that the slot was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The timestamp of the date and time that the slot was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * Indicates whether the slot accepts multiple values in one response.
         * </p>
         * 
         * @param multipleValuesSetting
         *        Indicates whether the slot accepts multiple values in one response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleValuesSetting(MultipleValuesSetting multipleValuesSetting);

        /**
         * <p>
         * Indicates whether the slot accepts multiple values in one response.
         * </p>
         * This is a convenience that creates an instance of the {@link MultipleValuesSetting.Builder} avoiding the need
         * to create one manually via {@link MultipleValuesSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultipleValuesSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #multipleValuesSetting(MultipleValuesSetting)}.
         * 
         * @param multipleValuesSetting
         *        a consumer that will call methods on {@link MultipleValuesSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multipleValuesSetting(MultipleValuesSetting)
         */
        default Builder multipleValuesSetting(Consumer<MultipleValuesSetting.Builder> multipleValuesSetting) {
            return multipleValuesSetting(MultipleValuesSetting.builder().applyMutation(multipleValuesSetting).build());
        }
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String slotId;

        private String slotName;

        private String description;

        private String slotTypeId;

        private SlotValueElicitationSetting valueElicitationSetting;

        private ObfuscationSetting obfuscationSetting;

        private String botId;

        private String botVersion;

        private String localeId;

        private String intentId;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private MultipleValuesSetting multipleValuesSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSlotResponse model) {
            super(model);
            slotId(model.slotId);
            slotName(model.slotName);
            description(model.description);
            slotTypeId(model.slotTypeId);
            valueElicitationSetting(model.valueElicitationSetting);
            obfuscationSetting(model.obfuscationSetting);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            intentId(model.intentId);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            multipleValuesSetting(model.multipleValuesSetting);
        }

        public final String getSlotId() {
            return slotId;
        }

        @Override
        public final Builder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public final void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        public final String getSlotName() {
            return slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        public final SlotValueElicitationSetting.Builder getValueElicitationSetting() {
            return valueElicitationSetting != null ? valueElicitationSetting.toBuilder() : null;
        }

        @Override
        public final Builder valueElicitationSetting(SlotValueElicitationSetting valueElicitationSetting) {
            this.valueElicitationSetting = valueElicitationSetting;
            return this;
        }

        public final void setValueElicitationSetting(SlotValueElicitationSetting.BuilderImpl valueElicitationSetting) {
            this.valueElicitationSetting = valueElicitationSetting != null ? valueElicitationSetting.build() : null;
        }

        public final ObfuscationSetting.Builder getObfuscationSetting() {
            return obfuscationSetting != null ? obfuscationSetting.toBuilder() : null;
        }

        @Override
        public final Builder obfuscationSetting(ObfuscationSetting obfuscationSetting) {
            this.obfuscationSetting = obfuscationSetting;
            return this;
        }

        public final void setObfuscationSetting(ObfuscationSetting.BuilderImpl obfuscationSetting) {
            this.obfuscationSetting = obfuscationSetting != null ? obfuscationSetting.build() : null;
        }

        public final String getBotId() {
            return botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final String getLocaleId() {
            return localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final String getIntentId() {
            return intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final MultipleValuesSetting.Builder getMultipleValuesSetting() {
            return multipleValuesSetting != null ? multipleValuesSetting.toBuilder() : null;
        }

        @Override
        public final Builder multipleValuesSetting(MultipleValuesSetting multipleValuesSetting) {
            this.multipleValuesSetting = multipleValuesSetting;
            return this;
        }

        public final void setMultipleValuesSetting(MultipleValuesSetting.BuilderImpl multipleValuesSetting) {
            this.multipleValuesSetting = multipleValuesSetting != null ? multipleValuesSetting.build() : null;
        }

        @Override
        public UpdateSlotResponse build() {
            return new UpdateSlotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
