/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon S3 bucket name and location for the grammar that is the source for the slot type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrammarSlotTypeSource implements SdkPojo, Serializable,
        ToCopyableBuilder<GrammarSlotTypeSource.Builder, GrammarSlotTypeSource> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketName").getter(getter(GrammarSlotTypeSource::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()).build();

    private static final SdkField<String> S3_OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3ObjectKey").getter(getter(GrammarSlotTypeSource::s3ObjectKey)).setter(setter(Builder::s3ObjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ObjectKey").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(GrammarSlotTypeSource::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            S3_OBJECT_KEY_FIELD, KMS_KEY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3BucketName;

    private final String s3ObjectKey;

    private final String kmsKeyArn;

    private GrammarSlotTypeSource(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3ObjectKey = builder.s3ObjectKey;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The name of the S3 bucket that contains the grammar source.
     * </p>
     * 
     * @return The name of the S3 bucket that contains the grammar source.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The path to the grammar in the S3 bucket.
     * </p>
     * 
     * @return The path to the grammar in the S3 bucket.
     */
    public final String s3ObjectKey() {
        return s3ObjectKey;
    }

    /**
     * <p>
     * The Amazon KMS key required to decrypt the contents of the grammar, if any.
     * </p>
     * 
     * @return The Amazon KMS key required to decrypt the contents of the grammar, if any.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrammarSlotTypeSource)) {
            return false;
        }
        GrammarSlotTypeSource other = (GrammarSlotTypeSource) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(s3ObjectKey(), other.s3ObjectKey())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrammarSlotTypeSource").add("S3BucketName", s3BucketName()).add("S3ObjectKey", s3ObjectKey())
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "s3ObjectKey":
            return Optional.ofNullable(clazz.cast(s3ObjectKey()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrammarSlotTypeSource, T> g) {
        return obj -> g.apply((GrammarSlotTypeSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrammarSlotTypeSource> {
        /**
         * <p>
         * The name of the S3 bucket that contains the grammar source.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket that contains the grammar source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The path to the grammar in the S3 bucket.
         * </p>
         * 
         * @param s3ObjectKey
         *        The path to the grammar in the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectKey(String s3ObjectKey);

        /**
         * <p>
         * The Amazon KMS key required to decrypt the contents of the grammar, if any.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon KMS key required to decrypt the contents of the grammar, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketName;

        private String s3ObjectKey;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GrammarSlotTypeSource model) {
            s3BucketName(model.s3BucketName);
            s3ObjectKey(model.s3ObjectKey);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3ObjectKey() {
            return s3ObjectKey;
        }

        public final void setS3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
        }

        @Override
        @Transient
        public final Builder s3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public GrammarSlotTypeSource build() {
            return new GrammarSlotTypeSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
