/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAggregatedUtterancesRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListAggregatedUtterancesRequest.Builder, ListAggregatedUtterancesRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListAggregatedUtterancesRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(ListAggregatedUtterancesRequest::botAliasId))
            .setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListAggregatedUtterancesRequest::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListAggregatedUtterancesRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<UtteranceAggregationDuration> AGGREGATION_DURATION_FIELD = SdkField
            .<UtteranceAggregationDuration> builder(MarshallingType.SDK_POJO).memberName("aggregationDuration")
            .getter(getter(ListAggregatedUtterancesRequest::aggregationDuration)).setter(setter(Builder::aggregationDuration))
            .constructor(UtteranceAggregationDuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDuration").build())
            .build();

    private static final SdkField<AggregatedUtterancesSortBy> SORT_BY_FIELD = SdkField
            .<AggregatedUtterancesSortBy> builder(MarshallingType.SDK_POJO).memberName("sortBy")
            .getter(getter(ListAggregatedUtterancesRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(AggregatedUtterancesSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<List<AggregatedUtterancesFilter>> FILTERS_FIELD = SdkField
            .<List<AggregatedUtterancesFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListAggregatedUtterancesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregatedUtterancesFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregatedUtterancesFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAggregatedUtterancesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAggregatedUtterancesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, AGGREGATION_DURATION_FIELD, SORT_BY_FIELD, FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String botAliasId;

    private final String botVersion;

    private final String localeId;

    private final UtteranceAggregationDuration aggregationDuration;

    private final AggregatedUtterancesSortBy sortBy;

    private final List<AggregatedUtterancesFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListAggregatedUtterancesRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.aggregationDuration = builder.aggregationDuration;
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the bot associated with this request.
     * </p>
     * 
     * @return The unique identifier of the bot associated with this request.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the
     * bot version.
     * </p>
     * 
     * @return The identifier of the bot alias associated with this request. If you specify the bot alias, you can't
     *         specify the bot version.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The identifier of the bot version associated with this request. If you specify the bot version, you can't specify
     * the bot alias.
     * </p>
     * 
     * @return The identifier of the bot version associated with this request. If you specify the bot version, you can't
     *         specify the bot alias.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale where the utterances were collected. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale where the utterances were collected. For more information, see
     *         <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.
     * </p>
     * 
     * @return The time window for aggregating the utterance information. You can specify a time between one hour and
     *         two weeks.
     */
    public final UtteranceAggregationDuration aggregationDuration() {
        return aggregationDuration;
    }

    /**
     * <p>
     * Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the
     * number of distinct sessions the utterance appeared in.
     * </p>
     * 
     * @return Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count,
     *         or the number of distinct sessions the utterance appeared in.
     */
    public final AggregatedUtterancesSortBy sortBy() {
        return sortBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the specification of a filter used to limit the utterances in the response to only those that match the
     * filter specification. You can only specify one filter and one string to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Provides the specification of a filter used to limit the utterances in the response to only those that
     *         match the filter specification. You can only specify one filter and one string to filter on.
     */
    public final List<AggregatedUtterancesFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of utterances to return in each page of results. If there are fewer results than the maximum
     * page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code>
     * parameter, 1,000 results are returned.
     * </p>
     * 
     * @return The maximum number of utterances to return in each page of results. If there are fewer results than the
     *         maximum page size, only the actual number of results are returned. If you don't specify the
     *         <code>maxResults</code> parameter, 1,000 results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in
     * the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
     * <code>nextToken</code> parameter to return the next page of results.
     * </p>
     * 
     * @return If the response from the <code>ListAggregatedUtterances</code> operation contains more results that
     *         specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token
     *         in the <code>nextToken</code> parameter to return the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregatedUtterancesRequest)) {
            return false;
        }
        ListAggregatedUtterancesRequest other = (ListAggregatedUtterancesRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(aggregationDuration(), other.aggregationDuration()) && Objects.equals(sortBy(), other.sortBy())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAggregatedUtterancesRequest").add("BotId", botId()).add("BotAliasId", botAliasId())
                .add("BotVersion", botVersion()).add("LocaleId", localeId()).add("AggregationDuration", aggregationDuration())
                .add("SortBy", sortBy()).add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "aggregationDuration":
            return Optional.ofNullable(clazz.cast(aggregationDuration()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAggregatedUtterancesRequest, T> g) {
        return obj -> g.apply((ListAggregatedUtterancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAggregatedUtterancesRequest> {
        /**
         * <p>
         * The unique identifier of the bot associated with this request.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot associated with this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify
         * the bot version.
         * </p>
         * 
         * @param botAliasId
         *        The identifier of the bot alias associated with this request. If you specify the bot alias, you can't
         *        specify the bot version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The identifier of the bot version associated with this request. If you specify the bot version, you can't
         * specify the bot alias.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the bot version associated with this request. If you specify the bot version, you
         *        can't specify the bot alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale where the utterances were collected. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale where the utterances were collected. For more information,
         *        see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The time window for aggregating the utterance information. You can specify a time between one hour and two
         * weeks.
         * </p>
         * 
         * @param aggregationDuration
         *        The time window for aggregating the utterance information. You can specify a time between one hour and
         *        two weeks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationDuration(UtteranceAggregationDuration aggregationDuration);

        /**
         * <p>
         * The time window for aggregating the utterance information. You can specify a time between one hour and two
         * weeks.
         * </p>
         * This is a convenience that creates an instance of the {@link UtteranceAggregationDuration.Builder} avoiding
         * the need to create one manually via {@link UtteranceAggregationDuration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UtteranceAggregationDuration.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregationDuration(UtteranceAggregationDuration)}.
         * 
         * @param aggregationDuration
         *        a consumer that will call methods on {@link UtteranceAggregationDuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationDuration(UtteranceAggregationDuration)
         */
        default Builder aggregationDuration(Consumer<UtteranceAggregationDuration.Builder> aggregationDuration) {
            return aggregationDuration(UtteranceAggregationDuration.builder().applyMutation(aggregationDuration).build());
        }

        /**
         * <p>
         * Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or
         * the number of distinct sessions the utterance appeared in.
         * </p>
         * 
         * @param sortBy
         *        Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed
         *        count, or the number of distinct sessions the utterance appeared in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(AggregatedUtterancesSortBy sortBy);

        /**
         * <p>
         * Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or
         * the number of distinct sessions the utterance appeared in.
         * </p>
         * This is a convenience that creates an instance of the {@link AggregatedUtterancesSortBy.Builder} avoiding the
         * need to create one manually via {@link AggregatedUtterancesSortBy#builder()}.
         *
         * When the {@link Consumer} completes, {@link AggregatedUtterancesSortBy.Builder#build()} is called immediately
         * and its result is passed to {@link #sortBy(AggregatedUtterancesSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link AggregatedUtterancesSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(AggregatedUtterancesSortBy)
         */
        default Builder sortBy(Consumer<AggregatedUtterancesSortBy.Builder> sortBy) {
            return sortBy(AggregatedUtterancesSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * Provides the specification of a filter used to limit the utterances in the response to only those that match
         * the filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the utterances in the response to only those that
         *        match the filter specification. You can only specify one filter and one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<AggregatedUtterancesFilter> filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the utterances in the response to only those that match
         * the filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the utterances in the response to only those that
         *        match the filter specification. You can only specify one filter and one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AggregatedUtterancesFilter... filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the utterances in the response to only those that match
         * the filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AggregatedUtterancesFilter>.Builder}
         * avoiding the need to create one manually via {@link List<AggregatedUtterancesFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregatedUtterancesFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<AggregatedUtterancesFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<AggregatedUtterancesFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<AggregatedUtterancesFilter>)
         */
        Builder filters(Consumer<AggregatedUtterancesFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of utterances to return in each page of results. If there are fewer results than the
         * maximum page size, only the actual number of results are returned. If you don't specify the
         * <code>maxResults</code> parameter, 1,000 results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of utterances to return in each page of results. If there are fewer results than
         *        the maximum page size, only the actual number of results are returned. If you don't specify the
         *        <code>maxResults</code> parameter, 1,000 results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified
         * in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the
         * <code>nextToken</code> parameter to return the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the response from the <code>ListAggregatedUtterances</code> operation contains more results that
         *        specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that
         *        token in the <code>nextToken</code> parameter to return the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String botVersion;

        private String localeId;

        private UtteranceAggregationDuration aggregationDuration;

        private AggregatedUtterancesSortBy sortBy;

        private List<AggregatedUtterancesFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregatedUtterancesRequest model) {
            super(model);
            botId(model.botId);
            botAliasId(model.botAliasId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            aggregationDuration(model.aggregationDuration);
            sortBy(model.sortBy);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        @Transient
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final UtteranceAggregationDuration.Builder getAggregationDuration() {
            return aggregationDuration != null ? aggregationDuration.toBuilder() : null;
        }

        public final void setAggregationDuration(UtteranceAggregationDuration.BuilderImpl aggregationDuration) {
            this.aggregationDuration = aggregationDuration != null ? aggregationDuration.build() : null;
        }

        @Override
        @Transient
        public final Builder aggregationDuration(UtteranceAggregationDuration aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            return this;
        }

        public final AggregatedUtterancesSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(AggregatedUtterancesSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        @Transient
        public final Builder sortBy(AggregatedUtterancesSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final List<AggregatedUtterancesFilter.Builder> getFilters() {
            List<AggregatedUtterancesFilter.Builder> result = AggregatedUtterancesFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AggregatedUtterancesFilter.BuilderImpl> filters) {
            this.filters = AggregatedUtterancesFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<AggregatedUtterancesFilter> filters) {
            this.filters = AggregatedUtterancesFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(AggregatedUtterancesFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<AggregatedUtterancesFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> AggregatedUtterancesFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAggregatedUtterancesRequest build() {
            return new ListAggregatedUtterancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
