/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAssociatedTranscriptsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<SearchAssociatedTranscriptsRequest.Builder, SearchAssociatedTranscriptsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(SearchAssociatedTranscriptsRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(SearchAssociatedTranscriptsRequest::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(SearchAssociatedTranscriptsRequest::localeId))
            .setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationId").getter(getter(SearchAssociatedTranscriptsRequest::botRecommendationId))
            .setter(setter(Builder::botRecommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botRecommendationId").build()).build();

    private static final SdkField<String> SEARCH_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchOrder").getter(getter(SearchAssociatedTranscriptsRequest::searchOrderAsString))
            .setter(setter(Builder::searchOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchOrder").build()).build();

    private static final SdkField<List<AssociatedTranscriptFilter>> FILTERS_FIELD = SdkField
            .<List<AssociatedTranscriptFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(SearchAssociatedTranscriptsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociatedTranscriptFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedTranscriptFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchAssociatedTranscriptsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<Integer> NEXT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nextIndex").getter(getter(SearchAssociatedTranscriptsRequest::nextIndex))
            .setter(setter(Builder::nextIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_ID_FIELD, SEARCH_ORDER_FIELD, FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_INDEX_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String botRecommendationId;

    private final String searchOrder;

    private final List<AssociatedTranscriptFilter> filters;

    private final Integer maxResults;

    private final Integer nextIndex;

    private SearchAssociatedTranscriptsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationId = builder.botRecommendationId;
        this.searchOrder = builder.searchOrder;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextIndex = builder.nextIndex;
    }

    /**
     * <p>
     * The unique identifier of the bot associated with the transcripts that you are searching.
     * </p>
     * 
     * @return The unique identifier of the bot associated with the transcripts that you are searching.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot containing the transcripts that you are searching.
     * </p>
     * 
     * @return The version of the bot containing the transcripts that you are searching.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the transcripts to search. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     * </p>
     * 
     * @return The identifier of the language and locale of the transcripts to search. The string must match one of the
     *         supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The unique identifier of the bot recommendation associated with the transcripts to search.
     * </p>
     * 
     * @return The unique identifier of the bot recommendation associated with the transcripts to search.
     */
    public final String botRecommendationId() {
        return botRecommendationId;
    }

    /**
     * <p>
     * How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #searchOrder} will
     * return {@link SearchOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #searchOrderAsString}.
     * </p>
     * 
     * @return How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
     * @see SearchOrder
     */
    public final SearchOrder searchOrder() {
        return SearchOrder.fromValue(searchOrder);
    }

    /**
     * <p>
     * How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #searchOrder} will
     * return {@link SearchOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #searchOrderAsString}.
     * </p>
     * 
     * @return How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
     * @see SearchOrder
     */
    public final String searchOrderAsString() {
        return searchOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of filter objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A list of filter objects.
     */
    public final List<AssociatedTranscriptFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of bot recommendations to return in each page of results. If there are fewer results than the
     * max page size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of bot recommendations to return in each page of results. If there are fewer results
     *         than the max page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the
     * maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return
     * the next page of results.
     * </p>
     * 
     * @return If the response from the SearchAssociatedTranscriptsRequest operation contains more results than
     *         specified in the maxResults parameter, an index is returned in the response. Use that index in the
     *         nextIndex parameter to return the next page of results.
     */
    public final Integer nextIndex() {
        return nextIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(searchOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAssociatedTranscriptsRequest)) {
            return false;
        }
        SearchAssociatedTranscriptsRequest other = (SearchAssociatedTranscriptsRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(botRecommendationId(), other.botRecommendationId())
                && Objects.equals(searchOrderAsString(), other.searchOrderAsString()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextIndex(), other.nextIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAssociatedTranscriptsRequest").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("BotRecommendationId", botRecommendationId())
                .add("SearchOrder", searchOrderAsString()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextIndex", nextIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "botRecommendationId":
            return Optional.ofNullable(clazz.cast(botRecommendationId()));
        case "searchOrder":
            return Optional.ofNullable(clazz.cast(searchOrderAsString()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextIndex":
            return Optional.ofNullable(clazz.cast(nextIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchAssociatedTranscriptsRequest, T> g) {
        return obj -> g.apply((SearchAssociatedTranscriptsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchAssociatedTranscriptsRequest> {
        /**
         * <p>
         * The unique identifier of the bot associated with the transcripts that you are searching.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot associated with the transcripts that you are searching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot containing the transcripts that you are searching.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot containing the transcripts that you are searching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the transcripts to search. The string must match one of the
         * supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the transcripts to search. The string must match one of
         *        the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The unique identifier of the bot recommendation associated with the transcripts to search.
         * </p>
         * 
         * @param botRecommendationId
         *        The unique identifier of the bot recommendation associated with the transcripts to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationId(String botRecommendationId);

        /**
         * <p>
         * How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
         * </p>
         * 
         * @param searchOrder
         *        How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
         * @see SearchOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchOrder
         */
        Builder searchOrder(String searchOrder);

        /**
         * <p>
         * How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
         * </p>
         * 
         * @param searchOrder
         *        How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.
         * @see SearchOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchOrder
         */
        Builder searchOrder(SearchOrder searchOrder);

        /**
         * <p>
         * A list of filter objects.
         * </p>
         * 
         * @param filters
         *        A list of filter objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<AssociatedTranscriptFilter> filters);

        /**
         * <p>
         * A list of filter objects.
         * </p>
         * 
         * @param filters
         *        A list of filter objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AssociatedTranscriptFilter... filters);

        /**
         * <p>
         * A list of filter objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssociatedTranscriptFilter>.Builder}
         * avoiding the need to create one manually via {@link List<AssociatedTranscriptFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssociatedTranscriptFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<AssociatedTranscriptFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<AssociatedTranscriptFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<AssociatedTranscriptFilter>)
         */
        Builder filters(Consumer<AssociatedTranscriptFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of bot recommendations to return in each page of results. If there are fewer results than
         * the max page size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of bot recommendations to return in each page of results. If there are fewer
         *        results than the max page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in
         * the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to
         * return the next page of results.
         * </p>
         * 
         * @param nextIndex
         *        If the response from the SearchAssociatedTranscriptsRequest operation contains more results than
         *        specified in the maxResults parameter, an index is returned in the response. Use that index in the
         *        nextIndex parameter to return the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextIndex(Integer nextIndex);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String botRecommendationId;

        private String searchOrder;

        private List<AssociatedTranscriptFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private Integer nextIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAssociatedTranscriptsRequest model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            botRecommendationId(model.botRecommendationId);
            searchOrder(model.searchOrder);
            filters(model.filters);
            maxResults(model.maxResults);
            nextIndex(model.nextIndex);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationId() {
            return botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        @Transient
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final String getSearchOrder() {
            return searchOrder;
        }

        public final void setSearchOrder(String searchOrder) {
            this.searchOrder = searchOrder;
        }

        @Override
        @Transient
        public final Builder searchOrder(String searchOrder) {
            this.searchOrder = searchOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder searchOrder(SearchOrder searchOrder) {
            this.searchOrder(searchOrder == null ? null : searchOrder.toString());
            return this;
        }

        public final List<AssociatedTranscriptFilter.Builder> getFilters() {
            List<AssociatedTranscriptFilter.Builder> result = AssociatedTranscriptFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AssociatedTranscriptFilter.BuilderImpl> filters) {
            this.filters = AssociatedTranscriptFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<AssociatedTranscriptFilter> filters) {
            this.filters = AssociatedTranscriptFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(AssociatedTranscriptFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<AssociatedTranscriptFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> AssociatedTranscriptFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Integer getNextIndex() {
            return nextIndex;
        }

        public final void setNextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
        }

        @Override
        @Transient
        public final Builder nextIndex(Integer nextIndex) {
            this.nextIndex = nextIndex;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAssociatedTranscriptsRequest build() {
            return new SearchAssociatedTranscriptsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
