/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExportsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListExportsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListExportsResponse.getter(ListExportsResponse::botId)).setter(ListExportsResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListExportsResponse.getter(ListExportsResponse::botVersion)).setter(ListExportsResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<List<ExportSummary>> EXPORT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exportSummaries").getter(ListExportsResponse.getter(ListExportsResponse::exportSummaries)).setter(ListExportsResponse.setter(Builder::exportSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExportsResponse.getter(ListExportsResponse::nextToken)).setter(ListExportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListExportsResponse.getter(ListExportsResponse::localeId)).setter(ListExportsResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, EXPORT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, LOCALE_ID_FIELD));
    private final String botId;
    private final String botVersion;
    private final List<ExportSummary> exportSummaries;
    private final String nextToken;
    private final String localeId;

    private ListExportsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.exportSummaries = builder.exportSummaries;
        this.nextToken = builder.nextToken;
        this.localeId = builder.localeId;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final boolean hasExportSummaries() {
        return this.exportSummaries != null && !(this.exportSummaries instanceof SdkAutoConstructList);
    }

    public final List<ExportSummary> exportSummaries() {
        return this.exportSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String localeId() {
        return this.localeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportSummaries() ? this.exportSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsResponse)) {
            return false;
        }
        ListExportsResponse other = (ListExportsResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && this.hasExportSummaries() == other.hasExportSummaries() && Objects.equals(this.exportSummaries(), other.exportSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.localeId(), other.localeId());
    }

    public final String toString() {
        return ToString.builder((String)"ListExportsResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("ExportSummaries", this.hasExportSummaries() ? this.exportSummaries() : null).add("NextToken", (Object)this.nextToken()).add("LocaleId", (Object)this.localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "exportSummaries": {
                return Optional.ofNullable(clazz.cast(this.exportSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExportsResponse, T> g) {
        return obj -> g.apply((ListExportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private List<ExportSummary> exportSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.exportSummaries(model.exportSummaries);
            this.nextToken(model.nextToken);
            this.localeId(model.localeId);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final List<ExportSummary.Builder> getExportSummaries() {
            List<ExportSummary.Builder> result = ExportSummaryListCopier.copyToBuilder(this.exportSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportSummaries(Collection<ExportSummary.BuilderImpl> exportSummaries) {
            this.exportSummaries = ExportSummaryListCopier.copyFromBuilder(exportSummaries);
        }

        @Override
        @Transient
        public final Builder exportSummaries(Collection<ExportSummary> exportSummaries) {
            this.exportSummaries = ExportSummaryListCopier.copy(exportSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exportSummaries(ExportSummary ... exportSummaries) {
            this.exportSummaries(Arrays.asList(exportSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exportSummaries(Consumer<ExportSummary.Builder> ... exportSummaries) {
            this.exportSummaries(Stream.of(exportSummaries).map(c -> (ExportSummary)((ExportSummary.Builder)ExportSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public ListExportsResponse build() {
            return new ListExportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExportsResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder exportSummaries(Collection<ExportSummary> var1);

        public Builder exportSummaries(ExportSummary ... var1);

        public Builder exportSummaries(Consumer<ExportSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder localeId(String var1);
    }
}

