/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a statement the Amazon Lex conveys to the user when the intent is successfully fulfilled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentClosingSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<IntentClosingSetting.Builder, IntentClosingSetting> {
    private static final SdkField<ResponseSpecification> CLOSING_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("closingResponse")
            .getter(getter(IntentClosingSetting::closingResponse)).setter(setter(Builder::closingResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closingResponse").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(IntentClosingSetting::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOSING_RESPONSE_FIELD,
            ACTIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResponseSpecification closingResponse;

    private final Boolean active;

    private IntentClosingSetting(BuilderImpl builder) {
        this.closingResponse = builder.closingResponse;
        this.active = builder.active;
    }

    /**
     * <p>
     * The response that Amazon Lex sends to the user when the intent is complete.
     * </p>
     * 
     * @return The response that Amazon Lex sends to the user when the intent is complete.
     */
    public final ResponseSpecification closingResponse() {
        return closingResponse;
    }

    /**
     * <p>
     * Specifies whether an intent's closing response is used. When this field is false, the closing response isn't sent
     * to the user. If the <code>active</code> field isn't specified, the default is true.
     * </p>
     * 
     * @return Specifies whether an intent's closing response is used. When this field is false, the closing response
     *         isn't sent to the user. If the <code>active</code> field isn't specified, the default is true.
     */
    public final Boolean active() {
        return active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(closingResponse());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentClosingSetting)) {
            return false;
        }
        IntentClosingSetting other = (IntentClosingSetting) obj;
        return Objects.equals(closingResponse(), other.closingResponse()) && Objects.equals(active(), other.active());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentClosingSetting").add("ClosingResponse", closingResponse()).add("Active", active()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "closingResponse":
            return Optional.ofNullable(clazz.cast(closingResponse()));
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentClosingSetting, T> g) {
        return obj -> g.apply((IntentClosingSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentClosingSetting> {
        /**
         * <p>
         * The response that Amazon Lex sends to the user when the intent is complete.
         * </p>
         * 
         * @param closingResponse
         *        The response that Amazon Lex sends to the user when the intent is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closingResponse(ResponseSpecification closingResponse);

        /**
         * <p>
         * The response that Amazon Lex sends to the user when the intent is complete.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #closingResponse(ResponseSpecification)}.
         * 
         * @param closingResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #closingResponse(ResponseSpecification)
         */
        default Builder closingResponse(Consumer<ResponseSpecification.Builder> closingResponse) {
            return closingResponse(ResponseSpecification.builder().applyMutation(closingResponse).build());
        }

        /**
         * <p>
         * Specifies whether an intent's closing response is used. When this field is false, the closing response isn't
         * sent to the user. If the <code>active</code> field isn't specified, the default is true.
         * </p>
         * 
         * @param active
         *        Specifies whether an intent's closing response is used. When this field is false, the closing response
         *        isn't sent to the user. If the <code>active</code> field isn't specified, the default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);
    }

    static final class BuilderImpl implements Builder {
        private ResponseSpecification closingResponse;

        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentClosingSetting model) {
            closingResponse(model.closingResponse);
            active(model.active);
        }

        public final ResponseSpecification.Builder getClosingResponse() {
            return closingResponse != null ? closingResponse.toBuilder() : null;
        }

        public final void setClosingResponse(ResponseSpecification.BuilderImpl closingResponse) {
            this.closingResponse = closingResponse != null ? closingResponse.build() : null;
        }

        @Override
        public final Builder closingResponse(ResponseSpecification closingResponse) {
            this.closingResponse = closingResponse;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        @Override
        public IntentClosingSetting build() {
            return new IntentClosingSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
