/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAggregatedUtterancesResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListAggregatedUtterancesResponse.Builder, ListAggregatedUtterancesResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListAggregatedUtterancesResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(ListAggregatedUtterancesResponse::botAliasId))
            .setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListAggregatedUtterancesResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListAggregatedUtterancesResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<UtteranceAggregationDuration> AGGREGATION_DURATION_FIELD = SdkField
            .<UtteranceAggregationDuration> builder(MarshallingType.SDK_POJO).memberName("aggregationDuration")
            .getter(getter(ListAggregatedUtterancesResponse::aggregationDuration)).setter(setter(Builder::aggregationDuration))
            .constructor(UtteranceAggregationDuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationDuration").build())
            .build();

    private static final SdkField<Instant> AGGREGATION_WINDOW_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("aggregationWindowStartTime")
            .getter(getter(ListAggregatedUtterancesResponse::aggregationWindowStartTime))
            .setter(setter(Builder::aggregationWindowStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationWindowStartTime").build())
            .build();

    private static final SdkField<Instant> AGGREGATION_WINDOW_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("aggregationWindowEndTime")
            .getter(getter(ListAggregatedUtterancesResponse::aggregationWindowEndTime))
            .setter(setter(Builder::aggregationWindowEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationWindowEndTime").build())
            .build();

    private static final SdkField<Instant> AGGREGATION_LAST_REFRESHED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("aggregationLastRefreshedDateTime")
            .getter(getter(ListAggregatedUtterancesResponse::aggregationLastRefreshedDateTime))
            .setter(setter(Builder::aggregationLastRefreshedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationLastRefreshedDateTime")
                    .build()).build();

    private static final SdkField<List<AggregatedUtterancesSummary>> AGGREGATED_UTTERANCES_SUMMARIES_FIELD = SdkField
            .<List<AggregatedUtterancesSummary>> builder(MarshallingType.LIST)
            .memberName("aggregatedUtterancesSummaries")
            .getter(getter(ListAggregatedUtterancesResponse::aggregatedUtterancesSummaries))
            .setter(setter(Builder::aggregatedUtterancesSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedUtterancesSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregatedUtterancesSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregatedUtterancesSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAggregatedUtterancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_ALIAS_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, AGGREGATION_DURATION_FIELD,
            AGGREGATION_WINDOW_START_TIME_FIELD, AGGREGATION_WINDOW_END_TIME_FIELD, AGGREGATION_LAST_REFRESHED_DATE_TIME_FIELD,
            AGGREGATED_UTTERANCES_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final String botId;

    private final String botAliasId;

    private final String botVersion;

    private final String localeId;

    private final UtteranceAggregationDuration aggregationDuration;

    private final Instant aggregationWindowStartTime;

    private final Instant aggregationWindowEndTime;

    private final Instant aggregationLastRefreshedDateTime;

    private final List<AggregatedUtterancesSummary> aggregatedUtterancesSummaries;

    private final String nextToken;

    private ListAggregatedUtterancesResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.aggregationDuration = builder.aggregationDuration;
        this.aggregationWindowStartTime = builder.aggregationWindowStartTime;
        this.aggregationWindowEndTime = builder.aggregationWindowEndTime;
        this.aggregationLastRefreshedDateTime = builder.aggregationLastRefreshedDateTime;
        this.aggregatedUtterancesSummaries = builder.aggregatedUtterancesSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the bot that contains the utterances.
     * </p>
     * 
     * @return The identifier of the bot that contains the utterances.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID
     * isn't returned.
     * </p>
     * 
     * @return The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot
     *         alias ID isn't returned.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version
     * isn't returned.
     * </p>
     * 
     * @return The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot
     *         version isn't returned.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale that the utterances are in.
     * </p>
     * 
     * @return The identifier of the language and locale that the utterances are in.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The time period used to aggregate the utterance data.
     * </p>
     * 
     * @return The time period used to aggregate the utterance data.
     */
    public final UtteranceAggregationDuration aggregationDuration() {
        return aggregationDuration;
    }

    /**
     * <p>
     * The date and time that the aggregation window begins. Only data collected after this time is returned in the
     * results.
     * </p>
     * 
     * @return The date and time that the aggregation window begins. Only data collected after this time is returned in
     *         the results.
     */
    public final Instant aggregationWindowStartTime() {
        return aggregationWindowStartTime;
    }

    /**
     * <p>
     * The date and time that the aggregation window ends. Only data collected between the start time and the end time
     * are returned in the results.
     * </p>
     * 
     * @return The date and time that the aggregation window ends. Only data collected between the start time and the
     *         end time are returned in the results.
     */
    public final Instant aggregationWindowEndTime() {
        return aggregationWindowEndTime;
    }

    /**
     * <p>
     * The last date and time that the aggregated data was collected. The time period depends on the length of the
     * aggregation window.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Days</b> - every 6 hours
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last date and time that the aggregated data was collected. The time period depends on the length of
     *         the aggregation window.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Days</b> - every 6 hours
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day
     *         </p>
     *         </li>
     */
    public final Instant aggregationLastRefreshedDateTime() {
        return aggregationLastRefreshedDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatedUtterancesSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAggregatedUtterancesSummaries() {
        return aggregatedUtterancesSummaries != null && !(aggregatedUtterancesSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the aggregated utterance data. Each response contains information about the number of times that the
     * utterance was seen during the time period, whether it was detected or missed, and when it was seen during the
     * time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatedUtterancesSummaries} method.
     * </p>
     * 
     * @return Summaries of the aggregated utterance data. Each response contains information about the number of times
     *         that the utterance was seen during the time period, whether it was detected or missed, and when it was
     *         seen during the time period.
     */
    public final List<AggregatedUtterancesSummary> aggregatedUtterancesSummaries() {
        return aggregatedUtterancesSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the
     * <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the
     * contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to
     * get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send
     *         the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation
     *         request to get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationWindowEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationLastRefreshedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregatedUtterancesSummaries() ? aggregatedUtterancesSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregatedUtterancesResponse)) {
            return false;
        }
        ListAggregatedUtterancesResponse other = (ListAggregatedUtterancesResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botAliasId(), other.botAliasId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(aggregationDuration(), other.aggregationDuration())
                && Objects.equals(aggregationWindowStartTime(), other.aggregationWindowStartTime())
                && Objects.equals(aggregationWindowEndTime(), other.aggregationWindowEndTime())
                && Objects.equals(aggregationLastRefreshedDateTime(), other.aggregationLastRefreshedDateTime())
                && hasAggregatedUtterancesSummaries() == other.hasAggregatedUtterancesSummaries()
                && Objects.equals(aggregatedUtterancesSummaries(), other.aggregatedUtterancesSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListAggregatedUtterancesResponse")
                .add("BotId", botId())
                .add("BotAliasId", botAliasId())
                .add("BotVersion", botVersion())
                .add("LocaleId", localeId())
                .add("AggregationDuration", aggregationDuration())
                .add("AggregationWindowStartTime", aggregationWindowStartTime())
                .add("AggregationWindowEndTime", aggregationWindowEndTime())
                .add("AggregationLastRefreshedDateTime", aggregationLastRefreshedDateTime())
                .add("AggregatedUtterancesSummaries", hasAggregatedUtterancesSummaries() ? aggregatedUtterancesSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "aggregationDuration":
            return Optional.ofNullable(clazz.cast(aggregationDuration()));
        case "aggregationWindowStartTime":
            return Optional.ofNullable(clazz.cast(aggregationWindowStartTime()));
        case "aggregationWindowEndTime":
            return Optional.ofNullable(clazz.cast(aggregationWindowEndTime()));
        case "aggregationLastRefreshedDateTime":
            return Optional.ofNullable(clazz.cast(aggregationLastRefreshedDateTime()));
        case "aggregatedUtterancesSummaries":
            return Optional.ofNullable(clazz.cast(aggregatedUtterancesSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAggregatedUtterancesResponse, T> g) {
        return obj -> g.apply((ListAggregatedUtterancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAggregatedUtterancesResponse> {
        /**
         * <p>
         * The identifier of the bot that contains the utterances.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot that contains the utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias
         * ID isn't returned.
         * </p>
         * 
         * @param botAliasId
         *        The identifier of the bot alias that contains the utterances. If you specified the bot version, the
         *        bot alias ID isn't returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot
         * version isn't returned.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the bot version that contains the utterances. If you specified the bot alias, the
         *        bot version isn't returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale that the utterances are in.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale that the utterances are in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The time period used to aggregate the utterance data.
         * </p>
         * 
         * @param aggregationDuration
         *        The time period used to aggregate the utterance data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationDuration(UtteranceAggregationDuration aggregationDuration);

        /**
         * <p>
         * The time period used to aggregate the utterance data.
         * </p>
         * This is a convenience method that creates an instance of the {@link UtteranceAggregationDuration.Builder}
         * avoiding the need to create one manually via {@link UtteranceAggregationDuration#builder()}.
         *
         * When the {@link Consumer} completes, {@link UtteranceAggregationDuration.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregationDuration(UtteranceAggregationDuration)}.
         * 
         * @param aggregationDuration
         *        a consumer that will call methods on {@link UtteranceAggregationDuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationDuration(UtteranceAggregationDuration)
         */
        default Builder aggregationDuration(Consumer<UtteranceAggregationDuration.Builder> aggregationDuration) {
            return aggregationDuration(UtteranceAggregationDuration.builder().applyMutation(aggregationDuration).build());
        }

        /**
         * <p>
         * The date and time that the aggregation window begins. Only data collected after this time is returned in the
         * results.
         * </p>
         * 
         * @param aggregationWindowStartTime
         *        The date and time that the aggregation window begins. Only data collected after this time is returned
         *        in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationWindowStartTime(Instant aggregationWindowStartTime);

        /**
         * <p>
         * The date and time that the aggregation window ends. Only data collected between the start time and the end
         * time are returned in the results.
         * </p>
         * 
         * @param aggregationWindowEndTime
         *        The date and time that the aggregation window ends. Only data collected between the start time and the
         *        end time are returned in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationWindowEndTime(Instant aggregationWindowEndTime);

        /**
         * <p>
         * The last date and time that the aggregated data was collected. The time period depends on the length of the
         * aggregation window.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Days</b> - every 6 hours
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregationLastRefreshedDateTime
         *        The last date and time that the aggregated data was collected. The time period depends on the length
         *        of the aggregation window.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Days</b> - every 6 hours
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationLastRefreshedDateTime(Instant aggregationLastRefreshedDateTime);

        /**
         * <p>
         * Summaries of the aggregated utterance data. Each response contains information about the number of times that
         * the utterance was seen during the time period, whether it was detected or missed, and when it was seen during
         * the time period.
         * </p>
         * 
         * @param aggregatedUtterancesSummaries
         *        Summaries of the aggregated utterance data. Each response contains information about the number of
         *        times that the utterance was seen during the time period, whether it was detected or missed, and when
         *        it was seen during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedUtterancesSummaries(Collection<AggregatedUtterancesSummary> aggregatedUtterancesSummaries);

        /**
         * <p>
         * Summaries of the aggregated utterance data. Each response contains information about the number of times that
         * the utterance was seen during the time period, whether it was detected or missed, and when it was seen during
         * the time period.
         * </p>
         * 
         * @param aggregatedUtterancesSummaries
         *        Summaries of the aggregated utterance data. Each response contains information about the number of
         *        times that the utterance was seen during the time period, whether it was detected or missed, and when
         *        it was seen during the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedUtterancesSummaries(AggregatedUtterancesSummary... aggregatedUtterancesSummaries);

        /**
         * <p>
         * Summaries of the aggregated utterance data. Each response contains information about the number of times that
         * the utterance was seen during the time period, whether it was detected or missed, and when it was seen during
         * the time period.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <AggregatedUtterancesSummary>.Builder} avoiding the need to create one manually via {@link List
         * <AggregatedUtterancesSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregatedUtterancesSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #aggregatedUtterancesSummaries(List<AggregatedUtterancesSummary>)}.
         * 
         * @param aggregatedUtterancesSummaries
         *        a consumer that will call methods on {@link List<AggregatedUtterancesSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedUtterancesSummaries(List<AggregatedUtterancesSummary>)
         */
        Builder aggregatedUtterancesSummaries(Consumer<AggregatedUtterancesSummary.Builder>... aggregatedUtterancesSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the
         * contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request
         * to get the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you
         *        send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code>
         *        operation request to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botAliasId;

        private String botVersion;

        private String localeId;

        private UtteranceAggregationDuration aggregationDuration;

        private Instant aggregationWindowStartTime;

        private Instant aggregationWindowEndTime;

        private Instant aggregationLastRefreshedDateTime;

        private List<AggregatedUtterancesSummary> aggregatedUtterancesSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregatedUtterancesResponse model) {
            super(model);
            botId(model.botId);
            botAliasId(model.botAliasId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            aggregationDuration(model.aggregationDuration);
            aggregationWindowStartTime(model.aggregationWindowStartTime);
            aggregationWindowEndTime(model.aggregationWindowEndTime);
            aggregationLastRefreshedDateTime(model.aggregationLastRefreshedDateTime);
            aggregatedUtterancesSummaries(model.aggregatedUtterancesSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final UtteranceAggregationDuration.Builder getAggregationDuration() {
            return aggregationDuration != null ? aggregationDuration.toBuilder() : null;
        }

        public final void setAggregationDuration(UtteranceAggregationDuration.BuilderImpl aggregationDuration) {
            this.aggregationDuration = aggregationDuration != null ? aggregationDuration.build() : null;
        }

        @Override
        public final Builder aggregationDuration(UtteranceAggregationDuration aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            return this;
        }

        public final Instant getAggregationWindowStartTime() {
            return aggregationWindowStartTime;
        }

        public final void setAggregationWindowStartTime(Instant aggregationWindowStartTime) {
            this.aggregationWindowStartTime = aggregationWindowStartTime;
        }

        @Override
        public final Builder aggregationWindowStartTime(Instant aggregationWindowStartTime) {
            this.aggregationWindowStartTime = aggregationWindowStartTime;
            return this;
        }

        public final Instant getAggregationWindowEndTime() {
            return aggregationWindowEndTime;
        }

        public final void setAggregationWindowEndTime(Instant aggregationWindowEndTime) {
            this.aggregationWindowEndTime = aggregationWindowEndTime;
        }

        @Override
        public final Builder aggregationWindowEndTime(Instant aggregationWindowEndTime) {
            this.aggregationWindowEndTime = aggregationWindowEndTime;
            return this;
        }

        public final Instant getAggregationLastRefreshedDateTime() {
            return aggregationLastRefreshedDateTime;
        }

        public final void setAggregationLastRefreshedDateTime(Instant aggregationLastRefreshedDateTime) {
            this.aggregationLastRefreshedDateTime = aggregationLastRefreshedDateTime;
        }

        @Override
        public final Builder aggregationLastRefreshedDateTime(Instant aggregationLastRefreshedDateTime) {
            this.aggregationLastRefreshedDateTime = aggregationLastRefreshedDateTime;
            return this;
        }

        public final List<AggregatedUtterancesSummary.Builder> getAggregatedUtterancesSummaries() {
            List<AggregatedUtterancesSummary.Builder> result = AggregatedUtterancesSummaryListCopier
                    .copyToBuilder(this.aggregatedUtterancesSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedUtterancesSummaries(
                Collection<AggregatedUtterancesSummary.BuilderImpl> aggregatedUtterancesSummaries) {
            this.aggregatedUtterancesSummaries = AggregatedUtterancesSummaryListCopier
                    .copyFromBuilder(aggregatedUtterancesSummaries);
        }

        @Override
        public final Builder aggregatedUtterancesSummaries(Collection<AggregatedUtterancesSummary> aggregatedUtterancesSummaries) {
            this.aggregatedUtterancesSummaries = AggregatedUtterancesSummaryListCopier.copy(aggregatedUtterancesSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedUtterancesSummaries(AggregatedUtterancesSummary... aggregatedUtterancesSummaries) {
            aggregatedUtterancesSummaries(Arrays.asList(aggregatedUtterancesSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedUtterancesSummaries(
                Consumer<AggregatedUtterancesSummary.Builder>... aggregatedUtterancesSummaries) {
            aggregatedUtterancesSummaries(Stream.of(aggregatedUtterancesSummaries)
                    .map(c -> AggregatedUtterancesSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAggregatedUtterancesResponse build() {
            return new ListAggregatedUtterancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
