/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;

public class ListBotLocalesPublisher
implements SdkPublisher<ListBotLocalesResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBotLocalesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotLocalesPublisher(LexModelsV2AsyncClient client, ListBotLocalesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotLocalesPublisher(LexModelsV2AsyncClient client, ListBotLocalesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotLocalesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotLocalesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBotLocalesResponseFetcher
    implements AsyncPageFetcher<ListBotLocalesResponse> {
        private ListBotLocalesResponseFetcher() {
        }

        public boolean hasNextPage(ListBotLocalesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotLocalesResponse> nextPage(ListBotLocalesResponse previousPage) {
            if (previousPage == null) {
                return ListBotLocalesPublisher.this.client.listBotLocales(ListBotLocalesPublisher.this.firstRequest);
            }
            return ListBotLocalesPublisher.this.client.listBotLocales((ListBotLocalesRequest)((Object)ListBotLocalesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

