/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUploadUrlResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateUploadUrlResponse.Builder, CreateUploadUrlResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importId").getter(getter(CreateUploadUrlResponse::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()).build();

    private static final SdkField<String> UPLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadUrl").getter(getter(CreateUploadUrlResponse::uploadUrl)).setter(setter(Builder::uploadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD,
            UPLOAD_URL_FIELD));

    private final String importId;

    private final String uploadUrl;

    private CreateUploadUrlResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.uploadUrl = builder.uploadUrl;
    }

    /**
     * <p>
     * An identifier for a unique import job. Use it when you call the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.
     * </p>
     * 
     * @return An identifier for a unique import job. Use it when you call the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.
     */
    public final String importId() {
        return importId;
    }

    /**
     * <p>
     * A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.
     * </p>
     * 
     * @return A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot
     *         locale.
     */
    public final String uploadUrl() {
        return uploadUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUploadUrlResponse)) {
            return false;
        }
        CreateUploadUrlResponse other = (CreateUploadUrlResponse) obj;
        return Objects.equals(importId(), other.importId()) && Objects.equals(uploadUrl(), other.uploadUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUploadUrlResponse").add("ImportId", importId()).add("UploadUrl", uploadUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "uploadUrl":
            return Optional.ofNullable(clazz.cast(uploadUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUploadUrlResponse, T> g) {
        return obj -> g.apply((CreateUploadUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateUploadUrlResponse> {
        /**
         * <p>
         * An identifier for a unique import job. Use it when you call the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.
         * </p>
         * 
         * @param importId
         *        An identifier for a unique import job. Use it when you call the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot
         * locale.
         * </p>
         * 
         * @param uploadUrl
         *        A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot
         *        locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadUrl(String uploadUrl);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String importId;

        private String uploadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUploadUrlResponse model) {
            super(model);
            importId(model.importId);
            uploadUrl(model.uploadUrl);
        }

        public final String getImportId() {
            return importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final String getUploadUrl() {
            return uploadUrl;
        }

        public final void setUploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        @Override
        public final Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        @Override
        public CreateUploadUrlResponse build() {
            return new CreateUploadUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
