/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBotRequest extends LexModelsV2Request implements
        ToCopyableBuilder<UpdateBotRequest.Builder, UpdateBotRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(UpdateBotRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(UpdateBotRequest::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateBotRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateBotRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<DataPrivacy> DATA_PRIVACY_FIELD = SdkField.<DataPrivacy> builder(MarshallingType.SDK_POJO)
            .memberName("dataPrivacy").getter(getter(UpdateBotRequest::dataPrivacy)).setter(setter(Builder::dataPrivacy))
            .constructor(DataPrivacy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPrivacy").build()).build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(UpdateBotRequest::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_NAME_FIELD,
            DESCRIPTION_FIELD, ROLE_ARN_FIELD, DATA_PRIVACY_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD));

    private final String botId;

    private final String botName;

    private final String description;

    private final String roleArn;

    private final DataPrivacy dataPrivacy;

    private final Integer idleSessionTTLInSeconds;

    private UpdateBotRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botName = builder.botName;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.dataPrivacy = builder.dataPrivacy;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * The unique identifier of the bot to update. This identifier is returned by the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.
     * </p>
     * 
     * @return The unique identifier of the bot to update. This identifier is returned by the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The new name of the bot. The name must be unique in the account that creates the bot.
     * </p>
     * 
     * @return The new name of the bot. The name must be unique in the account that creates the bot.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * A description of the bot.
     * </p>
     * 
     * @return A description of the bot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     * </p>
     * 
     * @return Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     */
    public final DataPrivacy dataPrivacy() {
        return dataPrivacy;
    }

    /**
     * <p>
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and Amazon Lex deletes any data provided before the timeout.
     * </p>
     * <p>
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     * </p>
     * 
     * @return The time, in seconds, that Amazon Lex should keep information about a user's conversation with the
     *         bot.</p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and Amazon Lex deletes any data provided before the timeout.
     *         </p>
     *         <p>
     *         You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBotRequest)) {
            return false;
        }
        UpdateBotRequest other = (UpdateBotRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botName(), other.botName())
                && Objects.equals(description(), other.description()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPrivacy(), other.dataPrivacy())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBotRequest").add("BotId", botId()).add("BotName", botName())
                .add("Description", description()).add("RoleArn", roleArn()).add("DataPrivacy", dataPrivacy())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "dataPrivacy":
            return Optional.ofNullable(clazz.cast(dataPrivacy()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBotRequest, T> g) {
        return obj -> g.apply((UpdateBotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBotRequest> {
        /**
         * <p>
         * The unique identifier of the bot to update. This identifier is returned by the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot to update. This identifier is returned by the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The new name of the bot. The name must be unique in the account that creates the bot.
         * </p>
         * 
         * @param botName
         *        The new name of the bot. The name must be unique in the account that creates the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * A description of the bot.
         * </p>
         * 
         * @param description
         *        A description of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * </p>
         * 
         * @param dataPrivacy
         *        Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPrivacy(DataPrivacy dataPrivacy);

        /**
         * <p>
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrivacy.Builder} avoiding the need to
         * create one manually via {@link DataPrivacy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataPrivacy.Builder#build()} is called immediately and its result
         * is passed to {@link #dataPrivacy(DataPrivacy)}.
         * 
         * @param dataPrivacy
         *        a consumer that will call methods on {@link DataPrivacy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPrivacy(DataPrivacy)
         */
        default Builder dataPrivacy(Consumer<DataPrivacy.Builder> dataPrivacy) {
            return dataPrivacy(DataPrivacy.builder().applyMutation(dataPrivacy).build());
        }

        /**
         * <p>
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and Amazon Lex deletes any data provided before the timeout.
         * </p>
         * <p>
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The time, in seconds, that Amazon Lex should keep information about a user's conversation with the
         *        bot.</p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *        </p>
         *        <p>
         *        You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String botName;

        private String description;

        private String roleArn;

        private DataPrivacy dataPrivacy;

        private Integer idleSessionTTLInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBotRequest model) {
            super(model);
            botId(model.botId);
            botName(model.botName);
            description(model.description);
            roleArn(model.roleArn);
            dataPrivacy(model.dataPrivacy);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPrivacy.Builder getDataPrivacy() {
            return dataPrivacy != null ? dataPrivacy.toBuilder() : null;
        }

        public final void setDataPrivacy(DataPrivacy.BuilderImpl dataPrivacy) {
            this.dataPrivacy = dataPrivacy != null ? dataPrivacy.build() : null;
        }

        @Override
        public final Builder dataPrivacy(DataPrivacy dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBotRequest build() {
            return new UpdateBotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
