/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBotRecommendationResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeBotRecommendationResponse.Builder, DescribeBotRecommendationResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeBotRecommendationResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeBotRecommendationResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DescribeBotRecommendationResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> BOT_RECOMMENDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationStatus")
            .getter(getter(DescribeBotRecommendationResponse::botRecommendationStatusAsString))
            .setter(setter(Builder::botRecommendationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationStatus").build())
            .build();

    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botRecommendationId").getter(getter(DescribeBotRecommendationResponse::botRecommendationId))
            .setter(setter(Builder::botRecommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationId").build())
            .build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeBotRecommendationResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeBotRecommendationResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeBotRecommendationResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<TranscriptSourceSetting> TRANSCRIPT_SOURCE_SETTING_FIELD = SdkField
            .<TranscriptSourceSetting> builder(MarshallingType.SDK_POJO).memberName("transcriptSourceSetting")
            .getter(getter(DescribeBotRecommendationResponse::transcriptSourceSetting))
            .setter(setter(Builder::transcriptSourceSetting)).constructor(TranscriptSourceSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transcriptSourceSetting").build())
            .build();

    private static final SdkField<EncryptionSetting> ENCRYPTION_SETTING_FIELD = SdkField
            .<EncryptionSetting> builder(MarshallingType.SDK_POJO).memberName("encryptionSetting")
            .getter(getter(DescribeBotRecommendationResponse::encryptionSetting)).setter(setter(Builder::encryptionSetting))
            .constructor(EncryptionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSetting").build()).build();

    private static final SdkField<BotRecommendationResults> BOT_RECOMMENDATION_RESULTS_FIELD = SdkField
            .<BotRecommendationResults> builder(MarshallingType.SDK_POJO).memberName("botRecommendationResults")
            .getter(getter(DescribeBotRecommendationResponse::botRecommendationResults))
            .setter(setter(Builder::botRecommendationResults)).constructor(BotRecommendationResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationResults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_STATUS_FIELD, BOT_RECOMMENDATION_ID_FIELD,
            FAILURE_REASONS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, TRANSCRIPT_SOURCE_SETTING_FIELD,
            ENCRYPTION_SETTING_FIELD, BOT_RECOMMENDATION_RESULTS_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String botRecommendationStatus;

    private final String botRecommendationId;

    private final List<String> failureReasons;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private final TranscriptSourceSetting transcriptSourceSetting;

    private final EncryptionSetting encryptionSetting;

    private final BotRecommendationResults botRecommendationResults;

    private DescribeBotRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationStatus = builder.botRecommendationStatus;
        this.botRecommendationId = builder.botRecommendationId;
        this.failureReasons = builder.failureReasons;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.transcriptSourceSetting = builder.transcriptSourceSetting;
        this.encryptionSetting = builder.encryptionSetting;
        this.botRecommendationResults = builder.botRecommendationResults;
    }

    /**
     * <p>
     * The identifier of the bot associated with the bot recommendation.
     * </p>
     * 
     * @return The identifier of the bot associated with the bot recommendation.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot associated with the bot recommendation.
     * </p>
     * 
     * @return The version of the bot associated with the bot recommendation.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the bot recommendation to describe.
     * </p>
     * 
     * @return The identifier of the language and locale of the bot recommendation to describe.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the
     * failureReasons field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botRecommendationStatus} will return {@link BotRecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botRecommendationStatusAsString}.
     * </p>
     * 
     * @return The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
     *         listed in the failureReasons field.
     * @see BotRecommendationStatus
     */
    public final BotRecommendationStatus botRecommendationStatus() {
        return BotRecommendationStatus.fromValue(botRecommendationStatus);
    }

    /**
     * <p>
     * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the
     * failureReasons field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #botRecommendationStatus} will return {@link BotRecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #botRecommendationStatusAsString}.
     * </p>
     * 
     * @return The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
     *         listed in the failureReasons field.
     * @see BotRecommendationStatus
     */
    public final String botRecommendationStatusAsString() {
        return botRecommendationStatus;
    }

    /**
     * <p>
     * The identifier of the bot recommendation being described.
     * </p>
     * 
     * @return The identifier of the bot recommendation being described.
     */
    public final String botRecommendationId() {
        return botRecommendationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If botRecommendationStatus is Failed, Amazon Lex explains why.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return If botRecommendationStatus is Failed, Amazon Lex explains why.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * The date and time that the bot recommendation was created.
     * </p>
     * 
     * @return The date and time that the bot recommendation was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time that the bot recommendation was last updated.
     * </p>
     * 
     * @return The date and time that the bot recommendation was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
     * </p>
     * 
     * @return The object representing the Amazon S3 bucket containing the transcript, as well as the associated
     *         metadata.
     */
    public final TranscriptSourceSetting transcriptSourceSetting() {
        return transcriptSourceSetting;
    }

    /**
     * <p>
     * The object representing the passwords that were used to encrypt the data related to the bot recommendation
     * results, as well as the KMS key ARN used to encrypt the associated metadata.
     * </p>
     * 
     * @return The object representing the passwords that were used to encrypt the data related to the bot
     *         recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.
     */
    public final EncryptionSetting encryptionSetting() {
        return encryptionSetting;
    }

    /**
     * <p>
     * The object representing the URL of the bot definition, the URL of the associated transcript and a statistical
     * summary of the bot recommendation results.
     * </p>
     * 
     * @return The object representing the URL of the bot definition, the URL of the associated transcript and a
     *         statistical summary of the bot recommendation results.
     */
    public final BotRecommendationResults botRecommendationResults() {
        return botRecommendationResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptSourceSetting());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSetting());
        hashCode = 31 * hashCode + Objects.hashCode(botRecommendationResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotRecommendationResponse)) {
            return false;
        }
        DescribeBotRecommendationResponse other = (DescribeBotRecommendationResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && Objects.equals(botRecommendationStatusAsString(), other.botRecommendationStatusAsString())
                && Objects.equals(botRecommendationId(), other.botRecommendationId())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(transcriptSourceSetting(), other.transcriptSourceSetting())
                && Objects.equals(encryptionSetting(), other.encryptionSetting())
                && Objects.equals(botRecommendationResults(), other.botRecommendationResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBotRecommendationResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("BotRecommendationStatus", botRecommendationStatusAsString())
                .add("BotRecommendationId", botRecommendationId())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("TranscriptSourceSetting", transcriptSourceSetting())
                .add("EncryptionSetting", encryptionSetting()).add("BotRecommendationResults", botRecommendationResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "botRecommendationStatus":
            return Optional.ofNullable(clazz.cast(botRecommendationStatusAsString()));
        case "botRecommendationId":
            return Optional.ofNullable(clazz.cast(botRecommendationId()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "transcriptSourceSetting":
            return Optional.ofNullable(clazz.cast(transcriptSourceSetting()));
        case "encryptionSetting":
            return Optional.ofNullable(clazz.cast(encryptionSetting()));
        case "botRecommendationResults":
            return Optional.ofNullable(clazz.cast(botRecommendationResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotRecommendationResponse, T> g) {
        return obj -> g.apply((DescribeBotRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBotRecommendationResponse> {
        /**
         * <p>
         * The identifier of the bot associated with the bot recommendation.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot associated with the bot recommendation.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with the bot recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the bot recommendation to describe.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the bot recommendation to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in
         * the failureReasons field.
         * </p>
         * 
         * @param botRecommendationStatus
         *        The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
         *        listed in the failureReasons field.
         * @see BotRecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotRecommendationStatus
         */
        Builder botRecommendationStatus(String botRecommendationStatus);

        /**
         * <p>
         * The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in
         * the failureReasons field.
         * </p>
         * 
         * @param botRecommendationStatus
         *        The status of the bot recommendation. If the status is Failed, then the reasons for the failure are
         *        listed in the failureReasons field.
         * @see BotRecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotRecommendationStatus
         */
        Builder botRecommendationStatus(BotRecommendationStatus botRecommendationStatus);

        /**
         * <p>
         * The identifier of the bot recommendation being described.
         * </p>
         * 
         * @param botRecommendationId
         *        The identifier of the bot recommendation being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationId(String botRecommendationId);

        /**
         * <p>
         * If botRecommendationStatus is Failed, Amazon Lex explains why.
         * </p>
         * 
         * @param failureReasons
         *        If botRecommendationStatus is Failed, Amazon Lex explains why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * If botRecommendationStatus is Failed, Amazon Lex explains why.
         * </p>
         * 
         * @param failureReasons
         *        If botRecommendationStatus is Failed, Amazon Lex explains why.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * The date and time that the bot recommendation was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the bot recommendation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time that the bot recommendation was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the bot recommendation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
         * </p>
         * 
         * @param transcriptSourceSetting
         *        The object representing the Amazon S3 bucket containing the transcript, as well as the associated
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptSourceSetting(TranscriptSourceSetting transcriptSourceSetting);

        /**
         * <p>
         * The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranscriptSourceSetting.Builder} avoiding
         * the need to create one manually via {@link TranscriptSourceSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link TranscriptSourceSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #transcriptSourceSetting(TranscriptSourceSetting)}.
         * 
         * @param transcriptSourceSetting
         *        a consumer that will call methods on {@link TranscriptSourceSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptSourceSetting(TranscriptSourceSetting)
         */
        default Builder transcriptSourceSetting(Consumer<TranscriptSourceSetting.Builder> transcriptSourceSetting) {
            return transcriptSourceSetting(TranscriptSourceSetting.builder().applyMutation(transcriptSourceSetting).build());
        }

        /**
         * <p>
         * The object representing the passwords that were used to encrypt the data related to the bot recommendation
         * results, as well as the KMS key ARN used to encrypt the associated metadata.
         * </p>
         * 
         * @param encryptionSetting
         *        The object representing the passwords that were used to encrypt the data related to the bot
         *        recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSetting(EncryptionSetting encryptionSetting);

        /**
         * <p>
         * The object representing the passwords that were used to encrypt the data related to the bot recommendation
         * results, as well as the KMS key ARN used to encrypt the associated metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionSetting.Builder} avoiding the
         * need to create one manually via {@link EncryptionSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionSetting(EncryptionSetting)}.
         * 
         * @param encryptionSetting
         *        a consumer that will call methods on {@link EncryptionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSetting(EncryptionSetting)
         */
        default Builder encryptionSetting(Consumer<EncryptionSetting.Builder> encryptionSetting) {
            return encryptionSetting(EncryptionSetting.builder().applyMutation(encryptionSetting).build());
        }

        /**
         * <p>
         * The object representing the URL of the bot definition, the URL of the associated transcript and a statistical
         * summary of the bot recommendation results.
         * </p>
         * 
         * @param botRecommendationResults
         *        The object representing the URL of the bot definition, the URL of the associated transcript and a
         *        statistical summary of the bot recommendation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationResults(BotRecommendationResults botRecommendationResults);

        /**
         * <p>
         * The object representing the URL of the bot definition, the URL of the associated transcript and a statistical
         * summary of the bot recommendation results.
         * </p>
         * This is a convenience method that creates an instance of the {@link BotRecommendationResults.Builder}
         * avoiding the need to create one manually via {@link BotRecommendationResults#builder()}.
         *
         * When the {@link Consumer} completes, {@link BotRecommendationResults.Builder#build()} is called immediately
         * and its result is passed to {@link #botRecommendationResults(BotRecommendationResults)}.
         * 
         * @param botRecommendationResults
         *        a consumer that will call methods on {@link BotRecommendationResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botRecommendationResults(BotRecommendationResults)
         */
        default Builder botRecommendationResults(Consumer<BotRecommendationResults.Builder> botRecommendationResults) {
            return botRecommendationResults(BotRecommendationResults.builder().applyMutation(botRecommendationResults).build());
        }
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String botRecommendationStatus;

        private String botRecommendationId;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private TranscriptSourceSetting transcriptSourceSetting;

        private EncryptionSetting encryptionSetting;

        private BotRecommendationResults botRecommendationResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotRecommendationResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            botRecommendationStatus(model.botRecommendationStatus);
            botRecommendationId(model.botRecommendationId);
            failureReasons(model.failureReasons);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            transcriptSourceSetting(model.transcriptSourceSetting);
            encryptionSetting(model.encryptionSetting);
            botRecommendationResults(model.botRecommendationResults);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationStatus() {
            return botRecommendationStatus;
        }

        public final void setBotRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
        }

        @Override
        public final Builder botRecommendationStatus(String botRecommendationStatus) {
            this.botRecommendationStatus = botRecommendationStatus;
            return this;
        }

        @Override
        public final Builder botRecommendationStatus(BotRecommendationStatus botRecommendationStatus) {
            this.botRecommendationStatus(botRecommendationStatus == null ? null : botRecommendationStatus.toString());
            return this;
        }

        public final String getBotRecommendationId() {
            return botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final TranscriptSourceSetting.Builder getTranscriptSourceSetting() {
            return transcriptSourceSetting != null ? transcriptSourceSetting.toBuilder() : null;
        }

        public final void setTranscriptSourceSetting(TranscriptSourceSetting.BuilderImpl transcriptSourceSetting) {
            this.transcriptSourceSetting = transcriptSourceSetting != null ? transcriptSourceSetting.build() : null;
        }

        @Override
        public final Builder transcriptSourceSetting(TranscriptSourceSetting transcriptSourceSetting) {
            this.transcriptSourceSetting = transcriptSourceSetting;
            return this;
        }

        public final EncryptionSetting.Builder getEncryptionSetting() {
            return encryptionSetting != null ? encryptionSetting.toBuilder() : null;
        }

        public final void setEncryptionSetting(EncryptionSetting.BuilderImpl encryptionSetting) {
            this.encryptionSetting = encryptionSetting != null ? encryptionSetting.build() : null;
        }

        @Override
        public final Builder encryptionSetting(EncryptionSetting encryptionSetting) {
            this.encryptionSetting = encryptionSetting;
            return this;
        }

        public final BotRecommendationResults.Builder getBotRecommendationResults() {
            return botRecommendationResults != null ? botRecommendationResults.toBuilder() : null;
        }

        public final void setBotRecommendationResults(BotRecommendationResults.BuilderImpl botRecommendationResults) {
            this.botRecommendationResults = botRecommendationResults != null ? botRecommendationResults.build() : null;
        }

        @Override
        public final Builder botRecommendationResults(BotRecommendationResults botRecommendationResults) {
            this.botRecommendationResults = botRecommendationResults;
            return this;
        }

        @Override
        public DescribeBotRecommendationResponse build() {
            return new DescribeBotRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
