/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the bot or bot locale that you want to export. You can specify the
 * <code>botExportSpecification</code> or the <code>botLocaleExportSpecification</code>, but not both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportResourceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportResourceSpecification.Builder, ExportResourceSpecification> {
    private static final SdkField<BotExportSpecification> BOT_EXPORT_SPECIFICATION_FIELD = SdkField
            .<BotExportSpecification> builder(MarshallingType.SDK_POJO).memberName("botExportSpecification")
            .getter(getter(ExportResourceSpecification::botExportSpecification)).setter(setter(Builder::botExportSpecification))
            .constructor(BotExportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botExportSpecification").build())
            .build();

    private static final SdkField<BotLocaleExportSpecification> BOT_LOCALE_EXPORT_SPECIFICATION_FIELD = SdkField
            .<BotLocaleExportSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("botLocaleExportSpecification")
            .getter(getter(ExportResourceSpecification::botLocaleExportSpecification))
            .setter(setter(Builder::botLocaleExportSpecification))
            .constructor(BotLocaleExportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleExportSpecification")
                    .build()).build();

    private static final SdkField<CustomVocabularyExportSpecification> CUSTOM_VOCABULARY_EXPORT_SPECIFICATION_FIELD = SdkField
            .<CustomVocabularyExportSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("customVocabularyExportSpecification")
            .getter(getter(ExportResourceSpecification::customVocabularyExportSpecification))
            .setter(setter(Builder::customVocabularyExportSpecification))
            .constructor(CustomVocabularyExportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("customVocabularyExportSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BOT_EXPORT_SPECIFICATION_FIELD, BOT_LOCALE_EXPORT_SPECIFICATION_FIELD, CUSTOM_VOCABULARY_EXPORT_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final BotExportSpecification botExportSpecification;

    private final BotLocaleExportSpecification botLocaleExportSpecification;

    private final CustomVocabularyExportSpecification customVocabularyExportSpecification;

    private ExportResourceSpecification(BuilderImpl builder) {
        this.botExportSpecification = builder.botExportSpecification;
        this.botLocaleExportSpecification = builder.botLocaleExportSpecification;
        this.customVocabularyExportSpecification = builder.customVocabularyExportSpecification;
    }

    /**
     * <p>
     * Parameters for exporting a bot.
     * </p>
     * 
     * @return Parameters for exporting a bot.
     */
    public final BotExportSpecification botExportSpecification() {
        return botExportSpecification;
    }

    /**
     * <p>
     * Parameters for exporting a bot locale.
     * </p>
     * 
     * @return Parameters for exporting a bot locale.
     */
    public final BotLocaleExportSpecification botLocaleExportSpecification() {
        return botLocaleExportSpecification;
    }

    /**
     * <p>
     * The parameters required to export a custom vocabulary.
     * </p>
     * 
     * @return The parameters required to export a custom vocabulary.
     */
    public final CustomVocabularyExportSpecification customVocabularyExportSpecification() {
        return customVocabularyExportSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botExportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleExportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customVocabularyExportSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportResourceSpecification)) {
            return false;
        }
        ExportResourceSpecification other = (ExportResourceSpecification) obj;
        return Objects.equals(botExportSpecification(), other.botExportSpecification())
                && Objects.equals(botLocaleExportSpecification(), other.botLocaleExportSpecification())
                && Objects.equals(customVocabularyExportSpecification(), other.customVocabularyExportSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportResourceSpecification").add("BotExportSpecification", botExportSpecification())
                .add("BotLocaleExportSpecification", botLocaleExportSpecification())
                .add("CustomVocabularyExportSpecification", customVocabularyExportSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botExportSpecification":
            return Optional.ofNullable(clazz.cast(botExportSpecification()));
        case "botLocaleExportSpecification":
            return Optional.ofNullable(clazz.cast(botLocaleExportSpecification()));
        case "customVocabularyExportSpecification":
            return Optional.ofNullable(clazz.cast(customVocabularyExportSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportResourceSpecification, T> g) {
        return obj -> g.apply((ExportResourceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportResourceSpecification> {
        /**
         * <p>
         * Parameters for exporting a bot.
         * </p>
         * 
         * @param botExportSpecification
         *        Parameters for exporting a bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botExportSpecification(BotExportSpecification botExportSpecification);

        /**
         * <p>
         * Parameters for exporting a bot.
         * </p>
         * This is a convenience method that creates an instance of the {@link BotExportSpecification.Builder} avoiding
         * the need to create one manually via {@link BotExportSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link BotExportSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #botExportSpecification(BotExportSpecification)}.
         * 
         * @param botExportSpecification
         *        a consumer that will call methods on {@link BotExportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botExportSpecification(BotExportSpecification)
         */
        default Builder botExportSpecification(Consumer<BotExportSpecification.Builder> botExportSpecification) {
            return botExportSpecification(BotExportSpecification.builder().applyMutation(botExportSpecification).build());
        }

        /**
         * <p>
         * Parameters for exporting a bot locale.
         * </p>
         * 
         * @param botLocaleExportSpecification
         *        Parameters for exporting a bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleExportSpecification(BotLocaleExportSpecification botLocaleExportSpecification);

        /**
         * <p>
         * Parameters for exporting a bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link BotLocaleExportSpecification.Builder}
         * avoiding the need to create one manually via {@link BotLocaleExportSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link BotLocaleExportSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #botLocaleExportSpecification(BotLocaleExportSpecification)}.
         * 
         * @param botLocaleExportSpecification
         *        a consumer that will call methods on {@link BotLocaleExportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botLocaleExportSpecification(BotLocaleExportSpecification)
         */
        default Builder botLocaleExportSpecification(Consumer<BotLocaleExportSpecification.Builder> botLocaleExportSpecification) {
            return botLocaleExportSpecification(BotLocaleExportSpecification.builder()
                    .applyMutation(botLocaleExportSpecification).build());
        }

        /**
         * <p>
         * The parameters required to export a custom vocabulary.
         * </p>
         * 
         * @param customVocabularyExportSpecification
         *        The parameters required to export a custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVocabularyExportSpecification(CustomVocabularyExportSpecification customVocabularyExportSpecification);

        /**
         * <p>
         * The parameters required to export a custom vocabulary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomVocabularyExportSpecification.Builder} avoiding the need to create one manually via
         * {@link CustomVocabularyExportSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomVocabularyExportSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customVocabularyExportSpecification(CustomVocabularyExportSpecification)}.
         * 
         * @param customVocabularyExportSpecification
         *        a consumer that will call methods on {@link CustomVocabularyExportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customVocabularyExportSpecification(CustomVocabularyExportSpecification)
         */
        default Builder customVocabularyExportSpecification(
                Consumer<CustomVocabularyExportSpecification.Builder> customVocabularyExportSpecification) {
            return customVocabularyExportSpecification(CustomVocabularyExportSpecification.builder()
                    .applyMutation(customVocabularyExportSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BotExportSpecification botExportSpecification;

        private BotLocaleExportSpecification botLocaleExportSpecification;

        private CustomVocabularyExportSpecification customVocabularyExportSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportResourceSpecification model) {
            botExportSpecification(model.botExportSpecification);
            botLocaleExportSpecification(model.botLocaleExportSpecification);
            customVocabularyExportSpecification(model.customVocabularyExportSpecification);
        }

        public final BotExportSpecification.Builder getBotExportSpecification() {
            return botExportSpecification != null ? botExportSpecification.toBuilder() : null;
        }

        public final void setBotExportSpecification(BotExportSpecification.BuilderImpl botExportSpecification) {
            this.botExportSpecification = botExportSpecification != null ? botExportSpecification.build() : null;
        }

        @Override
        public final Builder botExportSpecification(BotExportSpecification botExportSpecification) {
            this.botExportSpecification = botExportSpecification;
            return this;
        }

        public final BotLocaleExportSpecification.Builder getBotLocaleExportSpecification() {
            return botLocaleExportSpecification != null ? botLocaleExportSpecification.toBuilder() : null;
        }

        public final void setBotLocaleExportSpecification(BotLocaleExportSpecification.BuilderImpl botLocaleExportSpecification) {
            this.botLocaleExportSpecification = botLocaleExportSpecification != null ? botLocaleExportSpecification.build()
                    : null;
        }

        @Override
        public final Builder botLocaleExportSpecification(BotLocaleExportSpecification botLocaleExportSpecification) {
            this.botLocaleExportSpecification = botLocaleExportSpecification;
            return this;
        }

        public final CustomVocabularyExportSpecification.Builder getCustomVocabularyExportSpecification() {
            return customVocabularyExportSpecification != null ? customVocabularyExportSpecification.toBuilder() : null;
        }

        public final void setCustomVocabularyExportSpecification(
                CustomVocabularyExportSpecification.BuilderImpl customVocabularyExportSpecification) {
            this.customVocabularyExportSpecification = customVocabularyExportSpecification != null ? customVocabularyExportSpecification
                    .build() : null;
        }

        @Override
        public final Builder customVocabularyExportSpecification(
                CustomVocabularyExportSpecification customVocabularyExportSpecification) {
            this.customVocabularyExportSpecification = customVocabularyExportSpecification;
            return this;
        }

        @Override
        public ExportResourceSpecification build() {
            return new ExportResourceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
