/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a prompt for making sure that the user is ready for the intent to be fulfilled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentConfirmationSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<IntentConfirmationSetting.Builder, IntentConfirmationSetting> {
    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField
            .<PromptSpecification> builder(MarshallingType.SDK_POJO).memberName("promptSpecification")
            .getter(getter(IntentConfirmationSetting::promptSpecification)).setter(setter(Builder::promptSpecification))
            .constructor(PromptSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build())
            .build();

    private static final SdkField<ResponseSpecification> DECLINATION_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("declinationResponse")
            .getter(getter(IntentConfirmationSetting::declinationResponse)).setter(setter(Builder::declinationResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("declinationResponse").build())
            .build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(IntentConfirmationSetting::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_SPECIFICATION_FIELD,
            DECLINATION_RESPONSE_FIELD, ACTIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PromptSpecification promptSpecification;

    private final ResponseSpecification declinationResponse;

    private final Boolean active;

    private IntentConfirmationSetting(BuilderImpl builder) {
        this.promptSpecification = builder.promptSpecification;
        this.declinationResponse = builder.declinationResponse;
        this.active = builder.active;
    }

    /**
     * <p>
     * Prompts the user to confirm the intent. This question should have a yes or no answer.
     * </p>
     * <p>
     * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For
     * example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before
     * placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask
     * the user for confirmation before providing the information.
     * </p>
     * 
     * @return Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
     *         <p>
     *         Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
     *         fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
     *         order is correct before placing it. For other intents, such as intents that simply respond to user
     *         questions, you might not need to ask the user for confirmation before providing the information.
     */
    public final PromptSpecification promptSpecification() {
        return promptSpecification;
    }

    /**
     * <p>
     * When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds with
     * this response to acknowledge that the intent was canceled.
     * </p>
     * 
     * @return When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex
     *         responds with this response to acknowledge that the intent was canceled.
     */
    public final ResponseSpecification declinationResponse() {
        return declinationResponse;
    }

    /**
     * <p>
     * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and
     * declination responses aren't sent. If the <code>active</code> field isn't specified, the default is true.
     * </p>
     * 
     * @return Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation
     *         and declination responses aren't sent. If the <code>active</code> field isn't specified, the default is
     *         true.
     */
    public final Boolean active() {
        return active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(declinationResponse());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentConfirmationSetting)) {
            return false;
        }
        IntentConfirmationSetting other = (IntentConfirmationSetting) obj;
        return Objects.equals(promptSpecification(), other.promptSpecification())
                && Objects.equals(declinationResponse(), other.declinationResponse()) && Objects.equals(active(), other.active());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentConfirmationSetting").add("PromptSpecification", promptSpecification())
                .add("DeclinationResponse", declinationResponse()).add("Active", active()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptSpecification":
            return Optional.ofNullable(clazz.cast(promptSpecification()));
        case "declinationResponse":
            return Optional.ofNullable(clazz.cast(declinationResponse()));
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentConfirmationSetting, T> g) {
        return obj -> g.apply((IntentConfirmationSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentConfirmationSetting> {
        /**
         * <p>
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * </p>
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment.
         * For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct
         * before placing it. For other intents, such as intents that simply respond to user questions, you might not
         * need to ask the user for confirmation before providing the information.
         * </p>
         * 
         * @param promptSpecification
         *        Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
         *        <p>
         *        Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for
         *        fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the
         *        order is correct before placing it. For other intents, such as intents that simply respond to user
         *        questions, you might not need to ask the user for confirmation before providing the information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSpecification(PromptSpecification promptSpecification);

        /**
         * <p>
         * Prompts the user to confirm the intent. This question should have a yes or no answer.
         * </p>
         * <p>
         * Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment.
         * For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct
         * before placing it. For other intents, such as intents that simply respond to user questions, you might not
         * need to ask the user for confirmation before providing the information.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptSpecification.Builder} avoiding the
         * need to create one manually via {@link PromptSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PromptSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #promptSpecification(PromptSpecification)}.
         * 
         * @param promptSpecification
         *        a consumer that will call methods on {@link PromptSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptSpecification(PromptSpecification)
         */
        default Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return promptSpecification(PromptSpecification.builder().applyMutation(promptSpecification).build());
        }

        /**
         * <p>
         * When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds
         * with this response to acknowledge that the intent was canceled.
         * </p>
         * 
         * @param declinationResponse
         *        When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex
         *        responds with this response to acknowledge that the intent was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder declinationResponse(ResponseSpecification declinationResponse);

        /**
         * <p>
         * When the user answers "no" to the question defined in <code>promptSpecification</code>, Amazon Lex responds
         * with this response to acknowledge that the intent was canceled.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #declinationResponse(ResponseSpecification)}.
         * 
         * @param declinationResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #declinationResponse(ResponseSpecification)
         */
        default Builder declinationResponse(Consumer<ResponseSpecification.Builder> declinationResponse) {
            return declinationResponse(ResponseSpecification.builder().applyMutation(declinationResponse).build());
        }

        /**
         * <p>
         * Specifies whether the intent's confirmation is sent to the user. When this field is false, confirmation and
         * declination responses aren't sent. If the <code>active</code> field isn't specified, the default is true.
         * </p>
         * 
         * @param active
         *        Specifies whether the intent's confirmation is sent to the user. When this field is false,
         *        confirmation and declination responses aren't sent. If the <code>active</code> field isn't specified,
         *        the default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);
    }

    static final class BuilderImpl implements Builder {
        private PromptSpecification promptSpecification;

        private ResponseSpecification declinationResponse;

        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentConfirmationSetting model) {
            promptSpecification(model.promptSpecification);
            declinationResponse(model.declinationResponse);
            active(model.active);
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return promptSpecification != null ? promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final ResponseSpecification.Builder getDeclinationResponse() {
            return declinationResponse != null ? declinationResponse.toBuilder() : null;
        }

        public final void setDeclinationResponse(ResponseSpecification.BuilderImpl declinationResponse) {
            this.declinationResponse = declinationResponse != null ? declinationResponse.build() : null;
        }

        @Override
        public final Builder declinationResponse(ResponseSpecification declinationResponse) {
            this.declinationResponse = declinationResponse;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        @Override
        public IntentConfirmationSetting build() {
            return new IntentConfirmationSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
