/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BotStatus {
    CREATING("Creating"),
    AVAILABLE("Available"),
    INACTIVE("Inactive"),
    DELETING("Deleting"),
    FAILED("Failed"),
    VERSIONING("Versioning"),
    IMPORTING("Importing"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BotStatus> VALUE_MAP;
    private final String value;

    private BotStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BotStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BotStatus> knownValues() {
        EnumSet<BotStatus> knownValues = EnumSet.allOf(BotStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BotStatus.class, BotStatus::toString);
    }
}

