/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBotAliasRequest extends LexModelsV2Request implements
        ToCopyableBuilder<DeleteBotAliasRequest.Builder, DeleteBotAliasRequest> {
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasId").getter(getter(DeleteBotAliasRequest::botAliasId)).setter(setter(Builder::botAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()).build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DeleteBotAliasRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<Boolean> SKIP_RESOURCE_IN_USE_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipResourceInUseCheck")
            .getter(getter(DeleteBotAliasRequest::skipResourceInUseCheck))
            .setter(setter(Builder::skipResourceInUseCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipResourceInUseCheck").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ID_FIELD,
            BOT_ID_FIELD, SKIP_RESOURCE_IN_USE_CHECK_FIELD));

    private final String botAliasId;

    private final String botId;

    private final Boolean skipResourceInUseCheck;

    private DeleteBotAliasRequest(BuilderImpl builder) {
        super(builder);
        this.botAliasId = builder.botAliasId;
        this.botId = builder.botId;
        this.skipResourceInUseCheck = builder.skipResourceInUseCheck;
    }

    /**
     * <p>
     * The unique identifier of the bot alias to delete.
     * </p>
     * 
     * @return The unique identifier of the bot alias to delete.
     */
    public final String botAliasId() {
        return botAliasId;
    }

    /**
     * <p>
     * The unique identifier of the bot associated with the alias to delete.
     * </p>
     * 
     * @return The unique identifier of the bot associated with the alias to delete.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it
     * is deleted.
     * </p>
     * 
     * @return When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias
     *         before it is deleted.
     */
    public final Boolean skipResourceInUseCheck() {
        return skipResourceInUseCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(skipResourceInUseCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotAliasRequest)) {
            return false;
        }
        DeleteBotAliasRequest other = (DeleteBotAliasRequest) obj;
        return Objects.equals(botAliasId(), other.botAliasId()) && Objects.equals(botId(), other.botId())
                && Objects.equals(skipResourceInUseCheck(), other.skipResourceInUseCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBotAliasRequest").add("BotAliasId", botAliasId()).add("BotId", botId())
                .add("SkipResourceInUseCheck", skipResourceInUseCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasId":
            return Optional.ofNullable(clazz.cast(botAliasId()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "skipResourceInUseCheck":
            return Optional.ofNullable(clazz.cast(skipResourceInUseCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotAliasRequest, T> g) {
        return obj -> g.apply((DeleteBotAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBotAliasRequest> {
        /**
         * <p>
         * The unique identifier of the bot alias to delete.
         * </p>
         * 
         * @param botAliasId
         *        The unique identifier of the bot alias to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasId(String botAliasId);

        /**
         * <p>
         * The unique identifier of the bot associated with the alias to delete.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot associated with the alias to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before
         * it is deleted.
         * </p>
         * 
         * @param skipResourceInUseCheck
         *        When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias
         *        before it is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botAliasId;

        private String botId;

        private Boolean skipResourceInUseCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotAliasRequest model) {
            super(model);
            botAliasId(model.botAliasId);
            botId(model.botId);
            skipResourceInUseCheck(model.skipResourceInUseCheck);
        }

        public final String getBotAliasId() {
            return botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Boolean getSkipResourceInUseCheck() {
            return skipResourceInUseCheck;
        }

        public final void setSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
        }

        @Override
        public final Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBotAliasRequest build() {
            return new DeleteBotAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
