/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExportResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateExportResponse.Builder, CreateExportResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportId").getter(getter(CreateExportResponse::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()).build();

    private static final SdkField<ExportResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ExportResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("resourceSpecification")
            .getter(getter(CreateExportResponse::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ExportResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(CreateExportResponse::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportStatus").getter(getter(CreateExportResponse::exportStatusAsString))
            .setter(setter(Builder::exportStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateExportResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD,
            RESOURCE_SPECIFICATION_FIELD, FILE_FORMAT_FIELD, EXPORT_STATUS_FIELD, CREATION_DATE_TIME_FIELD));

    private final String exportId;

    private final ExportResourceSpecification resourceSpecification;

    private final String fileFormat;

    private final String exportStatus;

    private final Instant creationDateTime;

    private CreateExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.resourceSpecification = builder.resourceSpecification;
        this.fileFormat = builder.fileFormat;
        this.exportStatus = builder.exportStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * An identifier for a specific request to create an export.
     * </p>
     * 
     * @return An identifier for a specific request to create an export.
     */
    public final String exportId() {
        return exportId;
    }

    /**
     * <p>
     * A description of the type of resource that was exported, either a bot or a bot locale.
     * </p>
     * 
     * @return A description of the type of resource that was exported, either a bot or a bot locale.
     */
    public final ExportResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * <p>
     * The file format used for the bot or bot locale definition files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ImportExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format used for the bot or bot locale definition files.
     * @see ImportExportFileFormat
     */
    public final ImportExportFileFormat fileFormat() {
        return ImportExportFileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The file format used for the bot or bot locale definition files.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ImportExportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The file format used for the bot or bot locale definition files.
     * @see ImportExportFileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * The status of the export. When the status is <code>Completed</code>, you can use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get
     * the pre-signed S3 URL link to your exported bot or bot locale.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the export. When the status is <code>Completed</code>, you can use the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation
     *         to get the pre-signed S3 URL link to your exported bot or bot locale.
     * @see ExportStatus
     */
    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(exportStatus);
    }

    /**
     * <p>
     * The status of the export. When the status is <code>Completed</code>, you can use the <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get
     * the pre-signed S3 URL link to your exported bot or bot locale.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportStatus} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportStatusAsString}.
     * </p>
     * 
     * @return The status of the export. When the status is <code>Completed</code>, you can use the <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation
     *         to get the pre-signed S3 URL link to your exported bot or bot locale.
     * @see ExportStatus
     */
    public final String exportStatusAsString() {
        return exportStatus;
    }

    /**
     * <p>
     * The date and time that the request to export a bot was created.
     * </p>
     * 
     * @return The date and time that the request to export a bot was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportResponse)) {
            return false;
        }
        CreateExportResponse other = (CreateExportResponse) obj;
        return Objects.equals(exportId(), other.exportId())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(exportStatusAsString(), other.exportStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExportResponse").add("ExportId", exportId())
                .add("ResourceSpecification", resourceSpecification()).add("FileFormat", fileFormatAsString())
                .add("ExportStatus", exportStatusAsString()).add("CreationDateTime", creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "resourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "exportStatus":
            return Optional.ofNullable(clazz.cast(exportStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExportResponse, T> g) {
        return obj -> g.apply((CreateExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateExportResponse> {
        /**
         * <p>
         * An identifier for a specific request to create an export.
         * </p>
         * 
         * @param exportId
         *        An identifier for a specific request to create an export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * A description of the type of resource that was exported, either a bot or a bot locale.
         * </p>
         * 
         * @param resourceSpecification
         *        A description of the type of resource that was exported, either a bot or a bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ExportResourceSpecification resourceSpecification);

        /**
         * <p>
         * A description of the type of resource that was exported, either a bot or a bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportResourceSpecification.Builder}
         * avoiding the need to create one manually via {@link ExportResourceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceSpecification(ExportResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ExportResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ExportResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ExportResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ExportResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * <p>
         * The file format used for the bot or bot locale definition files.
         * </p>
         * 
         * @param fileFormat
         *        The file format used for the bot or bot locale definition files.
         * @see ImportExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportExportFileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The file format used for the bot or bot locale definition files.
         * </p>
         * 
         * @param fileFormat
         *        The file format used for the bot or bot locale definition files.
         * @see ImportExportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportExportFileFormat
         */
        Builder fileFormat(ImportExportFileFormat fileFormat);

        /**
         * <p>
         * The status of the export. When the status is <code>Completed</code>, you can use the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to
         * get the pre-signed S3 URL link to your exported bot or bot locale.
         * </p>
         * 
         * @param exportStatus
         *        The status of the export. When the status is <code>Completed</code>, you can use the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a>
         *        operation to get the pre-signed S3 URL link to your exported bot or bot locale.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(String exportStatus);

        /**
         * <p>
         * The status of the export. When the status is <code>Completed</code>, you can use the <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to
         * get the pre-signed S3 URL link to your exported bot or bot locale.
         * </p>
         * 
         * @param exportStatus
         *        The status of the export. When the status is <code>Completed</code>, you can use the <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a>
         *        operation to get the pre-signed S3 URL link to your exported bot or bot locale.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder exportStatus(ExportStatus exportStatus);

        /**
         * <p>
         * The date and time that the request to export a bot was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the request to export a bot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String exportId;

        private ExportResourceSpecification resourceSpecification;

        private String fileFormat;

        private String exportStatus;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportResponse model) {
            super(model);
            exportId(model.exportId);
            resourceSpecification(model.resourceSpecification);
            fileFormat(model.fileFormat);
            exportStatus(model.exportStatus);
            creationDateTime(model.creationDateTime);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final ExportResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ExportResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ExportResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ImportExportFileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getExportStatus() {
            return exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public CreateExportResponse build() {
            return new CreateExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
