/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings used when Amazon Lex successfully captures a slot value from a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotCaptureSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotCaptureSetting.Builder, SlotCaptureSetting> {
    private static final SdkField<ResponseSpecification> CAPTURE_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("captureResponse")
            .getter(getter(SlotCaptureSetting::captureResponse)).setter(setter(Builder::captureResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureResponse").build()).build();

    private static final SdkField<DialogState> CAPTURE_NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("captureNextStep").getter(getter(SlotCaptureSetting::captureNextStep))
            .setter(setter(Builder::captureNextStep)).constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureNextStep").build()).build();

    private static final SdkField<ConditionalSpecification> CAPTURE_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("captureConditional")
            .getter(getter(SlotCaptureSetting::captureConditional)).setter(setter(Builder::captureConditional))
            .constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureConditional").build())
            .build();

    private static final SdkField<ResponseSpecification> FAILURE_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("failureResponse")
            .getter(getter(SlotCaptureSetting::failureResponse)).setter(setter(Builder::failureResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureResponse").build()).build();

    private static final SdkField<DialogState> FAILURE_NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("failureNextStep").getter(getter(SlotCaptureSetting::failureNextStep))
            .setter(setter(Builder::failureNextStep)).constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureNextStep").build()).build();

    private static final SdkField<ConditionalSpecification> FAILURE_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("failureConditional")
            .getter(getter(SlotCaptureSetting::failureConditional)).setter(setter(Builder::failureConditional))
            .constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureConditional").build())
            .build();

    private static final SdkField<DialogCodeHookInvocationSetting> CODE_HOOK_FIELD = SdkField
            .<DialogCodeHookInvocationSetting> builder(MarshallingType.SDK_POJO).memberName("codeHook")
            .getter(getter(SlotCaptureSetting::codeHook)).setter(setter(Builder::codeHook))
            .constructor(DialogCodeHookInvocationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHook").build()).build();

    private static final SdkField<ElicitationCodeHookInvocationSetting> ELICITATION_CODE_HOOK_FIELD = SdkField
            .<ElicitationCodeHookInvocationSetting> builder(MarshallingType.SDK_POJO).memberName("elicitationCodeHook")
            .getter(getter(SlotCaptureSetting::elicitationCodeHook)).setter(setter(Builder::elicitationCodeHook))
            .constructor(ElicitationCodeHookInvocationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elicitationCodeHook").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_RESPONSE_FIELD,
            CAPTURE_NEXT_STEP_FIELD, CAPTURE_CONDITIONAL_FIELD, FAILURE_RESPONSE_FIELD, FAILURE_NEXT_STEP_FIELD,
            FAILURE_CONDITIONAL_FIELD, CODE_HOOK_FIELD, ELICITATION_CODE_HOOK_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResponseSpecification captureResponse;

    private final DialogState captureNextStep;

    private final ConditionalSpecification captureConditional;

    private final ResponseSpecification failureResponse;

    private final DialogState failureNextStep;

    private final ConditionalSpecification failureConditional;

    private final DialogCodeHookInvocationSetting codeHook;

    private final ElicitationCodeHookInvocationSetting elicitationCodeHook;

    private SlotCaptureSetting(BuilderImpl builder) {
        this.captureResponse = builder.captureResponse;
        this.captureNextStep = builder.captureNextStep;
        this.captureConditional = builder.captureConditional;
        this.failureResponse = builder.failureResponse;
        this.failureNextStep = builder.failureNextStep;
        this.failureConditional = builder.failureConditional;
        this.codeHook = builder.codeHook;
        this.elicitationCodeHook = builder.elicitationCodeHook;
    }

    /**
     * Returns the value of the CaptureResponse property for this object.
     * 
     * @return The value of the CaptureResponse property for this object.
     */
    public final ResponseSpecification captureResponse() {
        return captureResponse;
    }

    /**
     * <p>
     * Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
     * </p>
     * 
     * @return Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
     */
    public final DialogState captureNextStep() {
        return captureNextStep;
    }

    /**
     * <p>
     * A list of conditional branches to evaluate after the slot value is captured.
     * </p>
     * 
     * @return A list of conditional branches to evaluate after the slot value is captured.
     */
    public final ConditionalSpecification captureConditional() {
        return captureConditional;
    }

    /**
     * Returns the value of the FailureResponse property for this object.
     * 
     * @return The value of the FailureResponse property for this object.
     */
    public final ResponseSpecification failureResponse() {
        return failureResponse;
    }

    /**
     * <p>
     * Specifies the next step that the bot runs when the slot value code is not recognized.
     * </p>
     * 
     * @return Specifies the next step that the bot runs when the slot value code is not recognized.
     */
    public final DialogState failureNextStep() {
        return failureNextStep;
    }

    /**
     * <p>
     * A list of conditional branches to evaluate when the slot value isn't captured.
     * </p>
     * 
     * @return A list of conditional branches to evaluate when the slot value isn't captured.
     */
    public final ConditionalSpecification failureConditional() {
        return failureConditional;
    }

    /**
     * <p>
     * Code hook called after Amazon Lex successfully captures a slot value.
     * </p>
     * 
     * @return Code hook called after Amazon Lex successfully captures a slot value.
     */
    public final DialogCodeHookInvocationSetting codeHook() {
        return codeHook;
    }

    /**
     * <p>
     * Code hook called when Amazon Lex doesn't capture a slot value.
     * </p>
     * 
     * @return Code hook called when Amazon Lex doesn't capture a slot value.
     */
    public final ElicitationCodeHookInvocationSetting elicitationCodeHook() {
        return elicitationCodeHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captureResponse());
        hashCode = 31 * hashCode + Objects.hashCode(captureNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(captureConditional());
        hashCode = 31 * hashCode + Objects.hashCode(failureResponse());
        hashCode = 31 * hashCode + Objects.hashCode(failureNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(failureConditional());
        hashCode = 31 * hashCode + Objects.hashCode(codeHook());
        hashCode = 31 * hashCode + Objects.hashCode(elicitationCodeHook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotCaptureSetting)) {
            return false;
        }
        SlotCaptureSetting other = (SlotCaptureSetting) obj;
        return Objects.equals(captureResponse(), other.captureResponse())
                && Objects.equals(captureNextStep(), other.captureNextStep())
                && Objects.equals(captureConditional(), other.captureConditional())
                && Objects.equals(failureResponse(), other.failureResponse())
                && Objects.equals(failureNextStep(), other.failureNextStep())
                && Objects.equals(failureConditional(), other.failureConditional())
                && Objects.equals(codeHook(), other.codeHook())
                && Objects.equals(elicitationCodeHook(), other.elicitationCodeHook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotCaptureSetting").add("CaptureResponse", captureResponse())
                .add("CaptureNextStep", captureNextStep()).add("CaptureConditional", captureConditional())
                .add("FailureResponse", failureResponse()).add("FailureNextStep", failureNextStep())
                .add("FailureConditional", failureConditional()).add("CodeHook", codeHook())
                .add("ElicitationCodeHook", elicitationCodeHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "captureResponse":
            return Optional.ofNullable(clazz.cast(captureResponse()));
        case "captureNextStep":
            return Optional.ofNullable(clazz.cast(captureNextStep()));
        case "captureConditional":
            return Optional.ofNullable(clazz.cast(captureConditional()));
        case "failureResponse":
            return Optional.ofNullable(clazz.cast(failureResponse()));
        case "failureNextStep":
            return Optional.ofNullable(clazz.cast(failureNextStep()));
        case "failureConditional":
            return Optional.ofNullable(clazz.cast(failureConditional()));
        case "codeHook":
            return Optional.ofNullable(clazz.cast(codeHook()));
        case "elicitationCodeHook":
            return Optional.ofNullable(clazz.cast(elicitationCodeHook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotCaptureSetting, T> g) {
        return obj -> g.apply((SlotCaptureSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotCaptureSetting> {
        /**
         * Sets the value of the CaptureResponse property for this object.
         *
         * @param captureResponse
         *        The new value for the CaptureResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureResponse(ResponseSpecification captureResponse);

        /**
         * Sets the value of the CaptureResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #captureResponse(ResponseSpecification)}.
         * 
         * @param captureResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captureResponse(ResponseSpecification)
         */
        default Builder captureResponse(Consumer<ResponseSpecification.Builder> captureResponse) {
            return captureResponse(ResponseSpecification.builder().applyMutation(captureResponse).build());
        }

        /**
         * <p>
         * Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
         * </p>
         * 
         * @param captureNextStep
         *        Specifies the next step that the bot runs when the slot value is captured before the code hook times
         *        out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureNextStep(DialogState captureNextStep);

        /**
         * <p>
         * Specifies the next step that the bot runs when the slot value is captured before the code hook times out.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #captureNextStep(DialogState)}.
         * 
         * @param captureNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captureNextStep(DialogState)
         */
        default Builder captureNextStep(Consumer<DialogState.Builder> captureNextStep) {
            return captureNextStep(DialogState.builder().applyMutation(captureNextStep).build());
        }

        /**
         * <p>
         * A list of conditional branches to evaluate after the slot value is captured.
         * </p>
         * 
         * @param captureConditional
         *        A list of conditional branches to evaluate after the slot value is captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureConditional(ConditionalSpecification captureConditional);

        /**
         * <p>
         * A list of conditional branches to evaluate after the slot value is captured.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #captureConditional(ConditionalSpecification)}.
         * 
         * @param captureConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captureConditional(ConditionalSpecification)
         */
        default Builder captureConditional(Consumer<ConditionalSpecification.Builder> captureConditional) {
            return captureConditional(ConditionalSpecification.builder().applyMutation(captureConditional).build());
        }

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * @param failureResponse
         *        The new value for the FailureResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureResponse(ResponseSpecification failureResponse);

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #failureResponse(ResponseSpecification)}.
         * 
         * @param failureResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureResponse(ResponseSpecification)
         */
        default Builder failureResponse(Consumer<ResponseSpecification.Builder> failureResponse) {
            return failureResponse(ResponseSpecification.builder().applyMutation(failureResponse).build());
        }

        /**
         * <p>
         * Specifies the next step that the bot runs when the slot value code is not recognized.
         * </p>
         * 
         * @param failureNextStep
         *        Specifies the next step that the bot runs when the slot value code is not recognized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureNextStep(DialogState failureNextStep);

        /**
         * <p>
         * Specifies the next step that the bot runs when the slot value code is not recognized.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #failureNextStep(DialogState)}.
         * 
         * @param failureNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureNextStep(DialogState)
         */
        default Builder failureNextStep(Consumer<DialogState.Builder> failureNextStep) {
            return failureNextStep(DialogState.builder().applyMutation(failureNextStep).build());
        }

        /**
         * <p>
         * A list of conditional branches to evaluate when the slot value isn't captured.
         * </p>
         * 
         * @param failureConditional
         *        A list of conditional branches to evaluate when the slot value isn't captured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureConditional(ConditionalSpecification failureConditional);

        /**
         * <p>
         * A list of conditional branches to evaluate when the slot value isn't captured.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #failureConditional(ConditionalSpecification)}.
         * 
         * @param failureConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureConditional(ConditionalSpecification)
         */
        default Builder failureConditional(Consumer<ConditionalSpecification.Builder> failureConditional) {
            return failureConditional(ConditionalSpecification.builder().applyMutation(failureConditional).build());
        }

        /**
         * <p>
         * Code hook called after Amazon Lex successfully captures a slot value.
         * </p>
         * 
         * @param codeHook
         *        Code hook called after Amazon Lex successfully captures a slot value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHook(DialogCodeHookInvocationSetting codeHook);

        /**
         * <p>
         * Code hook called after Amazon Lex successfully captures a slot value.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogCodeHookInvocationSetting.Builder}
         * avoiding the need to create one manually via {@link DialogCodeHookInvocationSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link DialogCodeHookInvocationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #codeHook(DialogCodeHookInvocationSetting)}.
         * 
         * @param codeHook
         *        a consumer that will call methods on {@link DialogCodeHookInvocationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeHook(DialogCodeHookInvocationSetting)
         */
        default Builder codeHook(Consumer<DialogCodeHookInvocationSetting.Builder> codeHook) {
            return codeHook(DialogCodeHookInvocationSetting.builder().applyMutation(codeHook).build());
        }

        /**
         * <p>
         * Code hook called when Amazon Lex doesn't capture a slot value.
         * </p>
         * 
         * @param elicitationCodeHook
         *        Code hook called when Amazon Lex doesn't capture a slot value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elicitationCodeHook(ElicitationCodeHookInvocationSetting elicitationCodeHook);

        /**
         * <p>
         * Code hook called when Amazon Lex doesn't capture a slot value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ElicitationCodeHookInvocationSetting.Builder} avoiding the need to create one manually via
         * {@link ElicitationCodeHookInvocationSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElicitationCodeHookInvocationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #elicitationCodeHook(ElicitationCodeHookInvocationSetting)}.
         * 
         * @param elicitationCodeHook
         *        a consumer that will call methods on {@link ElicitationCodeHookInvocationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elicitationCodeHook(ElicitationCodeHookInvocationSetting)
         */
        default Builder elicitationCodeHook(Consumer<ElicitationCodeHookInvocationSetting.Builder> elicitationCodeHook) {
            return elicitationCodeHook(ElicitationCodeHookInvocationSetting.builder().applyMutation(elicitationCodeHook).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResponseSpecification captureResponse;

        private DialogState captureNextStep;

        private ConditionalSpecification captureConditional;

        private ResponseSpecification failureResponse;

        private DialogState failureNextStep;

        private ConditionalSpecification failureConditional;

        private DialogCodeHookInvocationSetting codeHook;

        private ElicitationCodeHookInvocationSetting elicitationCodeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotCaptureSetting model) {
            captureResponse(model.captureResponse);
            captureNextStep(model.captureNextStep);
            captureConditional(model.captureConditional);
            failureResponse(model.failureResponse);
            failureNextStep(model.failureNextStep);
            failureConditional(model.failureConditional);
            codeHook(model.codeHook);
            elicitationCodeHook(model.elicitationCodeHook);
        }

        public final ResponseSpecification.Builder getCaptureResponse() {
            return captureResponse != null ? captureResponse.toBuilder() : null;
        }

        public final void setCaptureResponse(ResponseSpecification.BuilderImpl captureResponse) {
            this.captureResponse = captureResponse != null ? captureResponse.build() : null;
        }

        @Override
        public final Builder captureResponse(ResponseSpecification captureResponse) {
            this.captureResponse = captureResponse;
            return this;
        }

        public final DialogState.Builder getCaptureNextStep() {
            return captureNextStep != null ? captureNextStep.toBuilder() : null;
        }

        public final void setCaptureNextStep(DialogState.BuilderImpl captureNextStep) {
            this.captureNextStep = captureNextStep != null ? captureNextStep.build() : null;
        }

        @Override
        public final Builder captureNextStep(DialogState captureNextStep) {
            this.captureNextStep = captureNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getCaptureConditional() {
            return captureConditional != null ? captureConditional.toBuilder() : null;
        }

        public final void setCaptureConditional(ConditionalSpecification.BuilderImpl captureConditional) {
            this.captureConditional = captureConditional != null ? captureConditional.build() : null;
        }

        @Override
        public final Builder captureConditional(ConditionalSpecification captureConditional) {
            this.captureConditional = captureConditional;
            return this;
        }

        public final ResponseSpecification.Builder getFailureResponse() {
            return failureResponse != null ? failureResponse.toBuilder() : null;
        }

        public final void setFailureResponse(ResponseSpecification.BuilderImpl failureResponse) {
            this.failureResponse = failureResponse != null ? failureResponse.build() : null;
        }

        @Override
        public final Builder failureResponse(ResponseSpecification failureResponse) {
            this.failureResponse = failureResponse;
            return this;
        }

        public final DialogState.Builder getFailureNextStep() {
            return failureNextStep != null ? failureNextStep.toBuilder() : null;
        }

        public final void setFailureNextStep(DialogState.BuilderImpl failureNextStep) {
            this.failureNextStep = failureNextStep != null ? failureNextStep.build() : null;
        }

        @Override
        public final Builder failureNextStep(DialogState failureNextStep) {
            this.failureNextStep = failureNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getFailureConditional() {
            return failureConditional != null ? failureConditional.toBuilder() : null;
        }

        public final void setFailureConditional(ConditionalSpecification.BuilderImpl failureConditional) {
            this.failureConditional = failureConditional != null ? failureConditional.build() : null;
        }

        @Override
        public final Builder failureConditional(ConditionalSpecification failureConditional) {
            this.failureConditional = failureConditional;
            return this;
        }

        public final DialogCodeHookInvocationSetting.Builder getCodeHook() {
            return codeHook != null ? codeHook.toBuilder() : null;
        }

        public final void setCodeHook(DialogCodeHookInvocationSetting.BuilderImpl codeHook) {
            this.codeHook = codeHook != null ? codeHook.build() : null;
        }

        @Override
        public final Builder codeHook(DialogCodeHookInvocationSetting codeHook) {
            this.codeHook = codeHook;
            return this;
        }

        public final ElicitationCodeHookInvocationSetting.Builder getElicitationCodeHook() {
            return elicitationCodeHook != null ? elicitationCodeHook.toBuilder() : null;
        }

        public final void setElicitationCodeHook(ElicitationCodeHookInvocationSetting.BuilderImpl elicitationCodeHook) {
            this.elicitationCodeHook = elicitationCodeHook != null ? elicitationCodeHook.build() : null;
        }

        @Override
        public final Builder elicitationCodeHook(ElicitationCodeHookInvocationSetting elicitationCodeHook) {
            this.elicitationCodeHook = elicitationCodeHook;
            return this;
        }

        @Override
        public SlotCaptureSetting build() {
            return new SlotCaptureSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
