/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that you can use for eliciting a slot value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotValueElicitationSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SlotValueElicitationSetting.Builder, SlotValueElicitationSetting> {
    private static final SdkField<SlotDefaultValueSpecification> DEFAULT_VALUE_SPECIFICATION_FIELD = SdkField
            .<SlotDefaultValueSpecification> builder(MarshallingType.SDK_POJO).memberName("defaultValueSpecification")
            .getter(getter(SlotValueElicitationSetting::defaultValueSpecification))
            .setter(setter(Builder::defaultValueSpecification)).constructor(SlotDefaultValueSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValueSpecification").build())
            .build();

    private static final SdkField<String> SLOT_CONSTRAINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotConstraint").getter(getter(SlotValueElicitationSetting::slotConstraintAsString))
            .setter(setter(Builder::slotConstraint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotConstraint").build()).build();

    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField
            .<PromptSpecification> builder(MarshallingType.SDK_POJO).memberName("promptSpecification")
            .getter(getter(SlotValueElicitationSetting::promptSpecification)).setter(setter(Builder::promptSpecification))
            .constructor(PromptSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build())
            .build();

    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<SampleUtterance>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(SlotValueElicitationSetting::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleUtterance> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleUtterance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WaitAndContinueSpecification> WAIT_AND_CONTINUE_SPECIFICATION_FIELD = SdkField
            .<WaitAndContinueSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("waitAndContinueSpecification")
            .getter(getter(SlotValueElicitationSetting::waitAndContinueSpecification))
            .setter(setter(Builder::waitAndContinueSpecification))
            .constructor(WaitAndContinueSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitAndContinueSpecification")
                    .build()).build();

    private static final SdkField<SlotCaptureSetting> SLOT_CAPTURE_SETTING_FIELD = SdkField
            .<SlotCaptureSetting> builder(MarshallingType.SDK_POJO).memberName("slotCaptureSetting")
            .getter(getter(SlotValueElicitationSetting::slotCaptureSetting)).setter(setter(Builder::slotCaptureSetting))
            .constructor(SlotCaptureSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotCaptureSetting").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_VALUE_SPECIFICATION_FIELD, SLOT_CONSTRAINT_FIELD, PROMPT_SPECIFICATION_FIELD, SAMPLE_UTTERANCES_FIELD,
            WAIT_AND_CONTINUE_SPECIFICATION_FIELD, SLOT_CAPTURE_SETTING_FIELD));

    private static final long serialVersionUID = 1L;

    private final SlotDefaultValueSpecification defaultValueSpecification;

    private final String slotConstraint;

    private final PromptSpecification promptSpecification;

    private final List<SampleUtterance> sampleUtterances;

    private final WaitAndContinueSpecification waitAndContinueSpecification;

    private final SlotCaptureSetting slotCaptureSetting;

    private SlotValueElicitationSetting(BuilderImpl builder) {
        this.defaultValueSpecification = builder.defaultValueSpecification;
        this.slotConstraint = builder.slotConstraint;
        this.promptSpecification = builder.promptSpecification;
        this.sampleUtterances = builder.sampleUtterances;
        this.waitAndContinueSpecification = builder.waitAndContinueSpecification;
        this.slotCaptureSetting = builder.slotCaptureSetting;
    }

    /**
     * <p>
     * A list of default values for a slot. Default values are used when Amazon Lex hasn't determined a value for a
     * slot. You can specify default values from context variables, session attributes, and defined values.
     * </p>
     * 
     * @return A list of default values for a slot. Default values are used when Amazon Lex hasn't determined a value
     *         for a slot. You can specify default values from context variables, session attributes, and defined
     *         values.
     */
    public final SlotDefaultValueSpecification defaultValueSpecification() {
        return defaultValueSpecification;
    }

    /**
     * <p>
     * Specifies whether the slot is required or optional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotConstraint}
     * will return {@link SlotConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slotConstraintAsString}.
     * </p>
     * 
     * @return Specifies whether the slot is required or optional.
     * @see SlotConstraint
     */
    public final SlotConstraint slotConstraint() {
        return SlotConstraint.fromValue(slotConstraint);
    }

    /**
     * <p>
     * Specifies whether the slot is required or optional.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotConstraint}
     * will return {@link SlotConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slotConstraintAsString}.
     * </p>
     * 
     * @return Specifies whether the slot is required or optional.
     * @see SlotConstraint
     */
    public final String slotConstraintAsString() {
        return slotConstraint;
    }

    /**
     * <p>
     * The prompt that Amazon Lex uses to elicit the slot value from the user.
     * </p>
     * 
     * @return The prompt that Amazon Lex uses to elicit the slot value from the user.
     */
    public final PromptSpecification promptSpecification() {
        return promptSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleUtterances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can
     * provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of
     * understanding user utterances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleUtterances} method.
     * </p>
     * 
     * @return If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you
     *         can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable
     *         of understanding user utterances.
     */
    public final List<SampleUtterance> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * Returns the value of the WaitAndContinueSpecification property for this object.
     * 
     * @return The value of the WaitAndContinueSpecification property for this object.
     */
    public final WaitAndContinueSpecification waitAndContinueSpecification() {
        return waitAndContinueSpecification;
    }

    /**
     * <p>
     * Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
     * </p>
     * 
     * @return Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
     */
    public final SlotCaptureSetting slotCaptureSetting() {
        return slotCaptureSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValueSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(slotConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(waitAndContinueSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(slotCaptureSetting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValueElicitationSetting)) {
            return false;
        }
        SlotValueElicitationSetting other = (SlotValueElicitationSetting) obj;
        return Objects.equals(defaultValueSpecification(), other.defaultValueSpecification())
                && Objects.equals(slotConstraintAsString(), other.slotConstraintAsString())
                && Objects.equals(promptSpecification(), other.promptSpecification())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(waitAndContinueSpecification(), other.waitAndContinueSpecification())
                && Objects.equals(slotCaptureSetting(), other.slotCaptureSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotValueElicitationSetting").add("DefaultValueSpecification", defaultValueSpecification())
                .add("SlotConstraint", slotConstraintAsString()).add("PromptSpecification", promptSpecification())
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("WaitAndContinueSpecification", waitAndContinueSpecification())
                .add("SlotCaptureSetting", slotCaptureSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultValueSpecification":
            return Optional.ofNullable(clazz.cast(defaultValueSpecification()));
        case "slotConstraint":
            return Optional.ofNullable(clazz.cast(slotConstraintAsString()));
        case "promptSpecification":
            return Optional.ofNullable(clazz.cast(promptSpecification()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "waitAndContinueSpecification":
            return Optional.ofNullable(clazz.cast(waitAndContinueSpecification()));
        case "slotCaptureSetting":
            return Optional.ofNullable(clazz.cast(slotCaptureSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotValueElicitationSetting, T> g) {
        return obj -> g.apply((SlotValueElicitationSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotValueElicitationSetting> {
        /**
         * <p>
         * A list of default values for a slot. Default values are used when Amazon Lex hasn't determined a value for a
         * slot. You can specify default values from context variables, session attributes, and defined values.
         * </p>
         * 
         * @param defaultValueSpecification
         *        A list of default values for a slot. Default values are used when Amazon Lex hasn't determined a value
         *        for a slot. You can specify default values from context variables, session attributes, and defined
         *        values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValueSpecification(SlotDefaultValueSpecification defaultValueSpecification);

        /**
         * <p>
         * A list of default values for a slot. Default values are used when Amazon Lex hasn't determined a value for a
         * slot. You can specify default values from context variables, session attributes, and defined values.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotDefaultValueSpecification.Builder}
         * avoiding the need to create one manually via {@link SlotDefaultValueSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotDefaultValueSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultValueSpecification(SlotDefaultValueSpecification)}.
         * 
         * @param defaultValueSpecification
         *        a consumer that will call methods on {@link SlotDefaultValueSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValueSpecification(SlotDefaultValueSpecification)
         */
        default Builder defaultValueSpecification(Consumer<SlotDefaultValueSpecification.Builder> defaultValueSpecification) {
            return defaultValueSpecification(SlotDefaultValueSpecification.builder().applyMutation(defaultValueSpecification)
                    .build());
        }

        /**
         * <p>
         * Specifies whether the slot is required or optional.
         * </p>
         * 
         * @param slotConstraint
         *        Specifies whether the slot is required or optional.
         * @see SlotConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotConstraint
         */
        Builder slotConstraint(String slotConstraint);

        /**
         * <p>
         * Specifies whether the slot is required or optional.
         * </p>
         * 
         * @param slotConstraint
         *        Specifies whether the slot is required or optional.
         * @see SlotConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotConstraint
         */
        Builder slotConstraint(SlotConstraint slotConstraint);

        /**
         * <p>
         * The prompt that Amazon Lex uses to elicit the slot value from the user.
         * </p>
         * 
         * @param promptSpecification
         *        The prompt that Amazon Lex uses to elicit the slot value from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSpecification(PromptSpecification promptSpecification);

        /**
         * <p>
         * The prompt that Amazon Lex uses to elicit the slot value from the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptSpecification.Builder} avoiding the
         * need to create one manually via {@link PromptSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PromptSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #promptSpecification(PromptSpecification)}.
         * 
         * @param promptSpecification
         *        a consumer that will call methods on {@link PromptSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptSpecification(PromptSpecification)
         */
        default Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return promptSpecification(PromptSpecification.builder().applyMutation(promptSpecification).build());
        }

        /**
         * <p>
         * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can
         * provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of
         * understanding user utterances.
         * </p>
         * 
         * @param sampleUtterances
         *        If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you
         *        can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is
         *        capable of understanding user utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances);

        /**
         * <p>
         * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can
         * provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of
         * understanding user utterances.
         * </p>
         * 
         * @param sampleUtterances
         *        If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you
         *        can provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is
         *        capable of understanding user utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(SampleUtterance... sampleUtterances);

        /**
         * <p>
         * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can
         * provide those utterances to improve accuracy. This is optional. In most cases, Amazon Lex is capable of
         * understanding user utterances.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SampleUtterance>.Builder} avoiding
         * the need to create one manually via {@link List<SampleUtterance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SampleUtterance>.Builder#build()} is called immediately and
         * its result is passed to {@link #sampleUtterances(List<SampleUtterance>)}.
         * 
         * @param sampleUtterances
         *        a consumer that will call methods on {@link List<SampleUtterance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleUtterances(List<SampleUtterance>)
         */
        Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances);

        /**
         * Sets the value of the WaitAndContinueSpecification property for this object.
         *
         * @param waitAndContinueSpecification
         *        The new value for the WaitAndContinueSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitAndContinueSpecification(WaitAndContinueSpecification waitAndContinueSpecification);

        /**
         * Sets the value of the WaitAndContinueSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link WaitAndContinueSpecification.Builder}
         * avoiding the need to create one manually via {@link WaitAndContinueSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link WaitAndContinueSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #waitAndContinueSpecification(WaitAndContinueSpecification)}.
         * 
         * @param waitAndContinueSpecification
         *        a consumer that will call methods on {@link WaitAndContinueSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitAndContinueSpecification(WaitAndContinueSpecification)
         */
        default Builder waitAndContinueSpecification(Consumer<WaitAndContinueSpecification.Builder> waitAndContinueSpecification) {
            return waitAndContinueSpecification(WaitAndContinueSpecification.builder()
                    .applyMutation(waitAndContinueSpecification).build());
        }

        /**
         * <p>
         * Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
         * </p>
         * 
         * @param slotCaptureSetting
         *        Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotCaptureSetting(SlotCaptureSetting slotCaptureSetting);

        /**
         * <p>
         * Specifies the settings that Amazon Lex uses when a slot value is successfully entered by a user.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlotCaptureSetting.Builder} avoiding the
         * need to create one manually via {@link SlotCaptureSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotCaptureSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #slotCaptureSetting(SlotCaptureSetting)}.
         * 
         * @param slotCaptureSetting
         *        a consumer that will call methods on {@link SlotCaptureSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotCaptureSetting(SlotCaptureSetting)
         */
        default Builder slotCaptureSetting(Consumer<SlotCaptureSetting.Builder> slotCaptureSetting) {
            return slotCaptureSetting(SlotCaptureSetting.builder().applyMutation(slotCaptureSetting).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SlotDefaultValueSpecification defaultValueSpecification;

        private String slotConstraint;

        private PromptSpecification promptSpecification;

        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private WaitAndContinueSpecification waitAndContinueSpecification;

        private SlotCaptureSetting slotCaptureSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotValueElicitationSetting model) {
            defaultValueSpecification(model.defaultValueSpecification);
            slotConstraint(model.slotConstraint);
            promptSpecification(model.promptSpecification);
            sampleUtterances(model.sampleUtterances);
            waitAndContinueSpecification(model.waitAndContinueSpecification);
            slotCaptureSetting(model.slotCaptureSetting);
        }

        public final SlotDefaultValueSpecification.Builder getDefaultValueSpecification() {
            return defaultValueSpecification != null ? defaultValueSpecification.toBuilder() : null;
        }

        public final void setDefaultValueSpecification(SlotDefaultValueSpecification.BuilderImpl defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification != null ? defaultValueSpecification.build() : null;
        }

        @Override
        public final Builder defaultValueSpecification(SlotDefaultValueSpecification defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification;
            return this;
        }

        public final String getSlotConstraint() {
            return slotConstraint;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint == null ? null : slotConstraint.toString());
            return this;
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return promptSpecification != null ? promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances) {
            sampleUtterances(Stream.of(sampleUtterances).map(c -> SampleUtterance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final WaitAndContinueSpecification.Builder getWaitAndContinueSpecification() {
            return waitAndContinueSpecification != null ? waitAndContinueSpecification.toBuilder() : null;
        }

        public final void setWaitAndContinueSpecification(WaitAndContinueSpecification.BuilderImpl waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification != null ? waitAndContinueSpecification.build()
                    : null;
        }

        @Override
        public final Builder waitAndContinueSpecification(WaitAndContinueSpecification waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification;
            return this;
        }

        public final SlotCaptureSetting.Builder getSlotCaptureSetting() {
            return slotCaptureSetting != null ? slotCaptureSetting.toBuilder() : null;
        }

        public final void setSlotCaptureSetting(SlotCaptureSetting.BuilderImpl slotCaptureSetting) {
            this.slotCaptureSetting = slotCaptureSetting != null ? slotCaptureSetting.build() : null;
        }

        @Override
        public final Builder slotCaptureSetting(SlotCaptureSetting slotCaptureSetting) {
            this.slotCaptureSetting = slotCaptureSetting;
            return this;
        }

        @Override
        public SlotValueElicitationSetting build() {
            return new SlotValueElicitationSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
