/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each slot type can have a set of values. Each <code>SlotTypeValue</code> represents a value that the slot type can
 * take.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotTypeValue implements SdkPojo, Serializable, ToCopyableBuilder<SlotTypeValue.Builder, SlotTypeValue> {
    private static final SdkField<SampleValue> SAMPLE_VALUE_FIELD = SdkField.<SampleValue> builder(MarshallingType.SDK_POJO)
            .memberName("sampleValue").getter(getter(SlotTypeValue::sampleValue)).setter(setter(Builder::sampleValue))
            .constructor(SampleValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleValue").build()).build();

    private static final SdkField<List<SampleValue>> SYNONYMS_FIELD = SdkField
            .<List<SampleValue>> builder(MarshallingType.LIST)
            .memberName("synonyms")
            .getter(getter(SlotTypeValue::synonyms))
            .setter(setter(Builder::synonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("synonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLE_VALUE_FIELD,
            SYNONYMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SampleValue sampleValue;

    private final List<SampleValue> synonyms;

    private SlotTypeValue(BuilderImpl builder) {
        this.sampleValue = builder.sampleValue;
        this.synonyms = builder.synonyms;
    }

    /**
     * <p>
     * The value of the slot type entry.
     * </p>
     * 
     * @return The value of the slot type entry.
     */
    public final SampleValue sampleValue() {
        return sampleValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Synonyms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSynonyms() {
        return synonyms != null && !(synonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional values related to the slot type entry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSynonyms} method.
     * </p>
     * 
     * @return Additional values related to the slot type entry.
     */
    public final List<SampleValue> synonyms() {
        return synonyms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sampleValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasSynonyms() ? synonyms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeValue)) {
            return false;
        }
        SlotTypeValue other = (SlotTypeValue) obj;
        return Objects.equals(sampleValue(), other.sampleValue()) && hasSynonyms() == other.hasSynonyms()
                && Objects.equals(synonyms(), other.synonyms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotTypeValue").add("SampleValue", sampleValue())
                .add("Synonyms", hasSynonyms() ? synonyms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sampleValue":
            return Optional.ofNullable(clazz.cast(sampleValue()));
        case "synonyms":
            return Optional.ofNullable(clazz.cast(synonyms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeValue, T> g) {
        return obj -> g.apply((SlotTypeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotTypeValue> {
        /**
         * <p>
         * The value of the slot type entry.
         * </p>
         * 
         * @param sampleValue
         *        The value of the slot type entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleValue(SampleValue sampleValue);

        /**
         * <p>
         * The value of the slot type entry.
         * </p>
         * This is a convenience method that creates an instance of the {@link SampleValue.Builder} avoiding the need to
         * create one manually via {@link SampleValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SampleValue.Builder#build()} is called immediately and its result
         * is passed to {@link #sampleValue(SampleValue)}.
         * 
         * @param sampleValue
         *        a consumer that will call methods on {@link SampleValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleValue(SampleValue)
         */
        default Builder sampleValue(Consumer<SampleValue.Builder> sampleValue) {
            return sampleValue(SampleValue.builder().applyMutation(sampleValue).build());
        }

        /**
         * <p>
         * Additional values related to the slot type entry.
         * </p>
         * 
         * @param synonyms
         *        Additional values related to the slot type entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonyms(Collection<SampleValue> synonyms);

        /**
         * <p>
         * Additional values related to the slot type entry.
         * </p>
         * 
         * @param synonyms
         *        Additional values related to the slot type entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonyms(SampleValue... synonyms);

        /**
         * <p>
         * Additional values related to the slot type entry.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleValue.Builder#build()} is called immediately
         * and its result is passed to {@link #synonyms(List<SampleValue>)}.
         * 
         * @param synonyms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #synonyms(java.util.Collection<SampleValue>)
         */
        Builder synonyms(Consumer<SampleValue.Builder>... synonyms);
    }

    static final class BuilderImpl implements Builder {
        private SampleValue sampleValue;

        private List<SampleValue> synonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeValue model) {
            sampleValue(model.sampleValue);
            synonyms(model.synonyms);
        }

        public final SampleValue.Builder getSampleValue() {
            return sampleValue != null ? sampleValue.toBuilder() : null;
        }

        public final void setSampleValue(SampleValue.BuilderImpl sampleValue) {
            this.sampleValue = sampleValue != null ? sampleValue.build() : null;
        }

        @Override
        public final Builder sampleValue(SampleValue sampleValue) {
            this.sampleValue = sampleValue;
            return this;
        }

        public final List<SampleValue.Builder> getSynonyms() {
            List<SampleValue.Builder> result = SynonymListCopier.copyToBuilder(this.synonyms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSynonyms(Collection<SampleValue.BuilderImpl> synonyms) {
            this.synonyms = SynonymListCopier.copyFromBuilder(synonyms);
        }

        @Override
        public final Builder synonyms(Collection<SampleValue> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synonyms(SampleValue... synonyms) {
            synonyms(Arrays.asList(synonyms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synonyms(Consumer<SampleValue.Builder>... synonyms) {
            synonyms(Stream.of(synonyms).map(c -> SampleValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SlotTypeValue build() {
            return new SlotTypeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
