/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.BuildBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ConflictException;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.CreateUploadUrlResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyStatementResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.InternalServerException;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Exception;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lexmodelsv2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.StartImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ThrottlingException;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateIntentResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateResourcePolicyResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.UpdateSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.ValidationException;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable;
import software.amazon.awssdk.services.lexmodelsv2.transform.BuildBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateResourcePolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.CreateUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteResourcePolicyStatementRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DeleteSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.DescribeSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotAliasesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotLocalesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListBuiltInSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListSlotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotLocaleRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.transform.UpdateSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelsv2.waiters.LexModelsV2Waiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link LexModelsV2Client}.
 *
 * @see LexModelsV2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLexModelsV2Client implements LexModelsV2Client {
    private static final Logger log = Logger.loggerFor(DefaultLexModelsV2Client.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLexModelsV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales.
     * At runtime the locale is used to choose a specific build of the bot.
     * </p>
     *
     * @param buildBotLocaleRequest
     * @return Result of the BuildBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.BuildBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BuildBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BuildBotLocaleResponse buildBotLocale(BuildBotLocaleRequest buildBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BuildBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BuildBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, buildBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BuildBotLocale");

            return clientHandler.execute(new ClientExecutionParams<BuildBotLocaleRequest, BuildBotLocaleResponse>()
                    .withOperationName("BuildBotLocale").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(buildBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BuildBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot.
     * </p>
     *
     * @param createBotRequest
     * @return Result of the CreateBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBotResponse createBot(CreateBotRequest createBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBot");

            return clientHandler.execute(new ClientExecutionParams<CreateBotRequest, CreateBotResponse>()
                    .withOperationName("CreateBot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBotRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot
     * without updating applications that use the bot.
     * </p>
     * <p>
     * For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot.
     * </p>
     *
     * @param createBotAliasRequest
     * @return Result of the CreateBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBotAliasResponse createBotAlias(CreateBotAliasRequest createBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateBotAliasRequest, CreateBotAliasResponse>()
                    .withOperationName("CreateBotAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations
     * with users in the specified language and locale. You must add a locale to a bot before you can add intents and
     * slot types to the bot.
     * </p>
     *
     * @param createBotLocaleRequest
     * @return Result of the CreateBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBotLocaleResponse createBotLocale(CreateBotLocaleRequest createBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotLocale");

            return clientHandler.execute(new ClientExecutionParams<CreateBotLocaleRequest, CreateBotLocaleResponse>()
                    .withOperationName("CreateBotLocale").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of
     * this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it
     * returns the last created version.
     * </p>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * </p>
     *
     * @param createBotVersionRequest
     * @return Result of the CreateBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBotVersionResponse createBotVersion(CreateBotVersionRequest createBotVersionRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBotVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBotVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateBotVersionRequest, CreateBotVersionResponse>()
                    .withOperationName("CreateBotVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBotVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBotVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory
     * structure that contains JSON files that define the bot.
     * </p>
     * <p>
     * You can create an archive that contains the complete definition of a bot, or you can specify that the archive
     * contain only the definition of a single bot locale.
     * </p>
     * <p>
     * For more information about exporting bots, and about the structure of the export archive, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a>
     * </p>
     *
     * @param createExportRequest
     * @return Result of the CreateExport operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateExportResponse createExport(CreateExportRequest createExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExport");

            return clientHandler.execute(new ClientExecutionParams<CreateExportRequest, CreateExportResponse>()
                    .withOperationName("CreateExport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza
     * ordering bot you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * When you create an intent, you must provide a name. You can optionally provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances
     * for built-in intents.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slots for the information that you bot requests from the user. You can
     * specify standard slot types, such as date and time, or custom slot types for your application.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of
     * the intent information is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example,
     * "Do you want a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     *
     * @param createIntentRequest
     * @return Result of the CreateIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateIntentResponse createIntent(CreateIntentRequest createIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntent");

            return clientHandler.execute(new ClientExecutionParams<CreateIntentRequest, CreateIntentResponse>()
                    .withOperationName("CreateIntent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new resource policy with the specified policy statements.
     * </p>
     *
     * @param createResourcePolicyRequest
     * @return Result of the CreateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws ServiceQuotaExceededException
     * @throws PreconditionFailedException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourcePolicyResponse createResourcePolicy(CreateResourcePolicyRequest createResourcePolicyRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<CreateResourcePolicyRequest, CreateResourcePolicyResponse>()
                    .withOperationName("CreateResourcePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added
     * to the current resource policy. If a policy doesn't exist, a new policy is created.
     * </p>
     * <p>
     * You can't create a resource policy statement that allows cross-account access.
     * </p>
     *
     * @param createResourcePolicyStatementRequest
     * @return Result of the CreateResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws ServiceQuotaExceededException
     * @throws PreconditionFailedException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourcePolicyStatementResponse createResourcePolicyStatement(
            CreateResourcePolicyStatementRequest createResourcePolicyStatementRequest) throws ResourceNotFoundException,
            ConflictException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourcePolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourcePolicyStatementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createResourcePolicyStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourcePolicyStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourcePolicyStatementRequest, CreateResourcePolicyStatementResponse>()
                            .withOperationName("CreateResourcePolicyStatement").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createResourcePolicyStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResourcePolicyStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an
     * <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define
     * one or more utterances that Amazon Lex uses to elicit a response from the user.
     * </p>
     *
     * @param createSlotRequest
     * @return Result of the CreateSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSlotResponse createSlot(CreateSlotRequest createSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlot");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSlotRequest, CreateSlotResponse>().withOperationName("CreateSlot")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSlotRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom slot type
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a
     * slot of this type can assume.
     * </p>
     *
     * @param createSlotTypeRequest
     * @return Result of the CreateSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSlotTypeResponse createSlotType(CreateSlotTypeRequest createSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlotType");

            return clientHandler.execute(new ClientExecutionParams<CreateSlotTypeRequest, CreateSlotTypeResponse>()
                    .withOperationName("CreateSlotType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
     * </p>
     *
     * @param createUploadUrlRequest
     * @return Result of the CreateUploadUrl operation returned by the service.
     * @throws ThrottlingException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.CreateUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/CreateUploadUrl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUploadUrlResponse createUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUploadUrlResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUploadUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUploadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUploadUrl");

            return clientHandler.execute(new ClientExecutionParams<CreateUploadUrlRequest, CreateUploadUrlResponse>()
                    .withOperationName("CreateUploadUrl").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUploadUrlRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUploadUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the
     * <code>DeleteBotVersion</code> operation.
     * </p>
     * <p>
     * When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all
     * locales, intents, slot, and slot types defined for the bot.
     * </p>
     * <p>
     * If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to
     * <code>true</code>.
     * </p>
     *
     * @param deleteBotRequest
     * @return Result of the DeleteBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBotResponse deleteBot(DeleteBotRequest deleteBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBot");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotRequest, DeleteBotResponse>()
                    .withOperationName("DeleteBot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBotRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified bot alias.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return Result of the DeleteBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBotAliasResponse deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotAliasRequest, DeleteBotAliasResponse>()
                    .withOperationName("DeleteBotAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a locale from a bot.
     * </p>
     * <p>
     * When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.
     * </p>
     *
     * @param deleteBotLocaleRequest
     * @return Result of the DeleteBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBotLocaleResponse deleteBotLocale(DeleteBotLocaleRequest deleteBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotLocale");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotLocaleRequest, DeleteBotLocaleResponse>()
                    .withOperationName("DeleteBotLocale").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all version of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return Result of the DeleteBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBotVersionResponse deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBotVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBotVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteBotVersionRequest, DeleteBotVersionResponse>()
                    .withOperationName("DeleteBotVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBotVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBotVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a previous export and the associated files stored in an S3 bucket.
     * </p>
     *
     * @param deleteExportRequest
     * @return Result of the DeleteExport operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteExportResponse deleteExport(DeleteExportRequest deleteExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteExport");

            return clientHandler.execute(new ClientExecutionParams<DeleteExportRequest, DeleteExportResponse>()
                    .withOperationName("DeleteExport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a previous import and the associated file stored in an S3 bucket.
     * </p>
     *
     * @param deleteImportRequest
     * @return Result of the DeleteImport operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteImport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteImportResponse deleteImport(DeleteImportRequest deleteImportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteImportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImport");

            return clientHandler.execute(new ClientExecutionParams<DeleteImportRequest, DeleteImportResponse>()
                    .withOperationName("DeleteImport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteImportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified intent.
     * </p>
     * <p>
     * Deleting an intent also deletes the slots associated with the intent.
     * </p>
     *
     * @param deleteIntentRequest
     * @return Result of the DeleteIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteIntentResponse deleteIntent(DeleteIntentRequest deleteIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntent");

            return clientHandler.execute(new ClientExecutionParams<DeleteIntentRequest, DeleteIntentResponse>()
                    .withOperationName("DeleteIntent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex
     * returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ResourceNotFoundException, PreconditionFailedException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                    .withOperationName("DeleteResourcePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is
     * deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have
     * a policy attached, Amazon Lex returns an exception.
     * </p>
     *
     * @param deleteResourcePolicyStatementRequest
     * @return Result of the DeleteResourcePolicyStatement operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteResourcePolicyStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteResourcePolicyStatement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcePolicyStatementResponse deleteResourcePolicyStatement(
            DeleteResourcePolicyStatementRequest deleteResourcePolicyStatementRequest) throws ResourceNotFoundException,
            PreconditionFailedException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyStatementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyStatementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteResourcePolicyStatementRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicyStatement");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyStatementRequest, DeleteResourcePolicyStatementResponse>()
                            .withOperationName("DeleteResourcePolicyStatement").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourcePolicyStatementRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteResourcePolicyStatementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified slot from an intent.
     * </p>
     *
     * @param deleteSlotRequest
     * @return Result of the DeleteSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSlotResponse deleteSlot(DeleteSlotRequest deleteSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlot");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSlotRequest, DeleteSlotResponse>().withOperationName("DeleteSlot")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSlotRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a slot type from a bot locale.
     * </p>
     * <p>
     * If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the
     * exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return Result of the DeleteSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ConflictException
     * @throws PreconditionFailedException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DeleteSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DeleteSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSlotTypeResponse deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, PreconditionFailedException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlotType");

            return clientHandler.execute(new ClientExecutionParams<DeleteSlotTypeRequest, DeleteSlotTypeResponse>()
                    .withOperationName("DeleteSlotType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides metadata information about a bot.
     * </p>
     *
     * @param describeBotRequest
     * @return Result of the DescribeBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeBotResponse describeBot(DescribeBotRequest describeBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBot");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotRequest, DescribeBotResponse>()
                    .withOperationName("DescribeBot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeBotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get information about a specific bot alias.
     * </p>
     *
     * @param describeBotAliasRequest
     * @return Result of the DescribeBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBotAliasResponse describeBotAlias(DescribeBotAliasRequest describeBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotAlias");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotAliasRequest, DescribeBotAliasResponse>()
                    .withOperationName("DescribeBotAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the settings that a bot has for a specific locale.
     * </p>
     *
     * @param describeBotLocaleRequest
     * @return Result of the DescribeBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotLocale"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBotLocaleResponse describeBotLocale(DescribeBotLocaleRequest describeBotLocaleRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotLocale");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotLocaleRequest, DescribeBotLocaleResponse>()
                    .withOperationName("DescribeBotLocale").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides metadata about a version of a bot.
     * </p>
     *
     * @param describeBotVersionRequest
     * @return Result of the DescribeBotVersion operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeBotVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeBotVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBotVersionResponse describeBotVersion(DescribeBotVersionRequest describeBotVersionRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBotVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBotVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBotVersion");

            return clientHandler.execute(new ClientExecutionParams<DescribeBotVersionRequest, DescribeBotVersionResponse>()
                    .withOperationName("DescribeBotVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeBotVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBotVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specific export.
     * </p>
     *
     * @param describeExportRequest
     * @return Result of the DescribeExport operation returned by the service.
     * @throws ThrottlingException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeExportResponse describeExport(DescribeExportRequest describeExportRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExport");

            return clientHandler.execute(new ClientExecutionParams<DescribeExportRequest, DescribeExportResponse>()
                    .withOperationName("DescribeExport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specific import.
     * </p>
     *
     * @param describeImportRequest
     * @return Result of the DescribeImport operation returned by the service.
     * @throws ThrottlingException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeImport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeImportResponse describeImport(DescribeImportRequest describeImportRequest) throws ThrottlingException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeImportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImport");

            return clientHandler.execute(new ClientExecutionParams<DescribeImportRequest, DescribeImportResponse>()
                    .withOperationName("DescribeImport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeImportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata about an intent.
     * </p>
     *
     * @param describeIntentRequest
     * @return Result of the DescribeIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeIntentResponse describeIntent(DescribeIntentRequest describeIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIntent");

            return clientHandler.execute(new ClientExecutionParams<DescribeIntentRequest, DescribeIntentResponse>()
                    .withOperationName("DescribeIntent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the resource policy and policy revision for a bot or bot alias.
     * </p>
     *
     * @param describeResourcePolicyRequest
     * @return Result of the DescribeResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourcePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse>()
                            .withOperationName("DescribeResourcePolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeResourcePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about a slot.
     * </p>
     *
     * @param describeSlotRequest
     * @return Result of the DescribeSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeSlotResponse describeSlot(DescribeSlotRequest describeSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlot");

            return clientHandler.execute(new ClientExecutionParams<DescribeSlotRequest, DescribeSlotResponse>()
                    .withOperationName("DescribeSlot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeSlotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets metadata information about a slot type.
     * </p>
     *
     * @param describeSlotTypeRequest
     * @return Result of the DescribeSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.DescribeSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/DescribeSlotType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSlotTypeResponse describeSlotType(DescribeSlotTypeRequest describeSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlotType");

            return clientHandler.execute(new ClientExecutionParams<DescribeSlotTypeRequest, DescribeSlotTypeResponse>()
                    .withOperationName("DescribeSlotType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     *
     * @param listBotAliasesRequest
     * @return Result of the ListBotAliases operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotAliasesResponse listBotAliases(ListBotAliasesRequest listBotAliasesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotAliases");

            return clientHandler.execute(new ClientExecutionParams<ListBotAliasesRequest, ListBotAliasesResponse>()
                    .withOperationName("ListBotAliases").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBotAliasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBotAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of aliases for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client
     *             .listBotAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotAliasesIterable responses = client.listBotAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotAliases(software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listBotAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotAliases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotAliasesIterable listBotAliasesPaginator(ListBotAliasesRequest listBotAliasesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBotAliasesIterable(this, applyPaginatorUserAgent(listBotAliasesRequest));
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     *
     * @param listBotLocalesRequest
     * @return Result of the ListBotLocales operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotLocalesResponse listBotLocales(ListBotLocalesRequest listBotLocalesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotLocalesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotLocalesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotLocalesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotLocales");

            return clientHandler.execute(new ClientExecutionParams<ListBotLocalesRequest, ListBotLocalesResponse>()
                    .withOperationName("ListBotLocales").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBotLocalesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBotLocalesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of locales for the specified bot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client
     *             .listBotLocalesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotLocalesIterable responses = client.listBotLocalesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotLocales(software.amazon.awssdk.services.lexmodelsv2.model.ListBotLocalesRequest)} operation.</b>
     * </p>
     *
     * @param listBotLocalesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotLocales
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotLocales" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotLocalesIterable listBotLocalesPaginator(ListBotLocalesRequest listBotLocalesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBotLocalesIterable(this, applyPaginatorUserAgent(listBotLocalesRequest));
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     *
     * @param listBotVersionsRequest
     * @return Result of the ListBotVersions operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotVersionsResponse listBotVersions(ListBotVersionsRequest listBotVersionsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBotVersions");

            return clientHandler.execute(new ClientExecutionParams<ListBotVersionsRequest, ListBotVersionsResponse>()
                    .withOperationName("ListBotVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBotVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBotVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has
     * three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered
     * version and one for the <code>DRAFT</code> version.
     * </p>
     * <p>
     * The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client
     *             .listBotVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotVersionsIterable responses = client.listBotVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBotVersions(software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listBotVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBotVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBotVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBotVersionsIterable listBotVersionsPaginator(ListBotVersionsRequest listBotVersionsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBotVersionsIterable(this, applyPaginatorUserAgent(listBotVersionsRequest));
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     *
     * @param listBotsRequest
     * @return Result of the ListBots operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ThrottlingException, ServiceQuotaExceededException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBots");

            return clientHandler.execute(new ClientExecutionParams<ListBotsRequest, ListBotsResponse>()
                    .withOperationName("ListBots").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBotsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListBotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of available bots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBotsIterable listBotsPaginator(ListBotsRequest listBotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return new ListBotsIterable(this, applyPaginatorUserAgent(listBotsRequest));
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return Result of the ListBuiltInIntents operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBuiltInIntentsResponse listBuiltInIntents(ListBuiltInIntentsRequest listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBuiltInIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBuiltInIntentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuiltInIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuiltInIntents");

            return clientHandler.execute(new ClientExecutionParams<ListBuiltInIntentsRequest, ListBuiltInIntentsResponse>()
                    .withOperationName("ListBuiltInIntents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBuiltInIntentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBuiltInIntentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
     * </p>
     * <p>
     * To use a built-in intent as a the base for your own intent, include the built-in intent signature in the
     * <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more
     * information, see <a>CreateIntent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client
     *             .listBuiltInIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInIntentsIterable responses = client.listBuiltInIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInIntents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBuiltInIntentsIterable listBuiltInIntentsPaginator(ListBuiltInIntentsRequest listBuiltInIntentsRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBuiltInIntentsIterable(this, applyPaginatorUserAgent(listBuiltInIntentsRequest));
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return Result of the ListBuiltInSlotTypes operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBuiltInSlotTypesResponse listBuiltInSlotTypes(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBuiltInSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBuiltInSlotTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBuiltInSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBuiltInSlotTypes");

            return clientHandler.execute(new ClientExecutionParams<ListBuiltInSlotTypesRequest, ListBuiltInSlotTypesResponse>()
                    .withOperationName("ListBuiltInSlotTypes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBuiltInSlotTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBuiltInSlotTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client
     *             .listBuiltInSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListBuiltInSlotTypesIterable responses = client.listBuiltInSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuiltInSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBuiltInSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListBuiltInSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListBuiltInSlotTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBuiltInSlotTypesIterable listBuiltInSlotTypesPaginator(ListBuiltInSlotTypesRequest listBuiltInSlotTypesRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListBuiltInSlotTypesIterable(this, applyPaginatorUserAgent(listBuiltInSlotTypesRequest));
    }

    /**
     * <p>
     * Lists the exports for a bot or bot locale. Exports are kept in the list for 7 days.
     * </p>
     *
     * @param listExportsRequest
     * @return Result of the ListExports operation returned by the service.
     * @throws ThrottlingException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListExportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListExportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listExportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListExports");

            return clientHandler.execute(new ClientExecutionParams<ListExportsRequest, ListExportsResponse>()
                    .withOperationName("ListExports").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listExportsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListExportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the exports for a bot or bot locale. Exports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListExportsIterable(this, applyPaginatorUserAgent(listExportsRequest));
    }

    /**
     * <p>
     * Lists the imports for a bot or bot locale. Imports are kept in the list for 7 days.
     * </p>
     *
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @throws ThrottlingException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImports");

            return clientHandler.execute(new ClientExecutionParams<ListImportsRequest, ListImportsResponse>()
                    .withOperationName("ListImports").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listImportsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the imports for a bot or bot locale. Imports are kept in the list for 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.lexmodelsv2.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        return new ListImportsIterable(this, applyPaginatorUserAgent(listImportsRequest));
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     *
     * @param listIntentsRequest
     * @return Result of the ListIntents operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIntentsResponse listIntents(ListIntentsRequest listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIntentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIntentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntents");

            return clientHandler.execute(new ClientExecutionParams<ListIntentsRequest, ListIntentsResponse>()
                    .withOperationName("ListIntents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listIntentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIntentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a list of intents that meet the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListIntentsIterable responses = client.listIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntents(software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest)} operation.</b>
     * </p>
     *
     * @param listIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListIntents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIntentsIterable listIntentsPaginator(ListIntentsRequest listIntentsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return new ListIntentsIterable(this, applyPaginatorUserAgent(listIntentsRequest));
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     *
     * @param listSlotTypesRequest
     * @return Result of the ListSlotTypes operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSlotTypesResponse listSlotTypes(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSlotTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSlotTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSlotTypes");

            return clientHandler.execute(new ClientExecutionParams<ListSlotTypesRequest, ListSlotTypesResponse>()
                    .withOperationName("ListSlotTypes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listSlotTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSlotTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of slot types that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client
     *             .listSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotTypesIterable responses = client.listSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlotTypes(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest)} operation.</b>
     * </p>
     *
     * @param listSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlotTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSlotTypesIterable listSlotTypesPaginator(ListSlotTypesRequest listSlotTypesRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return new ListSlotTypesIterable(this, applyPaginatorUserAgent(listSlotTypesRequest));
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     *
     * @param listSlotsRequest
     * @return Result of the ListSlots operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSlotsResponse listSlots(ListSlotsRequest listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSlotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSlotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSlotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSlots");

            return clientHandler.execute(new ClientExecutionParams<ListSlotsRequest, ListSlotsResponse>()
                    .withOperationName("ListSlots").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listSlotsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListSlotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of slots that match the specified criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelsv2.paginators.ListSlotsIterable responses = client.listSlotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSlots(software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest)} operation.</b>
     * </p>
     *
     * @param listSlotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListSlots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListSlots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSlotsIterable listSlotsPaginator(ListSlotsRequest listSlotsRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        return new ListSlotsIterable(this, applyPaginatorUserAgent(listSlotsRequest));
    }

    /**
     * <p>
     * Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated
     * with them.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts importing a bot or bot locale from a zip archive that you uploaded to an S3 bucket.
     * </p>
     *
     * @param startImportRequest
     * @return Result of the StartImport operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartImportResponse startImport(StartImportRequest startImportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartImportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartImport");

            return clientHandler.execute(new ClientExecutionParams<StartImportRequest, StartImportResponse>()
                    .withOperationName("StartImport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startImportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced
     * with the new value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a bot, bot alias, or bot channel.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws ResourceNotFoundException
     * @throws ValidationException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing bot.
     * </p>
     *
     * @param updateBotRequest
     * @return Result of the UpdateBot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateBotResponse updateBot(UpdateBotRequest updateBotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBot");

            return clientHandler.execute(new ClientExecutionParams<UpdateBotRequest, UpdateBotResponse>()
                    .withOperationName("UpdateBot").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateBotRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing bot alias.
     * </p>
     *
     * @param updateBotAliasRequest
     * @return Result of the UpdateBotAlias operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateBotAliasResponse updateBotAlias(UpdateBotAliasRequest updateBotAliasRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBotAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotAlias");

            return clientHandler.execute(new ClientExecutionParams<UpdateBotAliasRequest, UpdateBotAliasResponse>()
                    .withOperationName("UpdateBotAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateBotAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBotAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings that a bot has for a specific locale.
     * </p>
     *
     * @param updateBotLocaleRequest
     * @return Result of the UpdateBotLocale operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateBotLocale
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateBotLocale" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateBotLocaleResponse updateBotLocale(UpdateBotLocaleRequest updateBotLocaleRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBotLocaleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBotLocaleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBotLocaleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBotLocale");

            return clientHandler.execute(new ClientExecutionParams<UpdateBotLocaleRequest, UpdateBotLocaleResponse>()
                    .withOperationName("UpdateBotLocale").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateBotLocaleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBotLocaleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the password used to protect an export zip archive.
     * </p>
     * <p>
     * The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not
     * protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the
     * operation.
     * </p>
     *
     * @param updateExportRequest
     * @return Result of the UpdateExport operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateExportResponse updateExport(UpdateExportRequest updateExportRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateExportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateExport");

            return clientHandler.execute(new ClientExecutionParams<UpdateExportRequest, UpdateExportResponse>()
                    .withOperationName("UpdateExport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateExportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateExportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings for an intent.
     * </p>
     *
     * @param updateIntentRequest
     * @return Result of the UpdateIntent operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateIntent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateIntentResponse updateIntent(UpdateIntentRequest updateIntentRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIntentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIntentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIntentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIntent");

            return clientHandler.execute(new ClientExecutionParams<UpdateIntentRequest, UpdateIntentResponse>()
                    .withOperationName("UpdateIntent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateIntentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIntentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon
     * Lex returns an exception.
     * </p>
     *
     * @param updateResourcePolicyRequest
     * @return Result of the UpdateResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws ServiceQuotaExceededException
     * @throws PreconditionFailedException
     * @throws ValidationException
     * @throws InternalServerException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateResourcePolicyResponse updateResourcePolicy(UpdateResourcePolicyRequest updateResourcePolicyRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, PreconditionFailedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<UpdateResourcePolicyRequest, UpdateResourcePolicyResponse>()
                    .withOperationName("UpdateResourcePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings for a slot.
     * </p>
     *
     * @param updateSlotRequest
     * @return Result of the UpdateSlot operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSlotResponse updateSlot(UpdateSlotRequest updateSlotRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSlotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSlotResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSlotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSlot");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateSlotRequest, UpdateSlotResponse>().withOperationName("UpdateSlot")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateSlotRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateSlotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an existing slot type.
     * </p>
     *
     * @param updateSlotTypeRequest
     * @return Result of the UpdateSlotType operation returned by the service.
     * @throws ThrottlingException
     * @throws ServiceQuotaExceededException
     * @throws ValidationException
     * @throws PreconditionFailedException
     * @throws ConflictException
     * @throws InternalServerException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelsV2Client.UpdateSlotType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/UpdateSlotType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateSlotTypeResponse updateSlotType(UpdateSlotTypeRequest updateSlotTypeRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, PreconditionFailedException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, LexModelsV2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSlotTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSlotTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lex Models V2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSlotType");

            return clientHandler.execute(new ClientExecutionParams<UpdateSlotTypeRequest, UpdateSlotTypeResponse>()
                    .withOperationName("UpdateSlotType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateSlotTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSlotTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LexModelsV2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends LexModelsV2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public LexModelsV2Waiter waiter() {
        return LexModelsV2Waiter.builder().client(this).build();
    }
}
