/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of audio log files collected when conversation logging is enabled for a bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioLogDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioLogDestination.Builder, AudioLogDestination> {
    private static final SdkField<S3BucketLogDestination> S3_BUCKET_FIELD = SdkField
            .<S3BucketLogDestination> builder(MarshallingType.SDK_POJO).memberName("s3Bucket")
            .getter(getter(AudioLogDestination::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(S3BucketLogDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3BucketLogDestination s3Bucket;

    private AudioLogDestination(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the audio log files are stored. The IAM role specified in the <code>roleArn</code>
     * parameter of the <a>CreateBot</a> operation must have permission to write to this bucket.
     * </p>
     * 
     * @return The Amazon S3 bucket where the audio log files are stored. The IAM role specified in the
     *         <code>roleArn</code> parameter of the <a>CreateBot</a> operation must have permission to write to this
     *         bucket.
     */
    public final S3BucketLogDestination s3Bucket() {
        return s3Bucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioLogDestination)) {
            return false;
        }
        AudioLogDestination other = (AudioLogDestination) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioLogDestination").add("S3Bucket", s3Bucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioLogDestination, T> g) {
        return obj -> g.apply((AudioLogDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioLogDestination> {
        /**
         * <p>
         * The Amazon S3 bucket where the audio log files are stored. The IAM role specified in the <code>roleArn</code>
         * parameter of the <a>CreateBot</a> operation must have permission to write to this bucket.
         * </p>
         * 
         * @param s3Bucket
         *        The Amazon S3 bucket where the audio log files are stored. The IAM role specified in the
         *        <code>roleArn</code> parameter of the <a>CreateBot</a> operation must have permission to write to this
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(S3BucketLogDestination s3Bucket);

        /**
         * <p>
         * The Amazon S3 bucket where the audio log files are stored. The IAM role specified in the <code>roleArn</code>
         * parameter of the <a>CreateBot</a> operation must have permission to write to this bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link S3BucketLogDestination.Builder} avoiding the
         * need to create one manually via {@link S3BucketLogDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3BucketLogDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Bucket(S3BucketLogDestination)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link S3BucketLogDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(S3BucketLogDestination)
         */
        default Builder s3Bucket(Consumer<S3BucketLogDestination.Builder> s3Bucket) {
            return s3Bucket(S3BucketLogDestination.builder().applyMutation(s3Bucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3BucketLogDestination s3Bucket;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioLogDestination model) {
            s3Bucket(model.s3Bucket);
        }

        public final S3BucketLogDestination.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3BucketLogDestination.BuilderImpl s3Bucket) {
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Bucket(S3BucketLogDestination s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        @Override
        public AudioLogDestination build() {
            return new AudioLogDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
