/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for logging audio of conversations between Amazon Lex and a user. You specify whether to log audio and the
 * Amazon S3 bucket where the audio file is stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioLogSetting implements SdkPojo, Serializable, ToCopyableBuilder<AudioLogSetting.Builder, AudioLogSetting> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(AudioLogSetting::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<AudioLogDestination> DESTINATION_FIELD = SdkField
            .<AudioLogDestination> builder(MarshallingType.SDK_POJO).memberName("destination")
            .getter(getter(AudioLogSetting::destination)).setter(setter(Builder::destination))
            .constructor(AudioLogDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final AudioLogDestination destination;

    private AudioLogSetting(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * Determines whether audio logging in enabled for the bot.
     * </p>
     * 
     * @return Determines whether audio logging in enabled for the bot.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final AudioLogDestination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioLogSetting)) {
            return false;
        }
        AudioLogSetting other = (AudioLogSetting) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioLogSetting").add("Enabled", enabled()).add("Destination", destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioLogSetting, T> g) {
        return obj -> g.apply((AudioLogSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioLogSetting> {
        /**
         * <p>
         * Determines whether audio logging in enabled for the bot.
         * </p>
         * 
         * @param enabled
         *        Determines whether audio logging in enabled for the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(AudioLogDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience that creates an instance of the {@link AudioLogDestination.Builder} avoiding the need
         * to create one manually via {@link AudioLogDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioLogDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #destination(AudioLogDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link AudioLogDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(AudioLogDestination)
         */
        default Builder destination(Consumer<AudioLogDestination.Builder> destination) {
            return destination(AudioLogDestination.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private AudioLogDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioLogSetting model) {
            enabled(model.enabled);
            destination(model.destination);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final AudioLogDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(AudioLogDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        @Transient
        public final Builder destination(AudioLogDestination destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public AudioLogSetting build() {
            return new AudioLogSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
