/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about bot locales returned by the <a>ListBotLocales</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotLocaleSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BotLocaleSummary.Builder, BotLocaleSummary> {
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(BotLocaleSummary::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> LOCALE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeName").getter(getter(BotLocaleSummary::localeName)).setter(setter(Builder::localeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BotLocaleSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleStatus").getter(getter(BotLocaleSummary::botLocaleStatusAsString))
            .setter(setter(Builder::botLocaleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(BotLocaleSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<Instant> LAST_BUILD_SUBMITTED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastBuildSubmittedDateTime")
            .getter(getter(BotLocaleSummary::lastBuildSubmittedDateTime))
            .setter(setter(Builder::lastBuildSubmittedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastBuildSubmittedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_ID_FIELD,
            LOCALE_NAME_FIELD, DESCRIPTION_FIELD, BOT_LOCALE_STATUS_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            LAST_BUILD_SUBMITTED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String localeId;

    private final String localeName;

    private final String description;

    private final String botLocaleStatus;

    private final Instant lastUpdatedDateTime;

    private final Instant lastBuildSubmittedDateTime;

    private BotLocaleSummary(BuilderImpl builder) {
        this.localeId = builder.localeId;
        this.localeName = builder.localeName;
        this.description = builder.description;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.lastBuildSubmittedDateTime = builder.lastBuildSubmittedDateTime;
    }

    /**
     * <p>
     * The language and locale of the bot locale.
     * </p>
     * 
     * @return The language and locale of the bot locale.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The name of the bot locale.
     * </p>
     * 
     * @return The name of the bot locale.
     */
    public final String localeName() {
        return localeName;
    }

    /**
     * <p>
     * The description of the bot locale.
     * </p>
     * 
     * @return The description of the bot locale.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.
     * @see BotLocaleStatus
     */
    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(botLocaleStatus);
    }

    /**
     * <p>
     * The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.
     * @see BotLocaleStatus
     */
    public final String botLocaleStatusAsString() {
        return botLocaleStatus;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot locale was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot locale was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * A timestamp of the date and time that the bot locale was last built.
     * </p>
     * 
     * @return A timestamp of the date and time that the bot locale was last built.
     */
    public final Instant lastBuildSubmittedDateTime() {
        return lastBuildSubmittedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(localeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastBuildSubmittedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotLocaleSummary)) {
            return false;
        }
        BotLocaleSummary other = (BotLocaleSummary) obj;
        return Objects.equals(localeId(), other.localeId()) && Objects.equals(localeName(), other.localeName())
                && Objects.equals(description(), other.description())
                && Objects.equals(botLocaleStatusAsString(), other.botLocaleStatusAsString())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(lastBuildSubmittedDateTime(), other.lastBuildSubmittedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotLocaleSummary").add("LocaleId", localeId()).add("LocaleName", localeName())
                .add("Description", description()).add("BotLocaleStatus", botLocaleStatusAsString())
                .add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("LastBuildSubmittedDateTime", lastBuildSubmittedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "localeName":
            return Optional.ofNullable(clazz.cast(localeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botLocaleStatus":
            return Optional.ofNullable(clazz.cast(botLocaleStatusAsString()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "lastBuildSubmittedDateTime":
            return Optional.ofNullable(clazz.cast(lastBuildSubmittedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BotLocaleSummary, T> g) {
        return obj -> g.apply((BotLocaleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotLocaleSummary> {
        /**
         * <p>
         * The language and locale of the bot locale.
         * </p>
         * 
         * @param localeId
         *        The language and locale of the bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The name of the bot locale.
         * </p>
         * 
         * @param localeName
         *        The name of the bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeName(String localeName);

        /**
         * <p>
         * The description of the bot locale.
         * </p>
         * 
         * @param description
         *        The description of the bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.
         * </p>
         * 
         * @param botLocaleStatus
         *        The current status of the bot locale. When the status is <code>Built</code> the locale is ready for
         *        use.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(String botLocaleStatus);

        /**
         * <p>
         * The current status of the bot locale. When the status is <code>Built</code> the locale is ready for use.
         * </p>
         * 
         * @param botLocaleStatus
         *        The current status of the bot locale. When the status is <code>Built</code> the locale is ready for
         *        use.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(BotLocaleStatus botLocaleStatus);

        /**
         * <p>
         * A timestamp of the date and time that the bot locale was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the bot locale was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * A timestamp of the date and time that the bot locale was last built.
         * </p>
         * 
         * @param lastBuildSubmittedDateTime
         *        A timestamp of the date and time that the bot locale was last built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String localeId;

        private String localeName;

        private String description;

        private String botLocaleStatus;

        private Instant lastUpdatedDateTime;

        private Instant lastBuildSubmittedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BotLocaleSummary model) {
            localeId(model.localeId);
            localeName(model.localeName);
            description(model.description);
            botLocaleStatus(model.botLocaleStatus);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            lastBuildSubmittedDateTime(model.lastBuildSubmittedDateTime);
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getLocaleName() {
            return localeName;
        }

        public final void setLocaleName(String localeName) {
            this.localeName = localeName;
        }

        @Override
        @Transient
        public final Builder localeName(String localeName) {
            this.localeName = localeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotLocaleStatus() {
            return botLocaleStatus;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        @Override
        @Transient
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final Instant getLastBuildSubmittedDateTime() {
            return lastBuildSubmittedDateTime;
        }

        public final void setLastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
        }

        @Override
        @Transient
        public final Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
            return this;
        }

        @Override
        public BotLocaleSummary build() {
            return new BotLocaleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
