/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a built-in slot type for the <a>ListBuiltInSlotTypes</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BuiltInSlotTypeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BuiltInSlotTypeSummary.Builder, BuiltInSlotTypeSummary> {
    private static final SdkField<String> SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeSignature").getter(getter(BuiltInSlotTypeSummary::slotTypeSignature))
            .setter(setter(Builder::slotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeSignature").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BuiltInSlotTypeSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_SIGNATURE_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String slotTypeSignature;

    private final String description;

    private BuiltInSlotTypeSummary(BuilderImpl builder) {
        this.slotTypeSignature = builder.slotTypeSignature;
        this.description = builder.description;
    }

    /**
     * <p>
     * The signature of the built-in slot type. Use this to specify the parent slot type of a derived slot type.
     * </p>
     * 
     * @return The signature of the built-in slot type. Use this to specify the parent slot type of a derived slot type.
     */
    public final String slotTypeSignature() {
        return slotTypeSignature;
    }

    /**
     * <p>
     * The description of the built-in slot type.
     * </p>
     * 
     * @return The description of the built-in slot type.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltInSlotTypeSummary)) {
            return false;
        }
        BuiltInSlotTypeSummary other = (BuiltInSlotTypeSummary) obj;
        return Objects.equals(slotTypeSignature(), other.slotTypeSignature())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BuiltInSlotTypeSummary").add("SlotTypeSignature", slotTypeSignature())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypeSignature":
            return Optional.ofNullable(clazz.cast(slotTypeSignature()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BuiltInSlotTypeSummary, T> g) {
        return obj -> g.apply((BuiltInSlotTypeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BuiltInSlotTypeSummary> {
        /**
         * <p>
         * The signature of the built-in slot type. Use this to specify the parent slot type of a derived slot type.
         * </p>
         * 
         * @param slotTypeSignature
         *        The signature of the built-in slot type. Use this to specify the parent slot type of a derived slot
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeSignature(String slotTypeSignature);

        /**
         * <p>
         * The description of the built-in slot type.
         * </p>
         * 
         * @param description
         *        The description of the built-in slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String slotTypeSignature;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltInSlotTypeSummary model) {
            slotTypeSignature(model.slotTypeSignature);
            description(model.description);
        }

        public final String getSlotTypeSignature() {
            return slotTypeSignature;
        }

        public final void setSlotTypeSignature(String slotTypeSignature) {
            this.slotTypeSignature = slotTypeSignature;
        }

        @Override
        @Transient
        public final Builder slotTypeSignature(String slotTypeSignature) {
            this.slotTypeSignature = slotTypeSignature;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public BuiltInSlotTypeSummary build() {
            return new BuiltInSlotTypeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
